@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin

import com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetailsArgs.builder
import com.pulumi.azurenative.delegatednetwork.kotlin.enums.OrchestratorKind
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.ControllerDetailsArgs
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.ControllerDetailsArgsBuilder
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.OrchestratorIdentityArgs
import com.pulumi.azurenative.delegatednetwork.kotlin.inputs.OrchestratorIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an instance of a orchestrator.
 * Azure REST API version: 2021-03-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2023-05-18-preview, 2023-06-27-preview.
 * ## Example Usage
 * ### Create orchestrator instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orchestratorInstanceServiceDetails = new AzureNative.DelegatedNetwork.OrchestratorInstanceServiceDetails("orchestratorInstanceServiceDetails", new()
 *     {
 *         ApiServerEndpoint = "https://testk8s.cloudapp.net",
 *         ClusterRootCA = "ddsadsad344mfdsfdl",
 *         ControllerDetails = new AzureNative.DelegatedNetwork.Inputs.ControllerDetailsArgs
 *         {
 *             Id = "/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller",
 *         },
 *         Identity = new AzureNative.DelegatedNetwork.Inputs.OrchestratorIdentityArgs
 *         {
 *             Type = AzureNative.DelegatedNetwork.ResourceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.DelegatedNetwork.OrchestratorKind.Kubernetes,
 *         Location = "West US",
 *         OrchestratorAppId = "546192d7-503f-477a-9cfe-4efc3ee2b6e1",
 *         OrchestratorTenantId = "da6192d7-503f-477a-9cfe-4efc3ee2b6c3",
 *         PrivateLinkResourceId = "/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/privateLinkServices/plresource1",
 *         ResourceGroupName = "TestRG",
 *         ResourceName = "testk8s1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/delegatednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := delegatednetwork.NewOrchestratorInstanceServiceDetails(ctx, "orchestratorInstanceServiceDetails", &delegatednetwork.OrchestratorInstanceServiceDetailsArgs{
 * 			ApiServerEndpoint: pulumi.String("https://testk8s.cloudapp.net"),
 * 			ClusterRootCA:     pulumi.String("ddsadsad344mfdsfdl"),
 * 			ControllerDetails: &delegatednetwork.ControllerDetailsTypeArgs{
 * 				Id: pulumi.String("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller"),
 * 			},
 * 			Identity: &delegatednetwork.OrchestratorIdentityArgs{
 * 				Type: delegatednetwork.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Kind:                  pulumi.String(delegatednetwork.OrchestratorKindKubernetes),
 * 			Location:              pulumi.String("West US"),
 * 			OrchestratorAppId:     pulumi.String("546192d7-503f-477a-9cfe-4efc3ee2b6e1"),
 * 			OrchestratorTenantId:  pulumi.String("da6192d7-503f-477a-9cfe-4efc3ee2b6c3"),
 * 			PrivateLinkResourceId: pulumi.String("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/privateLinkServices/plresource1"),
 * 			ResourceGroupName:     pulumi.String("TestRG"),
 * 			ResourceName:          pulumi.String("testk8s1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetails;
 * import com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetailsArgs;
 * import com.pulumi.azurenative.delegatednetwork.inputs.ControllerDetailsArgs;
 * import com.pulumi.azurenative.delegatednetwork.inputs.OrchestratorIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orchestratorInstanceServiceDetails = new OrchestratorInstanceServiceDetails("orchestratorInstanceServiceDetails", OrchestratorInstanceServiceDetailsArgs.builder()
 *             .apiServerEndpoint("https://testk8s.cloudapp.net")
 *             .clusterRootCA("ddsadsad344mfdsfdl")
 *             .controllerDetails(ControllerDetailsArgs.builder()
 *                 .id("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.DelegatedNetwork/controller/testcontroller")
 *                 .build())
 *             .identity(OrchestratorIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("Kubernetes")
 *             .location("West US")
 *             .orchestratorAppId("546192d7-503f-477a-9cfe-4efc3ee2b6e1")
 *             .orchestratorTenantId("da6192d7-503f-477a-9cfe-4efc3ee2b6c3")
 *             .privateLinkResourceId("/subscriptions/613192d7-503f-477a-9cfe-4efc3ee2bd60/resourceGroups/TestRG/providers/Microsoft.Network/privateLinkServices/plresource1")
 *             .resourceGroupName("TestRG")
 *             .resourceName("testk8s1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:delegatednetwork:OrchestratorInstanceServiceDetails testk8s1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/orchestrators/{resourceName}
 * ```
 * @property apiServerEndpoint K8s APIServer url. Either one of apiServerEndpoint or privateLinkResourceId can be specified
 * @property clusterRootCA RootCA certificate of kubernetes cluster base64 encoded
 * @property controllerDetails Properties of the controller.
 * @property identity The identity of the orchestrator
 * @property kind The kind of workbook. Choices are user and shared.
 * @property location Location of the resource.
 * @property orchestratorAppId AAD ID used with apiserver
 * @property orchestratorTenantId TenantID of server App ID
 * @property privateLinkResourceId private link arm resource id. Either one of apiServerEndpoint or privateLinkResourceId can be specified
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
 * @property tags The resource tags.
 */
public data class OrchestratorInstanceServiceDetailsArgs(
    public val apiServerEndpoint: Output<String>? = null,
    public val clusterRootCA: Output<String>? = null,
    public val controllerDetails: Output<ControllerDetailsArgs>? = null,
    public val identity: Output<OrchestratorIdentityArgs>? = null,
    public val kind: Output<Either<String, OrchestratorKind>>? = null,
    public val location: Output<String>? = null,
    public val orchestratorAppId: Output<String>? = null,
    public val orchestratorTenantId: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetailsArgs =
        com.pulumi.azurenative.delegatednetwork.OrchestratorInstanceServiceDetailsArgs.builder()
            .apiServerEndpoint(apiServerEndpoint?.applyValue({ args0 -> args0 }))
            .clusterRootCA(clusterRootCA?.applyValue({ args0 -> args0 }))
            .controllerDetails(controllerDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .orchestratorAppId(orchestratorAppId?.applyValue({ args0 -> args0 }))
            .orchestratorTenantId(orchestratorTenantId?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OrchestratorInstanceServiceDetailsArgs].
 */
@PulumiTagMarker
public class OrchestratorInstanceServiceDetailsArgsBuilder internal constructor() {
    private var apiServerEndpoint: Output<String>? = null

    private var clusterRootCA: Output<String>? = null

    private var controllerDetails: Output<ControllerDetailsArgs>? = null

    private var identity: Output<OrchestratorIdentityArgs>? = null

    private var kind: Output<Either<String, OrchestratorKind>>? = null

    private var location: Output<String>? = null

    private var orchestratorAppId: Output<String>? = null

    private var orchestratorTenantId: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value K8s APIServer url. Either one of apiServerEndpoint or privateLinkResourceId can be specified
     */
    @JvmName("osoitikibdaclaii")
    public suspend fun apiServerEndpoint(`value`: Output<String>) {
        this.apiServerEndpoint = value
    }

    /**
     * @param value RootCA certificate of kubernetes cluster base64 encoded
     */
    @JvmName("hnrktnrpqgnplecb")
    public suspend fun clusterRootCA(`value`: Output<String>) {
        this.clusterRootCA = value
    }

    /**
     * @param value Properties of the controller.
     */
    @JvmName("cwdlbjycwjemmyhd")
    public suspend fun controllerDetails(`value`: Output<ControllerDetailsArgs>) {
        this.controllerDetails = value
    }

    /**
     * @param value The identity of the orchestrator
     */
    @JvmName("fnnxoworxikkfnqa")
    public suspend fun identity(`value`: Output<OrchestratorIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind of workbook. Choices are user and shared.
     */
    @JvmName("tjiivipkboivvuvq")
    public suspend fun kind(`value`: Output<Either<String, OrchestratorKind>>) {
        this.kind = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("vttxogscthfqbdnc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value AAD ID used with apiserver
     */
    @JvmName("qjhtwtppieuydyuj")
    public suspend fun orchestratorAppId(`value`: Output<String>) {
        this.orchestratorAppId = value
    }

    /**
     * @param value TenantID of server App ID
     */
    @JvmName("kdoutpdsyulrfrhs")
    public suspend fun orchestratorTenantId(`value`: Output<String>) {
        this.orchestratorTenantId = value
    }

    /**
     * @param value private link arm resource id. Either one of apiServerEndpoint or privateLinkResourceId can be specified
     */
    @JvmName("tcfjtmhugypyggbd")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("euetvyducwhfhhpn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("bhjafohnowijcasw")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("edaxxcpsfohntfab")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value K8s APIServer url. Either one of apiServerEndpoint or privateLinkResourceId can be specified
     */
    @JvmName("rmtxruogcpnewefq")
    public suspend fun apiServerEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiServerEndpoint = mapped
    }

    /**
     * @param value RootCA certificate of kubernetes cluster base64 encoded
     */
    @JvmName("wywhnlfgjnwulpkd")
    public suspend fun clusterRootCA(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterRootCA = mapped
    }

    /**
     * @param value Properties of the controller.
     */
    @JvmName("fbdtfhspgppvyuur")
    public suspend fun controllerDetails(`value`: ControllerDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controllerDetails = mapped
    }

    /**
     * @param argument Properties of the controller.
     */
    @JvmName("vxtqsjlaudrvqiwm")
    public suspend fun controllerDetails(argument: suspend ControllerDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ControllerDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.controllerDetails = mapped
    }

    /**
     * @param value The identity of the orchestrator
     */
    @JvmName("uxcncccvwkawtdrl")
    public suspend fun identity(`value`: OrchestratorIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the orchestrator
     */
    @JvmName("drdrkohrxthljvde")
    public suspend fun identity(argument: suspend OrchestratorIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = OrchestratorIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind of workbook. Choices are user and shared.
     */
    @JvmName("jguyfhcnvobabtjb")
    public suspend fun kind(`value`: Either<String, OrchestratorKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of workbook. Choices are user and shared.
     */
    @JvmName("lnrxuryshxnabsph")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OrchestratorKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind of workbook. Choices are user and shared.
     */
    @JvmName("imykyutmigiafmma")
    public fun kind(`value`: OrchestratorKind) {
        val toBeMapped = Either.ofRight<String, OrchestratorKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("srfdabtwayhtqcna")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value AAD ID used with apiserver
     */
    @JvmName("cgoghcsreuygnpdi")
    public suspend fun orchestratorAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orchestratorAppId = mapped
    }

    /**
     * @param value TenantID of server App ID
     */
    @JvmName("ofaonhlkcbvchkyp")
    public suspend fun orchestratorTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orchestratorTenantId = mapped
    }

    /**
     * @param value private link arm resource id. Either one of apiServerEndpoint or privateLinkResourceId can be specified
     */
    @JvmName("byysrrydqfjprdeu")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qcruhqmtjxmnnoer")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("mhdrovgwnserxltn")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("qqcfiyrytdfcysvh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("uealskojpimqixva")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OrchestratorInstanceServiceDetailsArgs =
        OrchestratorInstanceServiceDetailsArgs(
            apiServerEndpoint = apiServerEndpoint,
            clusterRootCA = clusterRootCA,
            controllerDetails = controllerDetails,
            identity = identity,
            kind = kind,
            location = location,
            orchestratorAppId = orchestratorAppId,
            orchestratorTenantId = orchestratorTenantId,
            privateLinkResourceId = privateLinkResourceId,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            tags = tags,
        )
}
