@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.inputs

import com.pulumi.azurenative.delegatednetwork.inputs.GetControllerDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
 */
public data class GetControllerDetailsPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.delegatednetwork.inputs.GetControllerDetailsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.delegatednetwork.inputs.GetControllerDetailsPlainArgs =
        com.pulumi.azurenative.delegatednetwork.inputs.GetControllerDetailsPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetControllerDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetControllerDetailsPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jjlcwdpbcseeauwb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("vqihlubnukecijgo")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetControllerDetailsPlainArgs = GetControllerDetailsPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
