@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.inputs

import com.pulumi.azurenative.delegatednetwork.inputs.OrchestratorIdentityArgs.builder
import com.pulumi.azurenative.delegatednetwork.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of identity used for orchestrator cluster. Type 'SystemAssigned' will use an implicitly created identity orchestrator clusters
 */
public data class OrchestratorIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.delegatednetwork.inputs.OrchestratorIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.delegatednetwork.inputs.OrchestratorIdentityArgs =
        com.pulumi.azurenative.delegatednetwork.inputs.OrchestratorIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OrchestratorIdentityArgs].
 */
@PulumiTagMarker
public class OrchestratorIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    /**
     * @param value The type of identity used for orchestrator cluster. Type 'SystemAssigned' will use an implicitly created identity orchestrator clusters
     */
    @JvmName("nynojedwwljbbagk")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The type of identity used for orchestrator cluster. Type 'SystemAssigned' will use an implicitly created identity orchestrator clusters
     */
    @JvmName("rthtulycpbyqoyui")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OrchestratorIdentityArgs = OrchestratorIdentityArgs(
        type = type,
    )
}
