@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an instance of a orchestrator.
 * @property controllerDetails Properties of the controller.
 * @property id An identifier that represents the resource.
 * @property location Location of the resource.
 * @property name The name of the resource.
 * @property provisioningState The current state of dnc delegated subnet resource.
 * @property resourceGuid Resource guid.
 * @property subnetDetails subnet details
 * @property tags The resource tags.
 * @property type The type of resource.
 */
public data class GetDelegatedSubnetServiceDetailsResult(
    public val controllerDetails: ControllerDetailsResponse? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val subnetDetails: SubnetDetailsResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.delegatednetwork.outputs.GetDelegatedSubnetServiceDetailsResult):
            GetDelegatedSubnetServiceDetailsResult = GetDelegatedSubnetServiceDetailsResult(
            controllerDetails = javaType.controllerDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.delegatednetwork.kotlin.outputs.ControllerDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            subnetDetails = javaType.subnetDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.delegatednetwork.kotlin.outputs.SubnetDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
