@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents an instance of a orchestrator.
 * @property apiServerEndpoint K8s APIServer url. Either one of apiServerEndpoint or privateLinkResourceId can be specified
 * @property clusterRootCA RootCA certificate of kubernetes cluster base64 encoded
 * @property controllerDetails Properties of the controller.
 * @property id An identifier that represents the resource.
 * @property identity The identity of the orchestrator
 * @property kind The kind of workbook. Choices are user and shared.
 * @property location Location of the resource.
 * @property name The name of the resource.
 * @property orchestratorAppId AAD ID used with apiserver
 * @property orchestratorTenantId TenantID of server App ID
 * @property privateLinkResourceId private link arm resource id. Either one of apiServerEndpoint or privateLinkResourceId can be specified
 * @property provisioningState The current state of orchestratorInstance resource.
 * @property resourceGuid Resource guid.
 * @property tags The resource tags.
 * @property type The type of resource.
 */
public data class GetOrchestratorInstanceServiceDetailsResult(
    public val apiServerEndpoint: String? = null,
    public val clusterRootCA: String? = null,
    public val controllerDetails: ControllerDetailsResponse,
    public val id: String,
    public val identity: OrchestratorIdentityResponse? = null,
    public val kind: String,
    public val location: String? = null,
    public val name: String,
    public val orchestratorAppId: String? = null,
    public val orchestratorTenantId: String? = null,
    public val privateLinkResourceId: String? = null,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.delegatednetwork.outputs.GetOrchestratorInstanceServiceDetailsResult):
            GetOrchestratorInstanceServiceDetailsResult = GetOrchestratorInstanceServiceDetailsResult(
            apiServerEndpoint = javaType.apiServerEndpoint().map({ args0 -> args0 }).orElse(null),
            clusterRootCA = javaType.clusterRootCA().map({ args0 -> args0 }).orElse(null),
            controllerDetails = javaType.controllerDetails().let({ args0 ->
                com.pulumi.azurenative.delegatednetwork.kotlin.outputs.ControllerDetailsResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.delegatednetwork.kotlin.outputs.OrchestratorIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            orchestratorAppId = javaType.orchestratorAppId().map({ args0 -> args0 }).orElse(null),
            orchestratorTenantId = javaType.orchestratorTenantId().map({ args0 -> args0 }).orElse(null),
            privateLinkResourceId = javaType.privateLinkResourceId().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
