@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.AppAttachPackagePropertiesResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseIdentity
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponsePlan
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseSku
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.AppAttachPackagePropertiesResponse.Companion.toKotlin as appAttachPackagePropertiesResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseIdentity.Companion.toKotlin as resourceModelWithAllowedPropertySetResponseIdentityToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponsePlan.Companion.toKotlin as resourceModelWithAllowedPropertySetResponsePlanToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseSku.Companion.toKotlin as resourceModelWithAllowedPropertySetResponseSkuToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AppAttachPackage].
 */
@PulumiTagMarker
public class AppAttachPackageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppAttachPackageArgs = AppAttachPackageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppAttachPackageArgsBuilder.() -> Unit) {
        val builder = AppAttachPackageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppAttachPackage {
        val builtJavaResource =
            com.pulumi.azurenative.desktopvirtualization.AppAttachPackage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AppAttachPackage(builtJavaResource)
    }
}

/**
 * Schema for App Attach Package properties.
 * Azure REST API version: 2023-10-04-preview.
 * Other available API versions: 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview.
 * ## Example Usage
 * ### AppAttachPackage_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appAttachPackage = new AzureNative.DesktopVirtualization.AppAttachPackage("appAttachPackage", new()
 *     {
 *         AppAttachPackageName = "msixpackagefullname",
 *         Location = "southcentralus",
 *         Properties = new AzureNative.DesktopVirtualization.Inputs.AppAttachPackagePropertiesArgs
 *         {
 *             FailHealthCheckOnStagingFailure = AzureNative.DesktopVirtualization.FailHealthCheckOnStagingFailure.NeedsAssistance,
 *             HostPoolReferences = new() { },
 *             Image = new AzureNative.DesktopVirtualization.Inputs.AppAttachPackageInfoPropertiesArgs
 *             {
 *                 CertificateExpiry = "2023-01-02T17:18:19.1234567Z",
 *                 CertificateName = "certName",
 *                 DisplayName = "displayname",
 *                 ImagePath = "imagepath",
 *                 IsActive = false,
 *                 IsRegularRegistration = false,
 *                 LastUpdated = "2008-09-22T14:01:54.9571247Z",
 *                 PackageAlias = "msixpackagealias",
 *                 PackageApplications = new[]
 *                 {
 *                     new AzureNative.DesktopVirtualization.Inputs.MsixPackageApplicationsArgs
 *                     {
 *                         AppId = "AppId",
 *                         AppUserModelID = "AppUserModelId",
 *                         Description = "PackageApplicationDescription",
 *                         FriendlyName = "FriendlyName",
 *                         IconImageName = "Iconimagename",
 *                         RawIcon = "VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo",
 *                         RawPng = "VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo",
 *                     },
 *                 },
 *                 PackageDependencies = new[]
 *                 {
 *                     new AzureNative.DesktopVirtualization.Inputs.MsixPackageDependenciesArgs
 *                     {
 *                         DependencyName = "MsixPackage_Dependency_Name",
 *                         MinVersion = "packageDep_version",
 *                         Publisher = "MsixPackage_Dependency_Publisher",
 *                     },
 *                 },
 *                 PackageFamilyName = "MsixPackage_FamilyName",
 *                 PackageFullName = "MsixPackage_FullName",
 *                 PackageName = "MsixPackageName",
 *                 PackageRelativePath = "packagerelativepath",
 *                 Version = "packageversion",
 *             },
 *             KeyVaultURL = "",
 *         },
 *         ResourceGroupName = "resourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewAppAttachPackage(ctx, "appAttachPackage", &desktopvirtualization.AppAttachPackageArgs{
 * 			AppAttachPackageName: pulumi.String("msixpackagefullname"),
 * 			Location:             pulumi.String("southcentralus"),
 * 			Properties: &desktopvirtualization.AppAttachPackagePropertiesArgs{
 * 				FailHealthCheckOnStagingFailure: pulumi.String(desktopvirtualization.FailHealthCheckOnStagingFailureNeedsAssistance),
 * 				HostPoolReferences:              pulumi.StringArray{},
 * 				Image: &desktopvirtualization.AppAttachPackageInfoPropertiesArgs{
 * 					CertificateExpiry:     pulumi.String("2023-01-02T17:18:19.1234567Z"),
 * 					CertificateName:       pulumi.String("certName"),
 * 					DisplayName:           pulumi.String("displayname"),
 * 					ImagePath:             pulumi.String("imagepath"),
 * 					IsActive:              pulumi.Bool(false),
 * 					IsRegularRegistration: pulumi.Bool(false),
 * 					LastUpdated:           pulumi.String("2008-09-22T14:01:54.9571247Z"),
 * 					PackageAlias:          pulumi.String("msixpackagealias"),
 * 					PackageApplications: desktopvirtualization.MsixPackageApplicationsArray{
 * 						&desktopvirtualization.MsixPackageApplicationsArgs{
 * 							AppId:          pulumi.String("AppId"),
 * 							AppUserModelID: pulumi.String("AppUserModelId"),
 * 							Description:    pulumi.String("PackageApplicationDescription"),
 * 							FriendlyName:   pulumi.String("FriendlyName"),
 * 							IconImageName:  pulumi.String("Iconimagename"),
 * 							RawIcon:        pulumi.String("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo"),
 * 							RawPng:         pulumi.String("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo"),
 * 						},
 * 					},
 * 					PackageDependencies: desktopvirtualization.MsixPackageDependenciesArray{
 * 						&desktopvirtualization.MsixPackageDependenciesArgs{
 * 							DependencyName: pulumi.String("MsixPackage_Dependency_Name"),
 * 							MinVersion:     pulumi.String("packageDep_version"),
 * 							Publisher:      pulumi.String("MsixPackage_Dependency_Publisher"),
 * 						},
 * 					},
 * 					PackageFamilyName:   pulumi.String("MsixPackage_FamilyName"),
 * 					PackageFullName:     pulumi.String("MsixPackage_FullName"),
 * 					PackageName:         pulumi.String("MsixPackageName"),
 * 					PackageRelativePath: pulumi.String("packagerelativepath"),
 * 					Version:             pulumi.String("packageversion"),
 * 				},
 * 				KeyVaultURL: pulumi.String(""),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.AppAttachPackage;
 * import com.pulumi.azurenative.desktopvirtualization.AppAttachPackageArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackagePropertiesArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackageInfoPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appAttachPackage = new AppAttachPackage("appAttachPackage", AppAttachPackageArgs.builder()
 *             .appAttachPackageName("msixpackagefullname")
 *             .location("southcentralus")
 *             .properties(AppAttachPackagePropertiesArgs.builder()
 *                 .failHealthCheckOnStagingFailure("NeedsAssistance")
 *                 .hostPoolReferences()
 *                 .image(AppAttachPackageInfoPropertiesArgs.builder()
 *                     .certificateExpiry("2023-01-02T17:18:19.1234567Z")
 *                     .certificateName("certName")
 *                     .displayName("displayname")
 *                     .imagePath("imagepath")
 *                     .isActive(false)
 *                     .isRegularRegistration(false)
 *                     .lastUpdated("2008-09-22T14:01:54.9571247Z")
 *                     .packageAlias("msixpackagealias")
 *                     .packageApplications(MsixPackageApplicationsArgs.builder()
 *                         .appId("AppId")
 *                         .appUserModelID("AppUserModelId")
 *                         .description("PackageApplicationDescription")
 *                         .friendlyName("FriendlyName")
 *                         .iconImageName("Iconimagename")
 *                         .rawIcon("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo")
 *                         .rawPng("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo")
 *                         .build())
 *                     .packageDependencies(MsixPackageDependenciesArgs.builder()
 *                         .dependencyName("MsixPackage_Dependency_Name")
 *                         .minVersion("packageDep_version")
 *                         .publisher("MsixPackage_Dependency_Publisher")
 *                         .build())
 *                     .packageFamilyName("MsixPackage_FamilyName")
 *                     .packageFullName("MsixPackage_FullName")
 *                     .packageName("MsixPackageName")
 *                     .packageRelativePath("packagerelativepath")
 *                     .version("packageversion")
 *                     .build())
 *                 .keyVaultURL("")
 *                 .build())
 *             .resourceGroupName("resourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:AppAttachPackage packageName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/appAttachPackages/{appAttachPackageName}
 * ```
 */
public class AppAttachPackage internal constructor(
    override val javaResource: com.pulumi.azurenative.desktopvirtualization.AppAttachPackage,
) : KotlinCustomResource(javaResource, AppAttachPackageMapper) {
    /**
     * The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    public val identity: Output<ResourceModelWithAllowedPropertySetResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    public val managedBy: Output<String>?
        get() = javaResource.managedBy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val plan: Output<ResourceModelWithAllowedPropertySetResponsePlan>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponsePlanToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Detailed properties for App Attach Package
     */
    public val properties: Output<AppAttachPackagePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                appAttachPackagePropertiesResponseToKotlin(args0)
            })
        })

    public val sku: Output<ResourceModelWithAllowedPropertySetResponseSku>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponseSkuToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppAttachPackageMapper : ResourceMapper<AppAttachPackage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.desktopvirtualization.AppAttachPackage::class == javaResource::class

    override fun map(javaResource: Resource): AppAttachPackage = AppAttachPackage(
        javaResource as
            com.pulumi.azurenative.desktopvirtualization.AppAttachPackage,
    )
}

/**
 * @see [AppAttachPackage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppAttachPackage].
 */
public suspend fun appAttachPackage(
    name: String,
    block: suspend AppAttachPackageResourceBuilder.() -> Unit,
): AppAttachPackage {
    val builder = AppAttachPackageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppAttachPackage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appAttachPackage(name: String): AppAttachPackage {
    val builder = AppAttachPackageResourceBuilder()
    builder.name(name)
    return builder.build()
}
