@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.MSIXPackageArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.MsixPackageApplicationsArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.MsixPackageApplicationsArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.MsixPackageDependenciesArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.MsixPackageDependenciesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schema for MSIX Package properties.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview.
 * ## Example Usage
 * ### MSIXPackage_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var msixPackage = new AzureNative.DesktopVirtualization.MSIXPackage("msixPackage", new()
 *     {
 *         DisplayName = "displayname",
 *         HostPoolName = "hostpool1",
 *         ImagePath = "imagepath",
 *         IsActive = false,
 *         IsRegularRegistration = false,
 *         LastUpdated = "2008-09-22T14:01:54.9571247Z",
 *         MsixPackageFullName = "msixpackagefullname",
 *         PackageApplications = new[]
 *         {
 *             new AzureNative.DesktopVirtualization.Inputs.MsixPackageApplicationsArgs
 *             {
 *                 AppId = "ApplicationId",
 *                 AppUserModelID = "AppUserModelId",
 *                 Description = "application-desc",
 *                 FriendlyName = "friendlyname",
 *                 IconImageName = "Apptile",
 *                 RawIcon = "VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo",
 *                 RawPng = "VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo",
 *             },
 *         },
 *         PackageDependencies = new[]
 *         {
 *             new AzureNative.DesktopVirtualization.Inputs.MsixPackageDependenciesArgs
 *             {
 *                 DependencyName = "MsixTest_Dependency_Name",
 *                 MinVersion = "version",
 *                 Publisher = "PublishedName",
 *             },
 *         },
 *         PackageFamilyName = "MsixPackage_FamilyName",
 *         PackageName = "MsixPackage_name",
 *         PackageRelativePath = "packagerelativepath",
 *         ResourceGroupName = "resourceGroup1",
 *         Version = "version",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewMSIXPackage(ctx, "msixPackage", &desktopvirtualization.MSIXPackageArgs{
 * 			DisplayName:           pulumi.String("displayname"),
 * 			HostPoolName:          pulumi.String("hostpool1"),
 * 			ImagePath:             pulumi.String("imagepath"),
 * 			IsActive:              pulumi.Bool(false),
 * 			IsRegularRegistration: pulumi.Bool(false),
 * 			LastUpdated:           pulumi.String("2008-09-22T14:01:54.9571247Z"),
 * 			MsixPackageFullName:   pulumi.String("msixpackagefullname"),
 * 			PackageApplications: desktopvirtualization.MsixPackageApplicationsArray{
 * 				&desktopvirtualization.MsixPackageApplicationsArgs{
 * 					AppId:          pulumi.String("ApplicationId"),
 * 					AppUserModelID: pulumi.String("AppUserModelId"),
 * 					Description:    pulumi.String("application-desc"),
 * 					FriendlyName:   pulumi.String("friendlyname"),
 * 					IconImageName:  pulumi.String("Apptile"),
 * 					RawIcon:        pulumi.String("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo"),
 * 					RawPng:         pulumi.String("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo"),
 * 				},
 * 			},
 * 			PackageDependencies: desktopvirtualization.MsixPackageDependenciesArray{
 * 				&desktopvirtualization.MsixPackageDependenciesArgs{
 * 					DependencyName: pulumi.String("MsixTest_Dependency_Name"),
 * 					MinVersion:     pulumi.String("version"),
 * 					Publisher:      pulumi.String("PublishedName"),
 * 				},
 * 			},
 * 			PackageFamilyName:   pulumi.String("MsixPackage_FamilyName"),
 * 			PackageName:         pulumi.String("MsixPackage_name"),
 * 			PackageRelativePath: pulumi.String("packagerelativepath"),
 * 			ResourceGroupName:   pulumi.String("resourceGroup1"),
 * 			Version:             pulumi.String("version"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.MSIXPackage;
 * import com.pulumi.azurenative.desktopvirtualization.MSIXPackageArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageApplicationsArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageDependenciesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var msixPackage = new MSIXPackage("msixPackage", MSIXPackageArgs.builder()
 *             .displayName("displayname")
 *             .hostPoolName("hostpool1")
 *             .imagePath("imagepath")
 *             .isActive(false)
 *             .isRegularRegistration(false)
 *             .lastUpdated("2008-09-22T14:01:54.9571247Z")
 *             .msixPackageFullName("msixpackagefullname")
 *             .packageApplications(MsixPackageApplicationsArgs.builder()
 *                 .appId("ApplicationId")
 *                 .appUserModelID("AppUserModelId")
 *                 .description("application-desc")
 *                 .friendlyName("friendlyname")
 *                 .iconImageName("Apptile")
 *                 .rawIcon("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo")
 *                 .rawPng("VGhpcyBpcyBhIHN0cmluZyB0byBoYXNo")
 *                 .build())
 *             .packageDependencies(MsixPackageDependenciesArgs.builder()
 *                 .dependencyName("MsixTest_Dependency_Name")
 *                 .minVersion("version")
 *                 .publisher("PublishedName")
 *                 .build())
 *             .packageFamilyName("MsixPackage_FamilyName")
 *             .packageName("MsixPackage_name")
 *             .packageRelativePath("packagerelativepath")
 *             .resourceGroupName("resourceGroup1")
 *             .version("version")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:MSIXPackage hostpool1/MsixPackageFullName /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/hostPools/{hostPoolName}/msixPackages/{msixPackageFullName}
 * ```
 * @property displayName User friendly Name to be displayed in the portal.
 * @property hostPoolName The name of the host pool within the specified resource group
 * @property imagePath VHD/CIM image path on Network Share.
 * @property isActive Make this version of the package the active one across the hostpool.
 * @property isRegularRegistration Specifies how to register Package in feed.
 * @property lastUpdated Date Package was last updated, found in the appxmanifest.xml.
 * @property msixPackageFullName The version specific package full name of the MSIX package within specified hostpool
 * @property packageApplications List of package applications.
 * @property packageDependencies List of package dependencies.
 * @property packageFamilyName Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
 * @property packageName Package Name from appxmanifest.xml.
 * @property packageRelativePath Relative Path to the package inside the image.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Package Version found in the appxmanifest.xml.
 */
public data class MSIXPackageArgs(
    public val displayName: Output<String>? = null,
    public val hostPoolName: Output<String>? = null,
    public val imagePath: Output<String>? = null,
    public val isActive: Output<Boolean>? = null,
    public val isRegularRegistration: Output<Boolean>? = null,
    public val lastUpdated: Output<String>? = null,
    public val msixPackageFullName: Output<String>? = null,
    public val packageApplications: Output<List<MsixPackageApplicationsArgs>>? = null,
    public val packageDependencies: Output<List<MsixPackageDependenciesArgs>>? = null,
    public val packageFamilyName: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val packageRelativePath: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.MSIXPackageArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.MSIXPackageArgs =
        com.pulumi.azurenative.desktopvirtualization.MSIXPackageArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .hostPoolName(hostPoolName?.applyValue({ args0 -> args0 }))
            .imagePath(imagePath?.applyValue({ args0 -> args0 }))
            .isActive(isActive?.applyValue({ args0 -> args0 }))
            .isRegularRegistration(isRegularRegistration?.applyValue({ args0 -> args0 }))
            .lastUpdated(lastUpdated?.applyValue({ args0 -> args0 }))
            .msixPackageFullName(msixPackageFullName?.applyValue({ args0 -> args0 }))
            .packageApplications(
                packageApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .packageDependencies(
                packageDependencies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .packageFamilyName(packageFamilyName?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .packageRelativePath(packageRelativePath?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MSIXPackageArgs].
 */
@PulumiTagMarker
public class MSIXPackageArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var hostPoolName: Output<String>? = null

    private var imagePath: Output<String>? = null

    private var isActive: Output<Boolean>? = null

    private var isRegularRegistration: Output<Boolean>? = null

    private var lastUpdated: Output<String>? = null

    private var msixPackageFullName: Output<String>? = null

    private var packageApplications: Output<List<MsixPackageApplicationsArgs>>? = null

    private var packageDependencies: Output<List<MsixPackageDependenciesArgs>>? = null

    private var packageFamilyName: Output<String>? = null

    private var packageName: Output<String>? = null

    private var packageRelativePath: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value User friendly Name to be displayed in the portal.
     */
    @JvmName("eowveichmpfigsey")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the host pool within the specified resource group
     */
    @JvmName("wiajejrsqfbnwyiq")
    public suspend fun hostPoolName(`value`: Output<String>) {
        this.hostPoolName = value
    }

    /**
     * @param value VHD/CIM image path on Network Share.
     */
    @JvmName("atrraufeavqeluhs")
    public suspend fun imagePath(`value`: Output<String>) {
        this.imagePath = value
    }

    /**
     * @param value Make this version of the package the active one across the hostpool.
     */
    @JvmName("grtunxljwiskuuin")
    public suspend fun isActive(`value`: Output<Boolean>) {
        this.isActive = value
    }

    /**
     * @param value Specifies how to register Package in feed.
     */
    @JvmName("txsbudfxyopjsxem")
    public suspend fun isRegularRegistration(`value`: Output<Boolean>) {
        this.isRegularRegistration = value
    }

    /**
     * @param value Date Package was last updated, found in the appxmanifest.xml.
     */
    @JvmName("qfujmdmkxpbdydlr")
    public suspend fun lastUpdated(`value`: Output<String>) {
        this.lastUpdated = value
    }

    /**
     * @param value The version specific package full name of the MSIX package within specified hostpool
     */
    @JvmName("khnqtdftrmdyndqo")
    public suspend fun msixPackageFullName(`value`: Output<String>) {
        this.msixPackageFullName = value
    }

    /**
     * @param value List of package applications.
     */
    @JvmName("rxkxhymwcvedqhfm")
    public suspend fun packageApplications(`value`: Output<List<MsixPackageApplicationsArgs>>) {
        this.packageApplications = value
    }

    @JvmName("puvjdmwwocolhbtd")
    public suspend fun packageApplications(vararg values: Output<MsixPackageApplicationsArgs>) {
        this.packageApplications = Output.all(values.asList())
    }

    /**
     * @param values List of package applications.
     */
    @JvmName("usakwkcfipslxyhs")
    public suspend fun packageApplications(values: List<Output<MsixPackageApplicationsArgs>>) {
        this.packageApplications = Output.all(values)
    }

    /**
     * @param value List of package dependencies.
     */
    @JvmName("utwycmfyjnpjtcom")
    public suspend fun packageDependencies(`value`: Output<List<MsixPackageDependenciesArgs>>) {
        this.packageDependencies = value
    }

    @JvmName("eofyuppelvqbilfs")
    public suspend fun packageDependencies(vararg values: Output<MsixPackageDependenciesArgs>) {
        this.packageDependencies = Output.all(values.asList())
    }

    /**
     * @param values List of package dependencies.
     */
    @JvmName("cynegpqbroklcktt")
    public suspend fun packageDependencies(values: List<Output<MsixPackageDependenciesArgs>>) {
        this.packageDependencies = Output.all(values)
    }

    /**
     * @param value Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
     */
    @JvmName("ayehmwhisqtyolfv")
    public suspend fun packageFamilyName(`value`: Output<String>) {
        this.packageFamilyName = value
    }

    /**
     * @param value Package Name from appxmanifest.xml.
     */
    @JvmName("wegonypylngginio")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Relative Path to the package inside the image.
     */
    @JvmName("adcjobdgwndnppio")
    public suspend fun packageRelativePath(`value`: Output<String>) {
        this.packageRelativePath = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jwktuhsbmggxbyht")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Package Version found in the appxmanifest.xml.
     */
    @JvmName("cmrlpikemlawhaxn")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value User friendly Name to be displayed in the portal.
     */
    @JvmName("slrlupngtflcfnpy")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the host pool within the specified resource group
     */
    @JvmName("hufbnsoaeouxrpsg")
    public suspend fun hostPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPoolName = mapped
    }

    /**
     * @param value VHD/CIM image path on Network Share.
     */
    @JvmName("ydxrxbxmqmdpbhbx")
    public suspend fun imagePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePath = mapped
    }

    /**
     * @param value Make this version of the package the active one across the hostpool.
     */
    @JvmName("dfkqevmrnupduhqr")
    public suspend fun isActive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isActive = mapped
    }

    /**
     * @param value Specifies how to register Package in feed.
     */
    @JvmName("mxfphowjstalldqb")
    public suspend fun isRegularRegistration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRegularRegistration = mapped
    }

    /**
     * @param value Date Package was last updated, found in the appxmanifest.xml.
     */
    @JvmName("wbqfykeujdmkniub")
    public suspend fun lastUpdated(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdated = mapped
    }

    /**
     * @param value The version specific package full name of the MSIX package within specified hostpool
     */
    @JvmName("kwiqynhvecgamipe")
    public suspend fun msixPackageFullName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msixPackageFullName = mapped
    }

    /**
     * @param value List of package applications.
     */
    @JvmName("twosfarcglagnkxj")
    public suspend fun packageApplications(`value`: List<MsixPackageApplicationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageApplications = mapped
    }

    /**
     * @param argument List of package applications.
     */
    @JvmName("scrattjeobcyxwpi")
    public suspend
    fun packageApplications(argument: List<suspend MsixPackageApplicationsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MsixPackageApplicationsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.packageApplications = mapped
    }

    /**
     * @param argument List of package applications.
     */
    @JvmName("jmlxgqbijdketmha")
    public suspend fun packageApplications(
        vararg
        argument: suspend MsixPackageApplicationsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MsixPackageApplicationsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.packageApplications = mapped
    }

    /**
     * @param argument List of package applications.
     */
    @JvmName("ohhfqosynbgrqyla")
    public suspend
    fun packageApplications(argument: suspend MsixPackageApplicationsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MsixPackageApplicationsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.packageApplications = mapped
    }

    /**
     * @param values List of package applications.
     */
    @JvmName("mhmibrqyfuvhufmp")
    public suspend fun packageApplications(vararg values: MsixPackageApplicationsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageApplications = mapped
    }

    /**
     * @param value List of package dependencies.
     */
    @JvmName("ldjxaconsoxhnamm")
    public suspend fun packageDependencies(`value`: List<MsixPackageDependenciesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageDependencies = mapped
    }

    /**
     * @param argument List of package dependencies.
     */
    @JvmName("ikgpjqbtvgcagnuv")
    public suspend
    fun packageDependencies(argument: List<suspend MsixPackageDependenciesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MsixPackageDependenciesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.packageDependencies = mapped
    }

    /**
     * @param argument List of package dependencies.
     */
    @JvmName("nvlvnmfyxqthhcum")
    public suspend fun packageDependencies(
        vararg
        argument: suspend MsixPackageDependenciesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MsixPackageDependenciesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.packageDependencies = mapped
    }

    /**
     * @param argument List of package dependencies.
     */
    @JvmName("cbthjporwlylapwi")
    public suspend
    fun packageDependencies(argument: suspend MsixPackageDependenciesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MsixPackageDependenciesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.packageDependencies = mapped
    }

    /**
     * @param values List of package dependencies.
     */
    @JvmName("msjxbspabgtocgvx")
    public suspend fun packageDependencies(vararg values: MsixPackageDependenciesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageDependencies = mapped
    }

    /**
     * @param value Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
     */
    @JvmName("fybyvxxksdaenvdc")
    public suspend fun packageFamilyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageFamilyName = mapped
    }

    /**
     * @param value Package Name from appxmanifest.xml.
     */
    @JvmName("phoeqwgmswquwibc")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Relative Path to the package inside the image.
     */
    @JvmName("hleqjfqfulkxqtcu")
    public suspend fun packageRelativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageRelativePath = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pbcsrdsqxkcbovkq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Package Version found in the appxmanifest.xml.
     */
    @JvmName("yecjiwqclwelmqvk")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): MSIXPackageArgs = MSIXPackageArgs(
        displayName = displayName,
        hostPoolName = hostPoolName,
        imagePath = imagePath,
        isActive = isActive,
        isRegularRegistration = isRegularRegistration,
        lastUpdated = lastUpdated,
        msixPackageFullName = msixPackageFullName,
        packageApplications = packageApplications,
        packageDependencies = packageDependencies,
        packageFamilyName = packageFamilyName,
        packageName = packageName,
        packageRelativePath = packageRelativePath,
        resourceGroupName = resourceGroupName,
        version = version,
    )
}
