@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseIdentity
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponsePlan
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseSku
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ScalingHostPoolReferenceResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ScalingScheduleResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseIdentity.Companion.toKotlin as resourceModelWithAllowedPropertySetResponseIdentityToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponsePlan.Companion.toKotlin as resourceModelWithAllowedPropertySetResponsePlanToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseSku.Companion.toKotlin as resourceModelWithAllowedPropertySetResponseSkuToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ScalingHostPoolReferenceResponse.Companion.toKotlin as scalingHostPoolReferenceResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ScalingScheduleResponse.Companion.toKotlin as scalingScheduleResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ScalingPlan].
 */
@PulumiTagMarker
public class ScalingPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScalingPlanArgs = ScalingPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScalingPlanArgsBuilder.() -> Unit) {
        val builder = ScalingPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScalingPlan {
        val builtJavaResource =
            com.pulumi.azurenative.desktopvirtualization.ScalingPlan(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScalingPlan(builtJavaResource)
    }
}

/**
 * Represents a scaling plan definition.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2020-11-10-preview, 2021-02-01-preview, 2022-02-10-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview.
 * ## Example Usage
 * ### ScalingPlans_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scalingPlan = new AzureNative.DesktopVirtualization.ScalingPlan("scalingPlan", new()
 *     {
 *         Description = "Description of Scaling Plan",
 *         ExclusionTag = "value",
 *         FriendlyName = "Scaling Plan 1",
 *         HostPoolReferences = new[]
 *         {
 *             new AzureNative.DesktopVirtualization.Inputs.ScalingHostPoolReferenceArgs
 *             {
 *                 HostPoolArmPath = "/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1",
 *                 ScalingPlanEnabled = true,
 *             },
 *         },
 *         HostPoolType = AzureNative.DesktopVirtualization.ScalingHostPoolType.Pooled,
 *         Location = "centralus",
 *         ResourceGroupName = "resourceGroup1",
 *         ScalingPlanName = "scalingPlan1",
 *         Schedules = new[]
 *         {
 *             new AzureNative.DesktopVirtualization.Inputs.ScalingScheduleArgs
 *             {
 *                 DaysOfWeek = new[]
 *                 {
 *                     "Monday",
 *                     "Tuesday",
 *                     "Wednesday",
 *                     "Thursday",
 *                     "Friday",
 *                 },
 *                 Name = "schedule1",
 *                 OffPeakLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *                 OffPeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *                 {
 *                     Hour = 20,
 *                     Minute = 0,
 *                 },
 *                 PeakLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.BreadthFirst,
 *                 PeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *                 {
 *                     Hour = 8,
 *                     Minute = 0,
 *                 },
 *                 RampDownCapacityThresholdPct = 50,
 *                 RampDownForceLogoffUsers = true,
 *                 RampDownLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *                 RampDownMinimumHostsPct = 20,
 *                 RampDownNotificationMessage = "message",
 *                 RampDownStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *                 {
 *                     Hour = 18,
 *                     Minute = 0,
 *                 },
 *                 RampDownWaitTimeMinutes = 30,
 *                 RampUpCapacityThresholdPct = 80,
 *                 RampUpLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *                 RampUpMinimumHostsPct = 20,
 *                 RampUpStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *                 {
 *                     Hour = 6,
 *                     Minute = 0,
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         TimeZone = "Central Standard Time",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewScalingPlan(ctx, "scalingPlan", &desktopvirtualization.ScalingPlanArgs{
 * 			Description:  pulumi.String("Description of Scaling Plan"),
 * 			ExclusionTag: pulumi.String("value"),
 * 			FriendlyName: pulumi.String("Scaling Plan 1"),
 * 			HostPoolReferences: desktopvirtualization.ScalingHostPoolReferenceArray{
 * 				&desktopvirtualization.ScalingHostPoolReferenceArgs{
 * 					HostPoolArmPath:    pulumi.String("/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1"),
 * 					ScalingPlanEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			HostPoolType:      pulumi.String(desktopvirtualization.ScalingHostPoolTypePooled),
 * 			Location:          pulumi.String("centralus"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			ScalingPlanName:   pulumi.String("scalingPlan1"),
 * 			Schedules: desktopvirtualization.ScalingScheduleArray{
 * 				&desktopvirtualization.ScalingScheduleArgs{
 * 					DaysOfWeek: pulumi.StringArray{
 * 						pulumi.String("Monday"),
 * 						pulumi.String("Tuesday"),
 * 						pulumi.String("Wednesday"),
 * 						pulumi.String("Thursday"),
 * 						pulumi.String("Friday"),
 * 					},
 * 					Name:                          pulumi.String("schedule1"),
 * 					OffPeakLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 					OffPeakStartTime: &desktopvirtualization.TimeArgs{
 * 						Hour:   pulumi.Int(20),
 * 						Minute: pulumi.Int(0),
 * 					},
 * 					PeakLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmBreadthFirst),
 * 					PeakStartTime: &desktopvirtualization.TimeArgs{
 * 						Hour:   pulumi.Int(8),
 * 						Minute: pulumi.Int(0),
 * 					},
 * 					RampDownCapacityThresholdPct:   pulumi.Int(50),
 * 					RampDownForceLogoffUsers:       pulumi.Bool(true),
 * 					RampDownLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 					RampDownMinimumHostsPct:        pulumi.Int(20),
 * 					RampDownNotificationMessage:    pulumi.String("message"),
 * 					RampDownStartTime: &desktopvirtualization.TimeArgs{
 * 						Hour:   pulumi.Int(18),
 * 						Minute: pulumi.Int(0),
 * 					},
 * 					RampDownWaitTimeMinutes:      pulumi.Int(30),
 * 					RampUpCapacityThresholdPct:   pulumi.Int(80),
 * 					RampUpLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 					RampUpMinimumHostsPct:        pulumi.Int(20),
 * 					RampUpStartTime: &desktopvirtualization.TimeArgs{
 * 						Hour:   pulumi.Int(6),
 * 						Minute: pulumi.Int(0),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			TimeZone: pulumi.String("Central Standard Time"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlan;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.ScalingHostPoolReferenceArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.ScalingScheduleArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scalingPlan = new ScalingPlan("scalingPlan", ScalingPlanArgs.builder()
 *             .description("Description of Scaling Plan")
 *             .exclusionTag("value")
 *             .friendlyName("Scaling Plan 1")
 *             .hostPoolReferences(ScalingHostPoolReferenceArgs.builder()
 *                 .hostPoolArmPath("/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1")
 *                 .scalingPlanEnabled(true)
 *                 .build())
 *             .hostPoolType("Pooled")
 *             .location("centralus")
 *             .resourceGroupName("resourceGroup1")
 *             .scalingPlanName("scalingPlan1")
 *             .schedules(ScalingScheduleArgs.builder()
 *                 .daysOfWeek(
 *                     "Monday",
 *                     "Tuesday",
 *                     "Wednesday",
 *                     "Thursday",
 *                     "Friday")
 *                 .name("schedule1")
 *                 .offPeakLoadBalancingAlgorithm("DepthFirst")
 *                 .offPeakStartTime(TimeArgs.builder()
 *                     .hour(20)
 *                     .minute(0)
 *                     .build())
 *                 .peakLoadBalancingAlgorithm("BreadthFirst")
 *                 .peakStartTime(TimeArgs.builder()
 *                     .hour(8)
 *                     .minute(0)
 *                     .build())
 *                 .rampDownCapacityThresholdPct(50)
 *                 .rampDownForceLogoffUsers(true)
 *                 .rampDownLoadBalancingAlgorithm("DepthFirst")
 *                 .rampDownMinimumHostsPct(20)
 *                 .rampDownNotificationMessage("message")
 *                 .rampDownStartTime(TimeArgs.builder()
 *                     .hour(18)
 *                     .minute(0)
 *                     .build())
 *                 .rampDownWaitTimeMinutes(30)
 *                 .rampUpCapacityThresholdPct(80)
 *                 .rampUpLoadBalancingAlgorithm("DepthFirst")
 *                 .rampUpMinimumHostsPct(20)
 *                 .rampUpStartTime(TimeArgs.builder()
 *                     .hour(6)
 *                     .minute(0)
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .timeZone("Central Standard Time")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:ScalingPlan scalingPlan1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}
 * ```
 */
public class ScalingPlan internal constructor(
    override val javaResource: com.pulumi.azurenative.desktopvirtualization.ScalingPlan,
) : KotlinCustomResource(javaResource, ScalingPlanMapper) {
    /**
     * Description of scaling plan.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Exclusion tag for scaling plan.
     */
    public val exclusionTag: Output<String>?
        get() = javaResource.exclusionTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User friendly name of scaling plan.
     */
    public val friendlyName: Output<String>?
        get() = javaResource.friendlyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of ScalingHostPoolReference definitions.
     */
    public val hostPoolReferences: Output<List<ScalingHostPoolReferenceResponse>>?
        get() = javaResource.hostPoolReferences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        scalingHostPoolReferenceResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * HostPool type for desktop.
     */
    public val hostPoolType: Output<String>?
        get() = javaResource.hostPoolType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val identity: Output<ResourceModelWithAllowedPropertySetResponseIdentity>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponseIdentityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    public val managedBy: Output<String>?
        get() = javaResource.managedBy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ObjectId of scaling plan. (internal use)
     */
    public val objectId: Output<String>
        get() = javaResource.objectId().applyValue({ args0 -> args0 })

    public val plan: Output<ResourceModelWithAllowedPropertySetResponsePlan>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponsePlanToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of ScalingPlanPooledSchedule definitions.
     */
    public val schedules: Output<List<ScalingScheduleResponse>>?
        get() = javaResource.schedules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> scalingScheduleResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    public val sku: Output<ResourceModelWithAllowedPropertySetResponseSku>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceModelWithAllowedPropertySetResponseSkuToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Timezone of the scaling plan.
     */
    public val timeZone: Output<String>
        get() = javaResource.timeZone().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScalingPlanMapper : ResourceMapper<ScalingPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.desktopvirtualization.ScalingPlan::class == javaResource::class

    override fun map(javaResource: Resource): ScalingPlan = ScalingPlan(
        javaResource as
            com.pulumi.azurenative.desktopvirtualization.ScalingPlan,
    )
}

/**
 * @see [ScalingPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScalingPlan].
 */
public suspend fun scalingPlan(name: String, block: suspend ScalingPlanResourceBuilder.() -> Unit):
    ScalingPlan {
    val builder = ScalingPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScalingPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scalingPlan(name: String): ScalingPlan {
    val builder = ScalingPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
