@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.ScalingPlanArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.ScalingHostPoolType
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ScalingHostPoolReferenceArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ScalingHostPoolReferenceArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ScalingScheduleArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ScalingScheduleArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a scaling plan definition.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2020-11-10-preview, 2021-02-01-preview, 2022-02-10-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview.
 * ## Example Usage
 * ### ScalingPlans_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scalingPlan = new AzureNative.DesktopVirtualization.ScalingPlan("scalingPlan", new()
 *     {
 *         Description = "Description of Scaling Plan",
 *         ExclusionTag = "value",
 *         FriendlyName = "Scaling Plan 1",
 *         HostPoolReferences = new[]
 *         {
 *             new AzureNative.DesktopVirtualization.Inputs.ScalingHostPoolReferenceArgs
 *             {
 *                 HostPoolArmPath = "/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1",
 *                 ScalingPlanEnabled = true,
 *             },
 *         },
 *         HostPoolType = AzureNative.DesktopVirtualization.ScalingHostPoolType.Pooled,
 *         Location = "centralus",
 *         ResourceGroupName = "resourceGroup1",
 *         ScalingPlanName = "scalingPlan1",
 *         Schedules = new[]
 *         {
 *             new AzureNative.DesktopVirtualization.Inputs.ScalingScheduleArgs
 *             {
 *                 DaysOfWeek = new[]
 *                 {
 *                     "Monday",
 *                     "Tuesday",
 *                     "Wednesday",
 *                     "Thursday",
 *                     "Friday",
 *                 },
 *                 Name = "schedule1",
 *                 OffPeakLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *                 OffPeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *                 {
 *                     Hour = 20,
 *                     Minute = 0,
 *                 },
 *                 PeakLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.BreadthFirst,
 *                 PeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *                 {
 *                     Hour = 8,
 *                     Minute = 0,
 *                 },
 *                 RampDownCapacityThresholdPct = 50,
 *                 RampDownForceLogoffUsers = true,
 *                 RampDownLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *                 RampDownMinimumHostsPct = 20,
 *                 RampDownNotificationMessage = "message",
 *                 RampDownStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *                 {
 *                     Hour = 18,
 *                     Minute = 0,
 *                 },
 *                 RampDownWaitTimeMinutes = 30,
 *                 RampUpCapacityThresholdPct = 80,
 *                 RampUpLoadBalancingAlgorithm = AzureNative.DesktopVirtualization.SessionHostLoadBalancingAlgorithm.DepthFirst,
 *                 RampUpMinimumHostsPct = 20,
 *                 RampUpStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *                 {
 *                     Hour = 6,
 *                     Minute = 0,
 *                 },
 *             },
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         TimeZone = "Central Standard Time",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewScalingPlan(ctx, "scalingPlan", &desktopvirtualization.ScalingPlanArgs{
 * 			Description:  pulumi.String("Description of Scaling Plan"),
 * 			ExclusionTag: pulumi.String("value"),
 * 			FriendlyName: pulumi.String("Scaling Plan 1"),
 * 			HostPoolReferences: desktopvirtualization.ScalingHostPoolReferenceArray{
 * 				&desktopvirtualization.ScalingHostPoolReferenceArgs{
 * 					HostPoolArmPath:    pulumi.String("/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1"),
 * 					ScalingPlanEnabled: pulumi.Bool(true),
 * 				},
 * 			},
 * 			HostPoolType:      pulumi.String(desktopvirtualization.ScalingHostPoolTypePooled),
 * 			Location:          pulumi.String("centralus"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			ScalingPlanName:   pulumi.String("scalingPlan1"),
 * 			Schedules: desktopvirtualization.ScalingScheduleArray{
 * 				&desktopvirtualization.ScalingScheduleArgs{
 * 					DaysOfWeek: pulumi.StringArray{
 * 						pulumi.String("Monday"),
 * 						pulumi.String("Tuesday"),
 * 						pulumi.String("Wednesday"),
 * 						pulumi.String("Thursday"),
 * 						pulumi.String("Friday"),
 * 					},
 * 					Name:                          pulumi.String("schedule1"),
 * 					OffPeakLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 					OffPeakStartTime: &desktopvirtualization.TimeArgs{
 * 						Hour:   pulumi.Int(20),
 * 						Minute: pulumi.Int(0),
 * 					},
 * 					PeakLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmBreadthFirst),
 * 					PeakStartTime: &desktopvirtualization.TimeArgs{
 * 						Hour:   pulumi.Int(8),
 * 						Minute: pulumi.Int(0),
 * 					},
 * 					RampDownCapacityThresholdPct:   pulumi.Int(50),
 * 					RampDownForceLogoffUsers:       pulumi.Bool(true),
 * 					RampDownLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 					RampDownMinimumHostsPct:        pulumi.Int(20),
 * 					RampDownNotificationMessage:    pulumi.String("message"),
 * 					RampDownStartTime: &desktopvirtualization.TimeArgs{
 * 						Hour:   pulumi.Int(18),
 * 						Minute: pulumi.Int(0),
 * 					},
 * 					RampDownWaitTimeMinutes:      pulumi.Int(30),
 * 					RampUpCapacityThresholdPct:   pulumi.Int(80),
 * 					RampUpLoadBalancingAlgorithm: pulumi.String(desktopvirtualization.SessionHostLoadBalancingAlgorithmDepthFirst),
 * 					RampUpMinimumHostsPct:        pulumi.Int(20),
 * 					RampUpStartTime: &desktopvirtualization.TimeArgs{
 * 						Hour:   pulumi.Int(6),
 * 						Minute: pulumi.Int(0),
 * 					},
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			TimeZone: pulumi.String("Central Standard Time"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlan;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.ScalingHostPoolReferenceArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.ScalingScheduleArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scalingPlan = new ScalingPlan("scalingPlan", ScalingPlanArgs.builder()
 *             .description("Description of Scaling Plan")
 *             .exclusionTag("value")
 *             .friendlyName("Scaling Plan 1")
 *             .hostPoolReferences(ScalingHostPoolReferenceArgs.builder()
 *                 .hostPoolArmPath("/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1")
 *                 .scalingPlanEnabled(true)
 *                 .build())
 *             .hostPoolType("Pooled")
 *             .location("centralus")
 *             .resourceGroupName("resourceGroup1")
 *             .scalingPlanName("scalingPlan1")
 *             .schedules(ScalingScheduleArgs.builder()
 *                 .daysOfWeek(
 *                     "Monday",
 *                     "Tuesday",
 *                     "Wednesday",
 *                     "Thursday",
 *                     "Friday")
 *                 .name("schedule1")
 *                 .offPeakLoadBalancingAlgorithm("DepthFirst")
 *                 .offPeakStartTime(TimeArgs.builder()
 *                     .hour(20)
 *                     .minute(0)
 *                     .build())
 *                 .peakLoadBalancingAlgorithm("BreadthFirst")
 *                 .peakStartTime(TimeArgs.builder()
 *                     .hour(8)
 *                     .minute(0)
 *                     .build())
 *                 .rampDownCapacityThresholdPct(50)
 *                 .rampDownForceLogoffUsers(true)
 *                 .rampDownLoadBalancingAlgorithm("DepthFirst")
 *                 .rampDownMinimumHostsPct(20)
 *                 .rampDownNotificationMessage("message")
 *                 .rampDownStartTime(TimeArgs.builder()
 *                     .hour(18)
 *                     .minute(0)
 *                     .build())
 *                 .rampDownWaitTimeMinutes(30)
 *                 .rampUpCapacityThresholdPct(80)
 *                 .rampUpLoadBalancingAlgorithm("DepthFirst")
 *                 .rampUpMinimumHostsPct(20)
 *                 .rampUpStartTime(TimeArgs.builder()
 *                     .hour(6)
 *                     .minute(0)
 *                     .build())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .timeZone("Central Standard Time")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:ScalingPlan scalingPlan1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}
 * ```
 * @property description Description of scaling plan.
 * @property exclusionTag Exclusion tag for scaling plan.
 * @property friendlyName User friendly name of scaling plan.
 * @property hostPoolReferences List of ScalingHostPoolReference definitions.
 * @property hostPoolType HostPool type for desktop.
 * @property identity
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location The geo-location where the resource lives
 * @property managedBy The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
 * @property plan
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingPlanName The name of the scaling plan.
 * @property schedules List of ScalingPlanPooledSchedule definitions.
 * @property sku
 * @property tags Resource tags.
 * @property timeZone Timezone of the scaling plan.
 */
public data class ScalingPlanArgs(
    public val description: Output<String>? = null,
    public val exclusionTag: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val hostPoolReferences: Output<List<ScalingHostPoolReferenceArgs>>? = null,
    public val hostPoolType: Output<Either<String, ScalingHostPoolType>>? = null,
    public val identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalingPlanName: Output<String>? = null,
    public val schedules: Output<List<ScalingScheduleArgs>>? = null,
    public val sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.ScalingPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.ScalingPlanArgs =
        com.pulumi.azurenative.desktopvirtualization.ScalingPlanArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .exclusionTag(exclusionTag?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .hostPoolReferences(
                hostPoolReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .hostPoolType(
                hostPoolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalingPlanName(scalingPlanName?.applyValue({ args0 -> args0 }))
            .schedules(
                schedules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingPlanArgs].
 */
@PulumiTagMarker
public class ScalingPlanArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var exclusionTag: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var hostPoolReferences: Output<List<ScalingHostPoolReferenceArgs>>? = null

    private var hostPoolType: Output<Either<String, ScalingHostPoolType>>? = null

    private var identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalingPlanName: Output<String>? = null

    private var schedules: Output<List<ScalingScheduleArgs>>? = null

    private var sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value Description of scaling plan.
     */
    @JvmName("chmenfsrqfkannrm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Exclusion tag for scaling plan.
     */
    @JvmName("nbcrcfcvcvgadwvo")
    public suspend fun exclusionTag(`value`: Output<String>) {
        this.exclusionTag = value
    }

    /**
     * @param value User friendly name of scaling plan.
     */
    @JvmName("bklxituxbriykuck")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value List of ScalingHostPoolReference definitions.
     */
    @JvmName("yrjucgysjhmlxjdb")
    public suspend fun hostPoolReferences(`value`: Output<List<ScalingHostPoolReferenceArgs>>) {
        this.hostPoolReferences = value
    }

    @JvmName("rurqxmiglpissydi")
    public suspend fun hostPoolReferences(vararg values: Output<ScalingHostPoolReferenceArgs>) {
        this.hostPoolReferences = Output.all(values.asList())
    }

    /**
     * @param values List of ScalingHostPoolReference definitions.
     */
    @JvmName("qqmioufsxcijlryl")
    public suspend fun hostPoolReferences(values: List<Output<ScalingHostPoolReferenceArgs>>) {
        this.hostPoolReferences = Output.all(values)
    }

    /**
     * @param value HostPool type for desktop.
     */
    @JvmName("hmvfjtlqrpduukxd")
    public suspend fun hostPoolType(`value`: Output<Either<String, ScalingHostPoolType>>) {
        this.hostPoolType = value
    }

    /**
     * @param value
     */
    @JvmName("sqcbyfbagxhpugkk")
    public suspend fun identity(`value`: Output<ResourceModelWithAllowedPropertySetIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("gtuulsdvbtdsgwml")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yiwxlvpkxjbqyeae")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("malrsjnvwbkbtuvu")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value
     */
    @JvmName("mtqydmkaukrkotla")
    public suspend fun plan(`value`: Output<ResourceModelWithAllowedPropertySetPlanArgs>) {
        this.plan = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xogtwpnfvpgalrkc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("deeotagigwicjsfb")
    public suspend fun scalingPlanName(`value`: Output<String>) {
        this.scalingPlanName = value
    }

    /**
     * @param value List of ScalingPlanPooledSchedule definitions.
     */
    @JvmName("fpyhxovbvwrxmwtk")
    public suspend fun schedules(`value`: Output<List<ScalingScheduleArgs>>) {
        this.schedules = value
    }

    @JvmName("fxoejufnegbosuat")
    public suspend fun schedules(vararg values: Output<ScalingScheduleArgs>) {
        this.schedules = Output.all(values.asList())
    }

    /**
     * @param values List of ScalingPlanPooledSchedule definitions.
     */
    @JvmName("tgmgtcenusnokyau")
    public suspend fun schedules(values: List<Output<ScalingScheduleArgs>>) {
        this.schedules = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lasxqepsdvkunnos")
    public suspend fun sku(`value`: Output<ResourceModelWithAllowedPropertySetSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tfxpkjbmwitwdkcj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Timezone of the scaling plan.
     */
    @JvmName("qqaknvbnicnnyoue")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value Description of scaling plan.
     */
    @JvmName("srcfbacnyhaspxsf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Exclusion tag for scaling plan.
     */
    @JvmName("wnhmpekinvswbvyt")
    public suspend fun exclusionTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusionTag = mapped
    }

    /**
     * @param value User friendly name of scaling plan.
     */
    @JvmName("hlkpbxiqltmdinxg")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value List of ScalingHostPoolReference definitions.
     */
    @JvmName("waituaqoyshsqmrp")
    public suspend fun hostPoolReferences(`value`: List<ScalingHostPoolReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPoolReferences = mapped
    }

    /**
     * @param argument List of ScalingHostPoolReference definitions.
     */
    @JvmName("irykxfvpjbadhbyk")
    public suspend
    fun hostPoolReferences(argument: List<suspend ScalingHostPoolReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingHostPoolReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hostPoolReferences = mapped
    }

    /**
     * @param argument List of ScalingHostPoolReference definitions.
     */
    @JvmName("rdhxtusgkxnuignt")
    public suspend fun hostPoolReferences(
        vararg
        argument: suspend ScalingHostPoolReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ScalingHostPoolReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.hostPoolReferences = mapped
    }

    /**
     * @param argument List of ScalingHostPoolReference definitions.
     */
    @JvmName("smirdgwoyqrxttau")
    public suspend
    fun hostPoolReferences(argument: suspend ScalingHostPoolReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingHostPoolReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.hostPoolReferences = mapped
    }

    /**
     * @param values List of ScalingHostPoolReference definitions.
     */
    @JvmName("hgcijrguujrdkjto")
    public suspend fun hostPoolReferences(vararg values: ScalingHostPoolReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPoolReferences = mapped
    }

    /**
     * @param value HostPool type for desktop.
     */
    @JvmName("eihcgfleocnosfap")
    public suspend fun hostPoolType(`value`: Either<String, ScalingHostPoolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPoolType = mapped
    }

    /**
     * @param value HostPool type for desktop.
     */
    @JvmName("hnawgttollwvwgxu")
    public fun hostPoolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScalingHostPoolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPoolType = mapped
    }

    /**
     * @param value HostPool type for desktop.
     */
    @JvmName("rjgojisxgbgkjviq")
    public fun hostPoolType(`value`: ScalingHostPoolType) {
        val toBeMapped = Either.ofRight<String, ScalingHostPoolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostPoolType = mapped
    }

    /**
     * @param value
     */
    @JvmName("rmvexkpxbiqetqdh")
    public suspend fun identity(`value`: ResourceModelWithAllowedPropertySetIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qonsyefeijpgvhuu")
    public suspend
    fun identity(argument: suspend ResourceModelWithAllowedPropertySetIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("lkojgbynlysyxthe")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("feefabgtsqpdjfff")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("gkigbotctvmwqgbg")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value
     */
    @JvmName("tsuoambasxgvkyvl")
    public suspend fun plan(`value`: ResourceModelWithAllowedPropertySetPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument
     */
    @JvmName("seqipcgijjhskpjy")
    public suspend
    fun plan(argument: suspend ResourceModelWithAllowedPropertySetPlanArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetPlanArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rxcowbsiuyniykpw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("suhfrkkvbyuqoeuy")
    public suspend fun scalingPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPlanName = mapped
    }

    /**
     * @param value List of ScalingPlanPooledSchedule definitions.
     */
    @JvmName("cfhtjrcobywfxmwk")
    public suspend fun schedules(`value`: List<ScalingScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param argument List of ScalingPlanPooledSchedule definitions.
     */
    @JvmName("tbkeokowtvkpxqgf")
    public suspend fun schedules(argument: List<suspend ScalingScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingScheduleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument List of ScalingPlanPooledSchedule definitions.
     */
    @JvmName("pvvcxlmtmhhpyeeb")
    public suspend fun schedules(vararg argument: suspend ScalingScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingScheduleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param argument List of ScalingPlanPooledSchedule definitions.
     */
    @JvmName("hqjwokcyohswapqw")
    public suspend fun schedules(argument: suspend ScalingScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScalingScheduleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.schedules = mapped
    }

    /**
     * @param values List of ScalingPlanPooledSchedule definitions.
     */
    @JvmName("cwyqhcoealxeirbj")
    public suspend fun schedules(vararg values: ScalingScheduleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedules = mapped
    }

    /**
     * @param value
     */
    @JvmName("etyyovdqrtpoeclv")
    public suspend fun sku(`value`: ResourceModelWithAllowedPropertySetSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bsskmptmepaphrso")
    public suspend
    fun sku(argument: suspend ResourceModelWithAllowedPropertySetSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetSkuArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sfncrmatifawofna")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fcdeabmsgvkbspyq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Timezone of the scaling plan.
     */
    @JvmName("ifndujkdtdybuvar")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): ScalingPlanArgs = ScalingPlanArgs(
        description = description,
        exclusionTag = exclusionTag,
        friendlyName = friendlyName,
        hostPoolReferences = hostPoolReferences,
        hostPoolType = hostPoolType,
        identity = identity,
        kind = kind,
        location = location,
        managedBy = managedBy,
        plan = plan,
        resourceGroupName = resourceGroupName,
        scalingPlanName = scalingPlanName,
        schedules = schedules,
        sku = sku,
        tags = tags,
        timeZone = timeZone,
    )
}
