@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin as timeResponseToKotlin

/**
 * Builder for [ScalingPlanPersonalSchedule].
 */
@PulumiTagMarker
public class ScalingPlanPersonalScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScalingPlanPersonalScheduleArgs = ScalingPlanPersonalScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScalingPlanPersonalScheduleArgsBuilder.() -> Unit) {
        val builder = ScalingPlanPersonalScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScalingPlanPersonalSchedule {
        val builtJavaResource =
            com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalSchedule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScalingPlanPersonalSchedule(builtJavaResource)
    }
}

/**
 * Represents a ScalingPlanPersonalSchedule definition.
 * Azure REST API version: 2023-07-07-preview.
 * Other available API versions: 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview.
 * ## Example Usage
 * ### ScalingPlanPersonalSchedules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scalingPlanPersonalSchedule = new AzureNative.DesktopVirtualization.ScalingPlanPersonalSchedule("scalingPlanPersonalSchedule", new()
 *     {
 *         DaysOfWeek = new[]
 *         {
 *             AzureNative.DesktopVirtualization.DayOfWeek.Monday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Tuesday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Wednesday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Thursday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Friday,
 *         },
 *         OffPeakActionOnDisconnect = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         OffPeakActionOnLogoff = AzureNative.DesktopVirtualization.SessionHandlingOperation.Deallocate,
 *         OffPeakMinutesToWaitOnDisconnect = 10,
 *         OffPeakMinutesToWaitOnLogoff = 10,
 *         OffPeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 20,
 *             Minute = 0,
 *         },
 *         OffPeakStartVMOnConnect = AzureNative.DesktopVirtualization.SetStartVMOnConnect.Enable,
 *         PeakActionOnDisconnect = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         PeakActionOnLogoff = AzureNative.DesktopVirtualization.SessionHandlingOperation.Deallocate,
 *         PeakMinutesToWaitOnDisconnect = 10,
 *         PeakMinutesToWaitOnLogoff = 10,
 *         PeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 8,
 *             Minute = 0,
 *         },
 *         PeakStartVMOnConnect = AzureNative.DesktopVirtualization.SetStartVMOnConnect.Enable,
 *         RampDownActionOnDisconnect = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         RampDownActionOnLogoff = AzureNative.DesktopVirtualization.SessionHandlingOperation.Deallocate,
 *         RampDownMinutesToWaitOnDisconnect = 10,
 *         RampDownMinutesToWaitOnLogoff = 10,
 *         RampDownStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 18,
 *             Minute = 0,
 *         },
 *         RampDownStartVMOnConnect = AzureNative.DesktopVirtualization.SetStartVMOnConnect.Enable,
 *         RampUpActionOnDisconnect = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         RampUpActionOnLogoff = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         RampUpAutoStartHosts = AzureNative.DesktopVirtualization.StartupBehavior.All,
 *         RampUpMinutesToWaitOnDisconnect = 10,
 *         RampUpMinutesToWaitOnLogoff = 10,
 *         RampUpStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 6,
 *             Minute = 0,
 *         },
 *         RampUpStartVMOnConnect = AzureNative.DesktopVirtualization.SetStartVMOnConnect.Enable,
 *         ResourceGroupName = "resourceGroup1",
 *         ScalingPlanName = "scalingPlan1",
 *         ScalingPlanScheduleName = "scalingPlanScheduleWeekdays1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewScalingPlanPersonalSchedule(ctx, "scalingPlanPersonalSchedule", &desktopvirtualization.ScalingPlanPersonalScheduleArgs{
 * 			DaysOfWeek: pulumi.StringArray{
 * 				pulumi.String(desktopvirtualization.DayOfWeekMonday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekTuesday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekWednesday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekThursday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekFriday),
 * 			},
 * 			OffPeakActionOnDisconnect:        pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			OffPeakActionOnLogoff:            pulumi.String(desktopvirtualization.SessionHandlingOperationDeallocate),
 * 			OffPeakMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			OffPeakMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			OffPeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(20),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			OffPeakStartVMOnConnect:       pulumi.String(desktopvirtualization.SetStartVMOnConnectEnable),
 * 			PeakActionOnDisconnect:        pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			PeakActionOnLogoff:            pulumi.String(desktopvirtualization.SessionHandlingOperationDeallocate),
 * 			PeakMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			PeakMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			PeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(8),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			PeakStartVMOnConnect:              pulumi.String(desktopvirtualization.SetStartVMOnConnectEnable),
 * 			RampDownActionOnDisconnect:        pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			RampDownActionOnLogoff:            pulumi.String(desktopvirtualization.SessionHandlingOperationDeallocate),
 * 			RampDownMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			RampDownMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			RampDownStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(18),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampDownStartVMOnConnect:        pulumi.String(desktopvirtualization.SetStartVMOnConnectEnable),
 * 			RampUpActionOnDisconnect:        pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			RampUpActionOnLogoff:            pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			RampUpAutoStartHosts:            pulumi.String(desktopvirtualization.StartupBehaviorAll),
 * 			RampUpMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			RampUpMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			RampUpStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(6),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampUpStartVMOnConnect:  pulumi.String(desktopvirtualization.SetStartVMOnConnectEnable),
 * 			ResourceGroupName:       pulumi.String("resourceGroup1"),
 * 			ScalingPlanName:         pulumi.String("scalingPlan1"),
 * 			ScalingPlanScheduleName: pulumi.String("scalingPlanScheduleWeekdays1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalSchedule;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scalingPlanPersonalSchedule = new ScalingPlanPersonalSchedule("scalingPlanPersonalSchedule", ScalingPlanPersonalScheduleArgs.builder()
 *             .daysOfWeek(
 *                 "Monday",
 *                 "Tuesday",
 *                 "Wednesday",
 *                 "Thursday",
 *                 "Friday")
 *             .offPeakActionOnDisconnect("None")
 *             .offPeakActionOnLogoff("Deallocate")
 *             .offPeakMinutesToWaitOnDisconnect(10)
 *             .offPeakMinutesToWaitOnLogoff(10)
 *             .offPeakStartTime(TimeArgs.builder()
 *                 .hour(20)
 *                 .minute(0)
 *                 .build())
 *             .offPeakStartVMOnConnect("Enable")
 *             .peakActionOnDisconnect("None")
 *             .peakActionOnLogoff("Deallocate")
 *             .peakMinutesToWaitOnDisconnect(10)
 *             .peakMinutesToWaitOnLogoff(10)
 *             .peakStartTime(TimeArgs.builder()
 *                 .hour(8)
 *                 .minute(0)
 *                 .build())
 *             .peakStartVMOnConnect("Enable")
 *             .rampDownActionOnDisconnect("None")
 *             .rampDownActionOnLogoff("Deallocate")
 *             .rampDownMinutesToWaitOnDisconnect(10)
 *             .rampDownMinutesToWaitOnLogoff(10)
 *             .rampDownStartTime(TimeArgs.builder()
 *                 .hour(18)
 *                 .minute(0)
 *                 .build())
 *             .rampDownStartVMOnConnect("Enable")
 *             .rampUpActionOnDisconnect("None")
 *             .rampUpActionOnLogoff("None")
 *             .rampUpAutoStartHosts("All")
 *             .rampUpMinutesToWaitOnDisconnect(10)
 *             .rampUpMinutesToWaitOnLogoff(10)
 *             .rampUpStartTime(TimeArgs.builder()
 *                 .hour(6)
 *                 .minute(0)
 *                 .build())
 *             .rampUpStartVMOnConnect("Enable")
 *             .resourceGroupName("resourceGroup1")
 *             .scalingPlanName("scalingPlan1")
 *             .scalingPlanScheduleName("scalingPlanScheduleWeekdays1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:ScalingPlanPersonalSchedule scalingPlanScheduleWeekdays1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/personalSchedules/{scalingPlanScheduleName}
 * ```
 */
public class ScalingPlanPersonalSchedule internal constructor(
    override val javaResource:
    com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalSchedule,
) : KotlinCustomResource(javaResource, ScalingPlanPersonalScheduleMapper) {
    /**
     * Set of days of the week on which this schedule is active.
     */
    public val daysOfWeek: Output<List<String>>?
        get() = javaResource.daysOfWeek().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Action to be taken after a user disconnect during the off-peak period.
     */
    public val offPeakActionOnDisconnect: Output<String>?
        get() = javaResource.offPeakActionOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Action to be taken after a logoff during the off-peak period.
     */
    public val offPeakActionOnLogoff: Output<String>?
        get() = javaResource.offPeakActionOnLogoff().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak period.
     */
    public val offPeakMinutesToWaitOnDisconnect: Output<Int>?
        get() = javaResource.offPeakMinutesToWaitOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak period.
     */
    public val offPeakMinutesToWaitOnLogoff: Output<Int>?
        get() = javaResource.offPeakMinutesToWaitOnLogoff().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Starting time for off-peak period.
     */
    public val offPeakStartTime: Output<TimeResponse>?
        get() = javaResource.offPeakStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    public val offPeakStartVMOnConnect: Output<String>?
        get() = javaResource.offPeakStartVMOnConnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Action to be taken after a user disconnect during the peak period.
     */
    public val peakActionOnDisconnect: Output<String>?
        get() = javaResource.peakActionOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Action to be taken after a logoff during the peak period.
     */
    public val peakActionOnLogoff: Output<String>?
        get() = javaResource.peakActionOnLogoff().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak period.
     */
    public val peakMinutesToWaitOnDisconnect: Output<Int>?
        get() = javaResource.peakMinutesToWaitOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in minutes to wait before performing the desired session handling action when a user logs off during the peak period.
     */
    public val peakMinutesToWaitOnLogoff: Output<Int>?
        get() = javaResource.peakMinutesToWaitOnLogoff().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Starting time for peak period.
     */
    public val peakStartTime: Output<TimeResponse>?
        get() = javaResource.peakStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    public val peakStartVMOnConnect: Output<String>?
        get() = javaResource.peakStartVMOnConnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Action to be taken after a user disconnect during the ramp down period.
     */
    public val rampDownActionOnDisconnect: Output<String>?
        get() = javaResource.rampDownActionOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Action to be taken after a logoff during the ramp down period.
     */
    public val rampDownActionOnLogoff: Output<String>?
        get() = javaResource.rampDownActionOnLogoff().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp down period.
     */
    public val rampDownMinutesToWaitOnDisconnect: Output<Int>?
        get() = javaResource.rampDownMinutesToWaitOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp down period.
     */
    public val rampDownMinutesToWaitOnLogoff: Output<Int>?
        get() = javaResource.rampDownMinutesToWaitOnLogoff().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Starting time for ramp down period.
     */
    public val rampDownStartTime: Output<TimeResponse>?
        get() = javaResource.rampDownStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    public val rampDownStartVMOnConnect: Output<String>?
        get() = javaResource.rampDownStartVMOnConnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Action to be taken after a user disconnect during the ramp up period.
     */
    public val rampUpActionOnDisconnect: Output<String>?
        get() = javaResource.rampUpActionOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Action to be taken after a logoff during the ramp up period.
     */
    public val rampUpActionOnLogoff: Output<String>?
        get() = javaResource.rampUpActionOnLogoff().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    public val rampUpAutoStartHosts: Output<String>?
        get() = javaResource.rampUpAutoStartHosts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp up period.
     */
    public val rampUpMinutesToWaitOnDisconnect: Output<Int>?
        get() = javaResource.rampUpMinutesToWaitOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp up period.
     */
    public val rampUpMinutesToWaitOnLogoff: Output<Int>?
        get() = javaResource.rampUpMinutesToWaitOnLogoff().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Starting time for ramp up period.
     */
    public val rampUpStartTime: Output<TimeResponse>?
        get() = javaResource.rampUpStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> timeResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    public val rampUpStartVMOnConnect: Output<String>?
        get() = javaResource.rampUpStartVMOnConnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScalingPlanPersonalScheduleMapper : ResourceMapper<ScalingPlanPersonalSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalSchedule::class == javaResource::class

    override fun map(javaResource: Resource): ScalingPlanPersonalSchedule =
        ScalingPlanPersonalSchedule(
            javaResource as
                com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalSchedule,
        )
}

/**
 * @see [ScalingPlanPersonalSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScalingPlanPersonalSchedule].
 */
public suspend fun scalingPlanPersonalSchedule(
    name: String,
    block: suspend ScalingPlanPersonalScheduleResourceBuilder.() -> Unit,
):
    ScalingPlanPersonalSchedule {
    val builder = ScalingPlanPersonalScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScalingPlanPersonalSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scalingPlanPersonalSchedule(name: String): ScalingPlanPersonalSchedule {
    val builder = ScalingPlanPersonalScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
