@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.DayOfWeek
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SessionHandlingOperation
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SetStartVMOnConnect
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.StartupBehavior
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.TimeArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.TimeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a ScalingPlanPersonalSchedule definition.
 * Azure REST API version: 2023-07-07-preview.
 * Other available API versions: 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview.
 * ## Example Usage
 * ### ScalingPlanPersonalSchedules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scalingPlanPersonalSchedule = new AzureNative.DesktopVirtualization.ScalingPlanPersonalSchedule("scalingPlanPersonalSchedule", new()
 *     {
 *         DaysOfWeek = new[]
 *         {
 *             AzureNative.DesktopVirtualization.DayOfWeek.Monday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Tuesday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Wednesday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Thursday,
 *             AzureNative.DesktopVirtualization.DayOfWeek.Friday,
 *         },
 *         OffPeakActionOnDisconnect = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         OffPeakActionOnLogoff = AzureNative.DesktopVirtualization.SessionHandlingOperation.Deallocate,
 *         OffPeakMinutesToWaitOnDisconnect = 10,
 *         OffPeakMinutesToWaitOnLogoff = 10,
 *         OffPeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 20,
 *             Minute = 0,
 *         },
 *         OffPeakStartVMOnConnect = AzureNative.DesktopVirtualization.SetStartVMOnConnect.Enable,
 *         PeakActionOnDisconnect = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         PeakActionOnLogoff = AzureNative.DesktopVirtualization.SessionHandlingOperation.Deallocate,
 *         PeakMinutesToWaitOnDisconnect = 10,
 *         PeakMinutesToWaitOnLogoff = 10,
 *         PeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 8,
 *             Minute = 0,
 *         },
 *         PeakStartVMOnConnect = AzureNative.DesktopVirtualization.SetStartVMOnConnect.Enable,
 *         RampDownActionOnDisconnect = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         RampDownActionOnLogoff = AzureNative.DesktopVirtualization.SessionHandlingOperation.Deallocate,
 *         RampDownMinutesToWaitOnDisconnect = 10,
 *         RampDownMinutesToWaitOnLogoff = 10,
 *         RampDownStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 18,
 *             Minute = 0,
 *         },
 *         RampDownStartVMOnConnect = AzureNative.DesktopVirtualization.SetStartVMOnConnect.Enable,
 *         RampUpActionOnDisconnect = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         RampUpActionOnLogoff = AzureNative.DesktopVirtualization.SessionHandlingOperation.None,
 *         RampUpAutoStartHosts = AzureNative.DesktopVirtualization.StartupBehavior.All,
 *         RampUpMinutesToWaitOnDisconnect = 10,
 *         RampUpMinutesToWaitOnLogoff = 10,
 *         RampUpStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 6,
 *             Minute = 0,
 *         },
 *         RampUpStartVMOnConnect = AzureNative.DesktopVirtualization.SetStartVMOnConnect.Enable,
 *         ResourceGroupName = "resourceGroup1",
 *         ScalingPlanName = "scalingPlan1",
 *         ScalingPlanScheduleName = "scalingPlanScheduleWeekdays1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewScalingPlanPersonalSchedule(ctx, "scalingPlanPersonalSchedule", &desktopvirtualization.ScalingPlanPersonalScheduleArgs{
 * 			DaysOfWeek: pulumi.StringArray{
 * 				pulumi.String(desktopvirtualization.DayOfWeekMonday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekTuesday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekWednesday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekThursday),
 * 				pulumi.String(desktopvirtualization.DayOfWeekFriday),
 * 			},
 * 			OffPeakActionOnDisconnect:        pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			OffPeakActionOnLogoff:            pulumi.String(desktopvirtualization.SessionHandlingOperationDeallocate),
 * 			OffPeakMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			OffPeakMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			OffPeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(20),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			OffPeakStartVMOnConnect:       pulumi.String(desktopvirtualization.SetStartVMOnConnectEnable),
 * 			PeakActionOnDisconnect:        pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			PeakActionOnLogoff:            pulumi.String(desktopvirtualization.SessionHandlingOperationDeallocate),
 * 			PeakMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			PeakMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			PeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(8),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			PeakStartVMOnConnect:              pulumi.String(desktopvirtualization.SetStartVMOnConnectEnable),
 * 			RampDownActionOnDisconnect:        pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			RampDownActionOnLogoff:            pulumi.String(desktopvirtualization.SessionHandlingOperationDeallocate),
 * 			RampDownMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			RampDownMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			RampDownStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(18),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampDownStartVMOnConnect:        pulumi.String(desktopvirtualization.SetStartVMOnConnectEnable),
 * 			RampUpActionOnDisconnect:        pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			RampUpActionOnLogoff:            pulumi.String(desktopvirtualization.SessionHandlingOperationNone),
 * 			RampUpAutoStartHosts:            pulumi.String(desktopvirtualization.StartupBehaviorAll),
 * 			RampUpMinutesToWaitOnDisconnect: pulumi.Int(10),
 * 			RampUpMinutesToWaitOnLogoff:     pulumi.Int(10),
 * 			RampUpStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(6),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampUpStartVMOnConnect:  pulumi.String(desktopvirtualization.SetStartVMOnConnectEnable),
 * 			ResourceGroupName:       pulumi.String("resourceGroup1"),
 * 			ScalingPlanName:         pulumi.String("scalingPlan1"),
 * 			ScalingPlanScheduleName: pulumi.String("scalingPlanScheduleWeekdays1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalSchedule;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs;
 * import com.pulumi.azurenative.desktopvirtualization.inputs.TimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scalingPlanPersonalSchedule = new ScalingPlanPersonalSchedule("scalingPlanPersonalSchedule", ScalingPlanPersonalScheduleArgs.builder()
 *             .daysOfWeek(
 *                 "Monday",
 *                 "Tuesday",
 *                 "Wednesday",
 *                 "Thursday",
 *                 "Friday")
 *             .offPeakActionOnDisconnect("None")
 *             .offPeakActionOnLogoff("Deallocate")
 *             .offPeakMinutesToWaitOnDisconnect(10)
 *             .offPeakMinutesToWaitOnLogoff(10)
 *             .offPeakStartTime(TimeArgs.builder()
 *                 .hour(20)
 *                 .minute(0)
 *                 .build())
 *             .offPeakStartVMOnConnect("Enable")
 *             .peakActionOnDisconnect("None")
 *             .peakActionOnLogoff("Deallocate")
 *             .peakMinutesToWaitOnDisconnect(10)
 *             .peakMinutesToWaitOnLogoff(10)
 *             .peakStartTime(TimeArgs.builder()
 *                 .hour(8)
 *                 .minute(0)
 *                 .build())
 *             .peakStartVMOnConnect("Enable")
 *             .rampDownActionOnDisconnect("None")
 *             .rampDownActionOnLogoff("Deallocate")
 *             .rampDownMinutesToWaitOnDisconnect(10)
 *             .rampDownMinutesToWaitOnLogoff(10)
 *             .rampDownStartTime(TimeArgs.builder()
 *                 .hour(18)
 *                 .minute(0)
 *                 .build())
 *             .rampDownStartVMOnConnect("Enable")
 *             .rampUpActionOnDisconnect("None")
 *             .rampUpActionOnLogoff("None")
 *             .rampUpAutoStartHosts("All")
 *             .rampUpMinutesToWaitOnDisconnect(10)
 *             .rampUpMinutesToWaitOnLogoff(10)
 *             .rampUpStartTime(TimeArgs.builder()
 *                 .hour(6)
 *                 .minute(0)
 *                 .build())
 *             .rampUpStartVMOnConnect("Enable")
 *             .resourceGroupName("resourceGroup1")
 *             .scalingPlanName("scalingPlan1")
 *             .scalingPlanScheduleName("scalingPlanScheduleWeekdays1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:ScalingPlanPersonalSchedule scalingPlanScheduleWeekdays1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/personalSchedules/{scalingPlanScheduleName}
 * ```
 * @property daysOfWeek Set of days of the week on which this schedule is active.
 * @property offPeakActionOnDisconnect Action to be taken after a user disconnect during the off-peak period.
 * @property offPeakActionOnLogoff Action to be taken after a logoff during the off-peak period.
 * @property offPeakMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak period.
 * @property offPeakMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak period.
 * @property offPeakStartTime Starting time for off-peak period.
 * @property offPeakStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
 * @property peakActionOnDisconnect Action to be taken after a user disconnect during the peak period.
 * @property peakActionOnLogoff Action to be taken after a logoff during the peak period.
 * @property peakMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak period.
 * @property peakMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the peak period.
 * @property peakStartTime Starting time for peak period.
 * @property peakStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the peak phase.
 * @property rampDownActionOnDisconnect Action to be taken after a user disconnect during the ramp down period.
 * @property rampDownActionOnLogoff Action to be taken after a logoff during the ramp down period.
 * @property rampDownMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp down period.
 * @property rampDownMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp down period.
 * @property rampDownStartTime Starting time for ramp down period.
 * @property rampDownStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
 * @property rampUpActionOnDisconnect Action to be taken after a user disconnect during the ramp up period.
 * @property rampUpActionOnLogoff Action to be taken after a logoff during the ramp up period.
 * @property rampUpAutoStartHosts The desired startup behavior during the ramp up period for personal vms in the hostpool.
 * @property rampUpMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp up period.
 * @property rampUpMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp up period.
 * @property rampUpStartTime Starting time for ramp up period.
 * @property rampUpStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingPlanName The name of the scaling plan.
 * @property scalingPlanScheduleName The name of the ScalingPlanSchedule
 */
public data class ScalingPlanPersonalScheduleArgs(
    public val daysOfWeek: Output<List<Either<String, DayOfWeek>>>? = null,
    public val offPeakActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null,
    public val offPeakActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null,
    public val offPeakMinutesToWaitOnDisconnect: Output<Int>? = null,
    public val offPeakMinutesToWaitOnLogoff: Output<Int>? = null,
    public val offPeakStartTime: Output<TimeArgs>? = null,
    public val offPeakStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null,
    public val peakActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null,
    public val peakActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null,
    public val peakMinutesToWaitOnDisconnect: Output<Int>? = null,
    public val peakMinutesToWaitOnLogoff: Output<Int>? = null,
    public val peakStartTime: Output<TimeArgs>? = null,
    public val peakStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null,
    public val rampDownActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null,
    public val rampDownActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null,
    public val rampDownMinutesToWaitOnDisconnect: Output<Int>? = null,
    public val rampDownMinutesToWaitOnLogoff: Output<Int>? = null,
    public val rampDownStartTime: Output<TimeArgs>? = null,
    public val rampDownStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null,
    public val rampUpActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null,
    public val rampUpActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null,
    public val rampUpAutoStartHosts: Output<Either<String, StartupBehavior>>? = null,
    public val rampUpMinutesToWaitOnDisconnect: Output<Int>? = null,
    public val rampUpMinutesToWaitOnLogoff: Output<Int>? = null,
    public val rampUpStartTime: Output<TimeArgs>? = null,
    public val rampUpStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalingPlanName: Output<String>? = null,
    public val scalingPlanScheduleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs =
        com.pulumi.azurenative.desktopvirtualization.ScalingPlanPersonalScheduleArgs.builder()
            .daysOfWeek(
                daysOfWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .offPeakActionOnDisconnect(
                offPeakActionOnDisconnect?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .offPeakActionOnLogoff(
                offPeakActionOnLogoff?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .offPeakMinutesToWaitOnDisconnect(offPeakMinutesToWaitOnDisconnect?.applyValue({ args0 -> args0 }))
            .offPeakMinutesToWaitOnLogoff(offPeakMinutesToWaitOnLogoff?.applyValue({ args0 -> args0 }))
            .offPeakStartTime(offPeakStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .offPeakStartVMOnConnect(
                offPeakStartVMOnConnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .peakActionOnDisconnect(
                peakActionOnDisconnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .peakActionOnLogoff(
                peakActionOnLogoff?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .peakMinutesToWaitOnDisconnect(peakMinutesToWaitOnDisconnect?.applyValue({ args0 -> args0 }))
            .peakMinutesToWaitOnLogoff(peakMinutesToWaitOnLogoff?.applyValue({ args0 -> args0 }))
            .peakStartTime(peakStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .peakStartVMOnConnect(
                peakStartVMOnConnect?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .rampDownActionOnDisconnect(
                rampDownActionOnDisconnect?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampDownActionOnLogoff(
                rampDownActionOnLogoff?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampDownMinutesToWaitOnDisconnect(
                rampDownMinutesToWaitOnDisconnect?.applyValue({ args0 ->
                    args0
                }),
            )
            .rampDownMinutesToWaitOnLogoff(rampDownMinutesToWaitOnLogoff?.applyValue({ args0 -> args0 }))
            .rampDownStartTime(rampDownStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rampDownStartVMOnConnect(
                rampDownStartVMOnConnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampUpActionOnDisconnect(
                rampUpActionOnDisconnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampUpActionOnLogoff(
                rampUpActionOnLogoff?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .rampUpAutoStartHosts(
                rampUpAutoStartHosts?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .rampUpMinutesToWaitOnDisconnect(rampUpMinutesToWaitOnDisconnect?.applyValue({ args0 -> args0 }))
            .rampUpMinutesToWaitOnLogoff(rampUpMinutesToWaitOnLogoff?.applyValue({ args0 -> args0 }))
            .rampUpStartTime(rampUpStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rampUpStartVMOnConnect(
                rampUpStartVMOnConnect?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalingPlanName(scalingPlanName?.applyValue({ args0 -> args0 }))
            .scalingPlanScheduleName(scalingPlanScheduleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingPlanPersonalScheduleArgs].
 */
@PulumiTagMarker
public class ScalingPlanPersonalScheduleArgsBuilder internal constructor() {
    private var daysOfWeek: Output<List<Either<String, DayOfWeek>>>? = null

    private var offPeakActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null

    private var offPeakActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null

    private var offPeakMinutesToWaitOnDisconnect: Output<Int>? = null

    private var offPeakMinutesToWaitOnLogoff: Output<Int>? = null

    private var offPeakStartTime: Output<TimeArgs>? = null

    private var offPeakStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null

    private var peakActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null

    private var peakActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null

    private var peakMinutesToWaitOnDisconnect: Output<Int>? = null

    private var peakMinutesToWaitOnLogoff: Output<Int>? = null

    private var peakStartTime: Output<TimeArgs>? = null

    private var peakStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null

    private var rampDownActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null

    private var rampDownActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null

    private var rampDownMinutesToWaitOnDisconnect: Output<Int>? = null

    private var rampDownMinutesToWaitOnLogoff: Output<Int>? = null

    private var rampDownStartTime: Output<TimeArgs>? = null

    private var rampDownStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null

    private var rampUpActionOnDisconnect: Output<Either<String, SessionHandlingOperation>>? = null

    private var rampUpActionOnLogoff: Output<Either<String, SessionHandlingOperation>>? = null

    private var rampUpAutoStartHosts: Output<Either<String, StartupBehavior>>? = null

    private var rampUpMinutesToWaitOnDisconnect: Output<Int>? = null

    private var rampUpMinutesToWaitOnLogoff: Output<Int>? = null

    private var rampUpStartTime: Output<TimeArgs>? = null

    private var rampUpStartVMOnConnect: Output<Either<String, SetStartVMOnConnect>>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalingPlanName: Output<String>? = null

    private var scalingPlanScheduleName: Output<String>? = null

    /**
     * @param value Set of days of the week on which this schedule is active.
     */
    @JvmName("qorurhsjjhaunlbe")
    public suspend fun daysOfWeek(`value`: Output<List<Either<String, DayOfWeek>>>) {
        this.daysOfWeek = value
    }

    @JvmName("lwntsreisrgxmdkq")
    public suspend fun daysOfWeek(vararg values: Output<Either<String, DayOfWeek>>) {
        this.daysOfWeek = Output.all(values.asList())
    }

    /**
     * @param values Set of days of the week on which this schedule is active.
     */
    @JvmName("lvylgmrxavijnrtj")
    public suspend fun daysOfWeek(values: List<Output<Either<String, DayOfWeek>>>) {
        this.daysOfWeek = Output.all(values)
    }

    /**
     * @param value Action to be taken after a user disconnect during the off-peak period.
     */
    @JvmName("bvgjaofhfyladrqw")
    public suspend
    fun offPeakActionOnDisconnect(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.offPeakActionOnDisconnect = value
    }

    /**
     * @param value Action to be taken after a logoff during the off-peak period.
     */
    @JvmName("cvltrtnpsyibthev")
    public suspend
    fun offPeakActionOnLogoff(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.offPeakActionOnLogoff = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak period.
     */
    @JvmName("tashmohxibtjulrs")
    public suspend fun offPeakMinutesToWaitOnDisconnect(`value`: Output<Int>) {
        this.offPeakMinutesToWaitOnDisconnect = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak period.
     */
    @JvmName("epwnryurnrwyxdbj")
    public suspend fun offPeakMinutesToWaitOnLogoff(`value`: Output<Int>) {
        this.offPeakMinutesToWaitOnLogoff = value
    }

    /**
     * @param value Starting time for off-peak period.
     */
    @JvmName("vwejesycalajqfse")
    public suspend fun offPeakStartTime(`value`: Output<TimeArgs>) {
        this.offPeakStartTime = value
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    @JvmName("fqulwvxyqntglfse")
    public suspend fun offPeakStartVMOnConnect(`value`: Output<Either<String, SetStartVMOnConnect>>) {
        this.offPeakStartVMOnConnect = value
    }

    /**
     * @param value Action to be taken after a user disconnect during the peak period.
     */
    @JvmName("laxeyulaxfiaxsbf")
    public suspend
    fun peakActionOnDisconnect(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.peakActionOnDisconnect = value
    }

    /**
     * @param value Action to be taken after a logoff during the peak period.
     */
    @JvmName("flhxxeogilvefmhg")
    public suspend fun peakActionOnLogoff(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.peakActionOnLogoff = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak period.
     */
    @JvmName("raxqjhjkogwayahd")
    public suspend fun peakMinutesToWaitOnDisconnect(`value`: Output<Int>) {
        this.peakMinutesToWaitOnDisconnect = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the peak period.
     */
    @JvmName("lukhsbehorlgeycl")
    public suspend fun peakMinutesToWaitOnLogoff(`value`: Output<Int>) {
        this.peakMinutesToWaitOnLogoff = value
    }

    /**
     * @param value Starting time for peak period.
     */
    @JvmName("begmfnttygytpmlb")
    public suspend fun peakStartTime(`value`: Output<TimeArgs>) {
        this.peakStartTime = value
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    @JvmName("bebpeeghxkgrpjoy")
    public suspend fun peakStartVMOnConnect(`value`: Output<Either<String, SetStartVMOnConnect>>) {
        this.peakStartVMOnConnect = value
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp down period.
     */
    @JvmName("anfjlefexhyeqbbd")
    public suspend
    fun rampDownActionOnDisconnect(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.rampDownActionOnDisconnect = value
    }

    /**
     * @param value Action to be taken after a logoff during the ramp down period.
     */
    @JvmName("nfcfuoivfpitqfra")
    public suspend
    fun rampDownActionOnLogoff(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.rampDownActionOnLogoff = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp down period.
     */
    @JvmName("ueqxnhjtgduntedt")
    public suspend fun rampDownMinutesToWaitOnDisconnect(`value`: Output<Int>) {
        this.rampDownMinutesToWaitOnDisconnect = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp down period.
     */
    @JvmName("yfbqwvnapkgskeim")
    public suspend fun rampDownMinutesToWaitOnLogoff(`value`: Output<Int>) {
        this.rampDownMinutesToWaitOnLogoff = value
    }

    /**
     * @param value Starting time for ramp down period.
     */
    @JvmName("yskqrynygtnphxum")
    public suspend fun rampDownStartTime(`value`: Output<TimeArgs>) {
        this.rampDownStartTime = value
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    @JvmName("mmyuykauhhojklky")
    public suspend
    fun rampDownStartVMOnConnect(`value`: Output<Either<String, SetStartVMOnConnect>>) {
        this.rampDownStartVMOnConnect = value
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp up period.
     */
    @JvmName("sejrrovqqhrdxbnu")
    public suspend
    fun rampUpActionOnDisconnect(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.rampUpActionOnDisconnect = value
    }

    /**
     * @param value Action to be taken after a logoff during the ramp up period.
     */
    @JvmName("owsrgyrkaciocxje")
    public suspend
    fun rampUpActionOnLogoff(`value`: Output<Either<String, SessionHandlingOperation>>) {
        this.rampUpActionOnLogoff = value
    }

    /**
     * @param value The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    @JvmName("omytbmnuydpxjirv")
    public suspend fun rampUpAutoStartHosts(`value`: Output<Either<String, StartupBehavior>>) {
        this.rampUpAutoStartHosts = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp up period.
     */
    @JvmName("dnjkyeqapocqmtcy")
    public suspend fun rampUpMinutesToWaitOnDisconnect(`value`: Output<Int>) {
        this.rampUpMinutesToWaitOnDisconnect = value
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp up period.
     */
    @JvmName("mnckvjajbbnvnoik")
    public suspend fun rampUpMinutesToWaitOnLogoff(`value`: Output<Int>) {
        this.rampUpMinutesToWaitOnLogoff = value
    }

    /**
     * @param value Starting time for ramp up period.
     */
    @JvmName("pxrufkuvnhbfukyx")
    public suspend fun rampUpStartTime(`value`: Output<TimeArgs>) {
        this.rampUpStartTime = value
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    @JvmName("nsvmscgttxsvpppk")
    public suspend fun rampUpStartVMOnConnect(`value`: Output<Either<String, SetStartVMOnConnect>>) {
        this.rampUpStartVMOnConnect = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hgjiqashcdykqsax")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("ijntjknojdohepsc")
    public suspend fun scalingPlanName(`value`: Output<String>) {
        this.scalingPlanName = value
    }

    /**
     * @param value The name of the ScalingPlanSchedule
     */
    @JvmName("pgtaygqbskhoppsm")
    public suspend fun scalingPlanScheduleName(`value`: Output<String>) {
        this.scalingPlanScheduleName = value
    }

    /**
     * @param value Set of days of the week on which this schedule is active.
     */
    @JvmName("wkbljrjxiqlflhtq")
    public suspend fun daysOfWeek(`value`: List<Either<String, DayOfWeek>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param values Set of days of the week on which this schedule is active.
     */
    @JvmName("hfafxvwlovvduhgb")
    public suspend fun daysOfWeek(vararg values: Either<String, DayOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the off-peak period.
     */
    @JvmName("ebbowjdnwqahgrxu")
    public suspend fun offPeakActionOnDisconnect(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the off-peak period.
     */
    @JvmName("onvoyimebnvhlvij")
    public fun offPeakActionOnDisconnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the off-peak period.
     */
    @JvmName("hnvtxdkglrtdyqnu")
    public fun offPeakActionOnDisconnect(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the off-peak period.
     */
    @JvmName("usgpqjxisyejhxpx")
    public suspend fun offPeakActionOnLogoff(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the off-peak period.
     */
    @JvmName("jxtfdbfskrvcnlig")
    public fun offPeakActionOnLogoff(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the off-peak period.
     */
    @JvmName("yjwkbsvmerkxwqxh")
    public fun offPeakActionOnLogoff(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakActionOnLogoff = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak period.
     */
    @JvmName("igihcoiueqmsvcxa")
    public suspend fun offPeakMinutesToWaitOnDisconnect(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakMinutesToWaitOnDisconnect = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak period.
     */
    @JvmName("coeeybgxefxgjwfd")
    public suspend fun offPeakMinutesToWaitOnLogoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakMinutesToWaitOnLogoff = mapped
    }

    /**
     * @param value Starting time for off-peak period.
     */
    @JvmName("inneeeayyihumsec")
    public suspend fun offPeakStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakStartTime = mapped
    }

    /**
     * @param argument Starting time for off-peak period.
     */
    @JvmName("pwsmdkdbklmowjia")
    public suspend fun offPeakStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.offPeakStartTime = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    @JvmName("ajglamkveaqjlhqt")
    public suspend fun offPeakStartVMOnConnect(`value`: Either<String, SetStartVMOnConnect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    @JvmName("levwahocrpipqujh")
    public fun offPeakStartVMOnConnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
     */
    @JvmName("mxrfprjoeeuodrys")
    public fun offPeakStartVMOnConnect(`value`: SetStartVMOnConnect) {
        val toBeMapped = Either.ofRight<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakStartVMOnConnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the peak period.
     */
    @JvmName("opioqridqjpccaxh")
    public suspend fun peakActionOnDisconnect(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the peak period.
     */
    @JvmName("nuoudrxeuucoitpf")
    public fun peakActionOnDisconnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the peak period.
     */
    @JvmName("gxwprigchqfgwpsn")
    public fun peakActionOnDisconnect(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the peak period.
     */
    @JvmName("ukagtbyolwfikqgp")
    public suspend fun peakActionOnLogoff(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the peak period.
     */
    @JvmName("upuhhuekdrtsgvok")
    public fun peakActionOnLogoff(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the peak period.
     */
    @JvmName("mlkgirbcnvauqnwv")
    public fun peakActionOnLogoff(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakActionOnLogoff = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak period.
     */
    @JvmName("wbsmxnbdxrqrguop")
    public suspend fun peakMinutesToWaitOnDisconnect(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakMinutesToWaitOnDisconnect = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the peak period.
     */
    @JvmName("kahppvnsreftqjht")
    public suspend fun peakMinutesToWaitOnLogoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakMinutesToWaitOnLogoff = mapped
    }

    /**
     * @param value Starting time for peak period.
     */
    @JvmName("xluadsetuiupuyqg")
    public suspend fun peakStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakStartTime = mapped
    }

    /**
     * @param argument Starting time for peak period.
     */
    @JvmName("ywvgiextghkxktxa")
    public suspend fun peakStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peakStartTime = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    @JvmName("ikwioxyqcnifdopw")
    public suspend fun peakStartVMOnConnect(`value`: Either<String, SetStartVMOnConnect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    @JvmName("omcsviloqhwchhen")
    public fun peakStartVMOnConnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the peak phase.
     */
    @JvmName("dhthajrusdasphhm")
    public fun peakStartVMOnConnect(`value`: SetStartVMOnConnect) {
        val toBeMapped = Either.ofRight<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakStartVMOnConnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp down period.
     */
    @JvmName("rkvyhgliyknkfiub")
    public suspend
    fun rampDownActionOnDisconnect(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp down period.
     */
    @JvmName("mnfypfxoqududavi")
    public fun rampDownActionOnDisconnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp down period.
     */
    @JvmName("cugiwcbvghrortiy")
    public fun rampDownActionOnDisconnect(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp down period.
     */
    @JvmName("oatqjjwwoehaikve")
    public suspend fun rampDownActionOnLogoff(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp down period.
     */
    @JvmName("ploiynuagwwvtnxy")
    public fun rampDownActionOnLogoff(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp down period.
     */
    @JvmName("ixnjguurxdvvrnvn")
    public fun rampDownActionOnLogoff(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownActionOnLogoff = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp down period.
     */
    @JvmName("puvwnsxvynpxmgdw")
    public suspend fun rampDownMinutesToWaitOnDisconnect(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownMinutesToWaitOnDisconnect = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp down period.
     */
    @JvmName("acnpyruuhmdompqo")
    public suspend fun rampDownMinutesToWaitOnLogoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownMinutesToWaitOnLogoff = mapped
    }

    /**
     * @param value Starting time for ramp down period.
     */
    @JvmName("twtryygdmraueuxv")
    public suspend fun rampDownStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownStartTime = mapped
    }

    /**
     * @param argument Starting time for ramp down period.
     */
    @JvmName("mgxsvjxsxlsnyddg")
    public suspend fun rampDownStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rampDownStartTime = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    @JvmName("dkvelwhyfmrgsybf")
    public suspend fun rampDownStartVMOnConnect(`value`: Either<String, SetStartVMOnConnect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    @JvmName("akiavacippesrfmi")
    public fun rampDownStartVMOnConnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
     */
    @JvmName("vppipegpvaflywwu")
    public fun rampDownStartVMOnConnect(`value`: SetStartVMOnConnect) {
        val toBeMapped = Either.ofRight<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownStartVMOnConnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp up period.
     */
    @JvmName("finpeajgqfkvxscl")
    public suspend fun rampUpActionOnDisconnect(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp up period.
     */
    @JvmName("qllwuaxxydxuairu")
    public fun rampUpActionOnDisconnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a user disconnect during the ramp up period.
     */
    @JvmName("ujrifjanqqqrnnag")
    public fun rampUpActionOnDisconnect(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpActionOnDisconnect = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp up period.
     */
    @JvmName("yxuvtunxrunugedm")
    public suspend fun rampUpActionOnLogoff(`value`: Either<String, SessionHandlingOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp up period.
     */
    @JvmName("isqaqokulyvkoyxr")
    public fun rampUpActionOnLogoff(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpActionOnLogoff = mapped
    }

    /**
     * @param value Action to be taken after a logoff during the ramp up period.
     */
    @JvmName("iisbijiwqltwhnul")
    public fun rampUpActionOnLogoff(`value`: SessionHandlingOperation) {
        val toBeMapped = Either.ofRight<String, SessionHandlingOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpActionOnLogoff = mapped
    }

    /**
     * @param value The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    @JvmName("kwmefqaddhjsxsjm")
    public suspend fun rampUpAutoStartHosts(`value`: Either<String, StartupBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpAutoStartHosts = mapped
    }

    /**
     * @param value The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    @JvmName("moiiydwynvyyhplf")
    public fun rampUpAutoStartHosts(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StartupBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpAutoStartHosts = mapped
    }

    /**
     * @param value The desired startup behavior during the ramp up period for personal vms in the hostpool.
     */
    @JvmName("iujjwpmuvybhwjco")
    public fun rampUpAutoStartHosts(`value`: StartupBehavior) {
        val toBeMapped = Either.ofRight<String, StartupBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpAutoStartHosts = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp up period.
     */
    @JvmName("cjnekipeqnwyupqm")
    public suspend fun rampUpMinutesToWaitOnDisconnect(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpMinutesToWaitOnDisconnect = mapped
    }

    /**
     * @param value The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp up period.
     */
    @JvmName("rojnlhxxvwcjfkqb")
    public suspend fun rampUpMinutesToWaitOnLogoff(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpMinutesToWaitOnLogoff = mapped
    }

    /**
     * @param value Starting time for ramp up period.
     */
    @JvmName("rpjjhrinfuxiypwv")
    public suspend fun rampUpStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpStartTime = mapped
    }

    /**
     * @param argument Starting time for ramp up period.
     */
    @JvmName("jeelcfhnpolsvehf")
    public suspend fun rampUpStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rampUpStartTime = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    @JvmName("lprxtrixraauydbb")
    public suspend fun rampUpStartVMOnConnect(`value`: Either<String, SetStartVMOnConnect>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    @JvmName("laylictaahofrdbw")
    public fun rampUpStartVMOnConnect(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpStartVMOnConnect = mapped
    }

    /**
     * @param value The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
     */
    @JvmName("knvwnncjxfvtfgkh")
    public fun rampUpStartVMOnConnect(`value`: SetStartVMOnConnect) {
        val toBeMapped = Either.ofRight<String, SetStartVMOnConnect>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpStartVMOnConnect = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("larqlfnmtfrlubro")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("orowhcsqsucpshgi")
    public suspend fun scalingPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPlanName = mapped
    }

    /**
     * @param value The name of the ScalingPlanSchedule
     */
    @JvmName("uratnenmohygcjhb")
    public suspend fun scalingPlanScheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPlanScheduleName = mapped
    }

    internal fun build(): ScalingPlanPersonalScheduleArgs = ScalingPlanPersonalScheduleArgs(
        daysOfWeek = daysOfWeek,
        offPeakActionOnDisconnect = offPeakActionOnDisconnect,
        offPeakActionOnLogoff = offPeakActionOnLogoff,
        offPeakMinutesToWaitOnDisconnect = offPeakMinutesToWaitOnDisconnect,
        offPeakMinutesToWaitOnLogoff = offPeakMinutesToWaitOnLogoff,
        offPeakStartTime = offPeakStartTime,
        offPeakStartVMOnConnect = offPeakStartVMOnConnect,
        peakActionOnDisconnect = peakActionOnDisconnect,
        peakActionOnLogoff = peakActionOnLogoff,
        peakMinutesToWaitOnDisconnect = peakMinutesToWaitOnDisconnect,
        peakMinutesToWaitOnLogoff = peakMinutesToWaitOnLogoff,
        peakStartTime = peakStartTime,
        peakStartVMOnConnect = peakStartVMOnConnect,
        rampDownActionOnDisconnect = rampDownActionOnDisconnect,
        rampDownActionOnLogoff = rampDownActionOnLogoff,
        rampDownMinutesToWaitOnDisconnect = rampDownMinutesToWaitOnDisconnect,
        rampDownMinutesToWaitOnLogoff = rampDownMinutesToWaitOnLogoff,
        rampDownStartTime = rampDownStartTime,
        rampDownStartVMOnConnect = rampDownStartVMOnConnect,
        rampUpActionOnDisconnect = rampUpActionOnDisconnect,
        rampUpActionOnLogoff = rampUpActionOnLogoff,
        rampUpAutoStartHosts = rampUpAutoStartHosts,
        rampUpMinutesToWaitOnDisconnect = rampUpMinutesToWaitOnDisconnect,
        rampUpMinutesToWaitOnLogoff = rampUpMinutesToWaitOnLogoff,
        rampUpStartTime = rampUpStartTime,
        rampUpStartVMOnConnect = rampUpStartVMOnConnect,
        resourceGroupName = resourceGroupName,
        scalingPlanName = scalingPlanName,
        scalingPlanScheduleName = scalingPlanScheduleName,
    )
}
