@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.WorkspaceArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a Workspace definition.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2020-11-10-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview, 2024-03-06-preview.
 * ## Example Usage
 * ### Workspace_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.DesktopVirtualization.Workspace("workspace", new()
 *     {
 *         Description = "des1",
 *         FriendlyName = "friendly",
 *         Location = "centralus",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewWorkspace(ctx, "workspace", &desktopvirtualization.WorkspaceArgs{
 * 			Description:       pulumi.String("des1"),
 * 			FriendlyName:      pulumi.String("friendly"),
 * 			Location:          pulumi.String("centralus"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			WorkspaceName: pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.Workspace;
 * import com.pulumi.azurenative.desktopvirtualization.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .description("des1")
 *             .friendlyName("friendly")
 *             .location("centralus")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:Workspace workspace1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/workspaces/{workspaceName}
 * ```
 * @property applicationGroupReferences List of applicationGroup resource Ids.
 * @property description Description of Workspace.
 * @property friendlyName Friendly name of Workspace.
 * @property identity
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location The geo-location where the resource lives
 * @property managedBy The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
 * @property plan
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku
 * @property tags Resource tags.
 * @property workspaceName The name of the workspace
 */
public data class WorkspaceArgs(
    public val applicationGroupReferences: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.WorkspaceArgs =
        com.pulumi.azurenative.desktopvirtualization.WorkspaceArgs.builder()
            .applicationGroupReferences(
                applicationGroupReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var applicationGroupReferences: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value List of applicationGroup resource Ids.
     */
    @JvmName("htasphqitgivuepb")
    public suspend fun applicationGroupReferences(`value`: Output<List<String>>) {
        this.applicationGroupReferences = value
    }

    @JvmName("clwcsojqcbuktgob")
    public suspend fun applicationGroupReferences(vararg values: Output<String>) {
        this.applicationGroupReferences = Output.all(values.asList())
    }

    /**
     * @param values List of applicationGroup resource Ids.
     */
    @JvmName("sjtvxhyvvadihrdu")
    public suspend fun applicationGroupReferences(values: List<Output<String>>) {
        this.applicationGroupReferences = Output.all(values)
    }

    /**
     * @param value Description of Workspace.
     */
    @JvmName("mrhgclpiweplphff")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Friendly name of Workspace.
     */
    @JvmName("iudjbfjahptjcnmi")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value
     */
    @JvmName("kwrqssequlrdxhnx")
    public suspend fun identity(`value`: Output<ResourceModelWithAllowedPropertySetIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("vkbvplwknxkjqgka")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("orntftfitiakrfed")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("dlvpsdfiuuvraomr")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value
     */
    @JvmName("dqjakqaqexqibpgv")
    public suspend fun plan(`value`: Output<ResourceModelWithAllowedPropertySetPlanArgs>) {
        this.plan = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gpnuwsfyhalnclcm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("htkivxapwqlkkvdo")
    public suspend fun sku(`value`: Output<ResourceModelWithAllowedPropertySetSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bagxlnsiwujcdvvt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workspace
     */
    @JvmName("twfeavwdglxsrlkw")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value List of applicationGroup resource Ids.
     */
    @JvmName("uhpqhqpiqbmrabiw")
    public suspend fun applicationGroupReferences(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGroupReferences = mapped
    }

    /**
     * @param values List of applicationGroup resource Ids.
     */
    @JvmName("gjgxmxjihliljwdf")
    public suspend fun applicationGroupReferences(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGroupReferences = mapped
    }

    /**
     * @param value Description of Workspace.
     */
    @JvmName("njsmejrfvdgvxdbs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Friendly name of Workspace.
     */
    @JvmName("oxwodkrjefgqmgbl")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("wfnkwhjvyxtafvgr")
    public suspend fun identity(`value`: ResourceModelWithAllowedPropertySetIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yyiyjraimydjfjrg")
    public suspend
    fun identity(argument: suspend ResourceModelWithAllowedPropertySetIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("ycwxughwgtuwiyji")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qwowdnurnnoqwxqs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("xtgsvvxnqjdsxiso")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value
     */
    @JvmName("ipijlesfbqarfsuq")
    public suspend fun plan(`value`: ResourceModelWithAllowedPropertySetPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eysepybuodmkchjq")
    public suspend
    fun plan(argument: suspend ResourceModelWithAllowedPropertySetPlanArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetPlanArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jvbxrjqipitwrhpu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("oipcnnkedtjeffgf")
    public suspend fun sku(`value`: ResourceModelWithAllowedPropertySetSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument
     */
    @JvmName("obuxxdcsuwgsjgdk")
    public suspend
    fun sku(argument: suspend ResourceModelWithAllowedPropertySetSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetSkuArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jjfpyaerueurbnow")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("aydrcmtrvkfxymsi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workspace
     */
    @JvmName("tgwuvpvywsmsitlp")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        applicationGroupReferences = applicationGroupReferences,
        description = description,
        friendlyName = friendlyName,
        identity = identity,
        kind = kind,
        location = location,
        managedBy = managedBy,
        plan = plan,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        workspaceName = workspaceName,
    )
}
