@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The desired startup behavior during the ramp up period for personal vms in the hostpool.
 */
public enum class StartupBehavior(
    public val javaValue: com.pulumi.azurenative.desktopvirtualization.enums.StartupBehavior,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.enums.StartupBehavior> {
    /**
     * Session hosts will not be started by the service. This setting depends on Start VM on Connect to be enabled to start the session hosts.
     */
    None(com.pulumi.azurenative.desktopvirtualization.enums.StartupBehavior.None),

    /**
     * Session hosts with an assigned user will be started during Ramp Up
     */
    WithAssignedUser(com.pulumi.azurenative.desktopvirtualization.enums.StartupBehavior.WithAssignedUser),

    /**
     * All personal session hosts in the hostpool will be started during ramp up.
     */
    All(com.pulumi.azurenative.desktopvirtualization.enums.StartupBehavior.All),
    ;

    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.enums.StartupBehavior =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.enums.StartupBehavior):
            StartupBehavior = StartupBehavior.values().first { it.javaValue == javaType }
    }
}
