@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.AgentUpdatePropertiesArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SessionHostComponentUpdateType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The session host configuration for updating agent, monitoring agent, and stack component.
 * @property maintenanceWindowTimeZone Time zone for maintenance as defined in https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0. Must be set if useLocalTime is true.
 * @property maintenanceWindows List of maintenance windows. Maintenance windows are 2 hours long.
 * @property type The type of maintenance for session host components.
 * @property useSessionHostLocalTime Whether to use localTime of the virtual machine.
 */
public data class AgentUpdatePropertiesArgs(
    public val maintenanceWindowTimeZone: Output<String>? = null,
    public val maintenanceWindows: Output<List<MaintenanceWindowPropertiesArgs>>? = null,
    public val type: Output<Either<String, SessionHostComponentUpdateType>>? = null,
    public val useSessionHostLocalTime: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.AgentUpdatePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.AgentUpdatePropertiesArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.AgentUpdatePropertiesArgs.builder()
            .maintenanceWindowTimeZone(maintenanceWindowTimeZone?.applyValue({ args0 -> args0 }))
            .maintenanceWindows(
                maintenanceWindows?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .useSessionHostLocalTime(useSessionHostLocalTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentUpdatePropertiesArgs].
 */
@PulumiTagMarker
public class AgentUpdatePropertiesArgsBuilder internal constructor() {
    private var maintenanceWindowTimeZone: Output<String>? = null

    private var maintenanceWindows: Output<List<MaintenanceWindowPropertiesArgs>>? = null

    private var type: Output<Either<String, SessionHostComponentUpdateType>>? = null

    private var useSessionHostLocalTime: Output<Boolean>? = null

    /**
     * @param value Time zone for maintenance as defined in https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0. Must be set if useLocalTime is true.
     */
    @JvmName("ysqfnfcqlhjsfjtt")
    public suspend fun maintenanceWindowTimeZone(`value`: Output<String>) {
        this.maintenanceWindowTimeZone = value
    }

    /**
     * @param value List of maintenance windows. Maintenance windows are 2 hours long.
     */
    @JvmName("iffitjrtgxyatlyg")
    public suspend fun maintenanceWindows(`value`: Output<List<MaintenanceWindowPropertiesArgs>>) {
        this.maintenanceWindows = value
    }

    @JvmName("akmflgudaxougmcc")
    public suspend fun maintenanceWindows(vararg values: Output<MaintenanceWindowPropertiesArgs>) {
        this.maintenanceWindows = Output.all(values.asList())
    }

    /**
     * @param values List of maintenance windows. Maintenance windows are 2 hours long.
     */
    @JvmName("xaupyfppjcoohmyl")
    public suspend fun maintenanceWindows(values: List<Output<MaintenanceWindowPropertiesArgs>>) {
        this.maintenanceWindows = Output.all(values)
    }

    /**
     * @param value The type of maintenance for session host components.
     */
    @JvmName("itjveblcnydwcrfy")
    public suspend fun type(`value`: Output<Either<String, SessionHostComponentUpdateType>>) {
        this.type = value
    }

    /**
     * @param value Whether to use localTime of the virtual machine.
     */
    @JvmName("ynahqaovmydqubjq")
    public suspend fun useSessionHostLocalTime(`value`: Output<Boolean>) {
        this.useSessionHostLocalTime = value
    }

    /**
     * @param value Time zone for maintenance as defined in https://docs.microsoft.com/en-us/dotnet/api/system.timezoneinfo.findsystemtimezonebyid?view=net-5.0. Must be set if useLocalTime is true.
     */
    @JvmName("cmcexjushpmoxfix")
    public suspend fun maintenanceWindowTimeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindowTimeZone = mapped
    }

    /**
     * @param value List of maintenance windows. Maintenance windows are 2 hours long.
     */
    @JvmName("tocyqalpgdxwnpav")
    public suspend fun maintenanceWindows(`value`: List<MaintenanceWindowPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindows = mapped
    }

    /**
     * @param argument List of maintenance windows. Maintenance windows are 2 hours long.
     */
    @JvmName("bvrhwfxehucvdcnu")
    public suspend
    fun maintenanceWindows(argument: List<suspend MaintenanceWindowPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.maintenanceWindows = mapped
    }

    /**
     * @param argument List of maintenance windows. Maintenance windows are 2 hours long.
     */
    @JvmName("yilaxuiakjsyjbgb")
    public suspend fun maintenanceWindows(
        vararg
        argument: suspend MaintenanceWindowPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MaintenanceWindowPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.maintenanceWindows = mapped
    }

    /**
     * @param argument List of maintenance windows. Maintenance windows are 2 hours long.
     */
    @JvmName("sdjphhkmhpqdcwtm")
    public suspend
    fun maintenanceWindows(argument: suspend MaintenanceWindowPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MaintenanceWindowPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.maintenanceWindows = mapped
    }

    /**
     * @param values List of maintenance windows. Maintenance windows are 2 hours long.
     */
    @JvmName("rxooykgwtatomtij")
    public suspend fun maintenanceWindows(vararg values: MaintenanceWindowPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceWindows = mapped
    }

    /**
     * @param value The type of maintenance for session host components.
     */
    @JvmName("oqltfowjyfdyvjyn")
    public suspend fun type(`value`: Either<String, SessionHostComponentUpdateType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of maintenance for session host components.
     */
    @JvmName("yusifabcoccvnmpi")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostComponentUpdateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of maintenance for session host components.
     */
    @JvmName("qcogfuwndrtpttwd")
    public fun type(`value`: SessionHostComponentUpdateType) {
        val toBeMapped = Either.ofRight<String, SessionHostComponentUpdateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Whether to use localTime of the virtual machine.
     */
    @JvmName("jcpgtblnvmwkjjhs")
    public suspend fun useSessionHostLocalTime(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSessionHostLocalTime = mapped
    }

    internal fun build(): AgentUpdatePropertiesArgs = AgentUpdatePropertiesArgs(
        maintenanceWindowTimeZone = maintenanceWindowTimeZone,
        maintenanceWindows = maintenanceWindows,
        type = type,
        useSessionHostLocalTime = useSessionHostLocalTime,
    )
}
