@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackageInfoPropertiesArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.PackageTimestamped
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Schema for Import Package Information properties.
 * @property certificateExpiry Date certificate expires, found in the appxmanifest.xml.
 * @property certificateName Certificate name found in the appxmanifest.xml.
 * @property displayName User friendly Name to be displayed in the portal.
 * @property imagePath VHD/CIM image path on Network Share.
 * @property isActive Make this version of the package the active one across the hostpool.
 * @property isPackageTimestamped Is package timestamped so it can ignore the certificate expiry date
 * @property isRegularRegistration Specifies how to register Package in feed.
 * @property lastUpdated Date Package was last updated, found in the appxmanifest.xml.
 * @property packageAlias Alias of App Attach Package. Assigned at import time
 * @property packageApplications List of package applications.
 * @property packageDependencies List of package dependencies.
 * @property packageFamilyName Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
 * @property packageFullName Package Full Name from appxmanifest.xml.
 * @property packageName Package Name from appxmanifest.xml.
 * @property packageRelativePath Relative Path to the package inside the image.
 * @property version Package Version found in the appxmanifest.xml.
 */
public data class AppAttachPackageInfoPropertiesArgs(
    public val certificateExpiry: Output<String>? = null,
    public val certificateName: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val imagePath: Output<String>? = null,
    public val isActive: Output<Boolean>? = null,
    public val isPackageTimestamped: Output<Either<String, PackageTimestamped>>? = null,
    public val isRegularRegistration: Output<Boolean>? = null,
    public val lastUpdated: Output<String>? = null,
    public val packageAlias: Output<String>? = null,
    public val packageApplications: Output<List<MsixPackageApplicationsArgs>>? = null,
    public val packageDependencies: Output<List<MsixPackageDependenciesArgs>>? = null,
    public val packageFamilyName: Output<String>? = null,
    public val packageFullName: Output<String>? = null,
    public val packageName: Output<String>? = null,
    public val packageRelativePath: Output<String>? = null,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackageInfoPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackageInfoPropertiesArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.AppAttachPackageInfoPropertiesArgs.builder()
            .certificateExpiry(certificateExpiry?.applyValue({ args0 -> args0 }))
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .imagePath(imagePath?.applyValue({ args0 -> args0 }))
            .isActive(isActive?.applyValue({ args0 -> args0 }))
            .isPackageTimestamped(
                isPackageTimestamped?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .isRegularRegistration(isRegularRegistration?.applyValue({ args0 -> args0 }))
            .lastUpdated(lastUpdated?.applyValue({ args0 -> args0 }))
            .packageAlias(packageAlias?.applyValue({ args0 -> args0 }))
            .packageApplications(
                packageApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .packageDependencies(
                packageDependencies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .packageFamilyName(packageFamilyName?.applyValue({ args0 -> args0 }))
            .packageFullName(packageFullName?.applyValue({ args0 -> args0 }))
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .packageRelativePath(packageRelativePath?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppAttachPackageInfoPropertiesArgs].
 */
@PulumiTagMarker
public class AppAttachPackageInfoPropertiesArgsBuilder internal constructor() {
    private var certificateExpiry: Output<String>? = null

    private var certificateName: Output<String>? = null

    private var displayName: Output<String>? = null

    private var imagePath: Output<String>? = null

    private var isActive: Output<Boolean>? = null

    private var isPackageTimestamped: Output<Either<String, PackageTimestamped>>? = null

    private var isRegularRegistration: Output<Boolean>? = null

    private var lastUpdated: Output<String>? = null

    private var packageAlias: Output<String>? = null

    private var packageApplications: Output<List<MsixPackageApplicationsArgs>>? = null

    private var packageDependencies: Output<List<MsixPackageDependenciesArgs>>? = null

    private var packageFamilyName: Output<String>? = null

    private var packageFullName: Output<String>? = null

    private var packageName: Output<String>? = null

    private var packageRelativePath: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Date certificate expires, found in the appxmanifest.xml.
     */
    @JvmName("dgmyoktnghyibrld")
    public suspend fun certificateExpiry(`value`: Output<String>) {
        this.certificateExpiry = value
    }

    /**
     * @param value Certificate name found in the appxmanifest.xml.
     */
    @JvmName("ghxvmrxhuvyfxdga")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value User friendly Name to be displayed in the portal.
     */
    @JvmName("reekcrgegcvskxus")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value VHD/CIM image path on Network Share.
     */
    @JvmName("rljluvsgriycatck")
    public suspend fun imagePath(`value`: Output<String>) {
        this.imagePath = value
    }

    /**
     * @param value Make this version of the package the active one across the hostpool.
     */
    @JvmName("mkujovyixnedxtds")
    public suspend fun isActive(`value`: Output<Boolean>) {
        this.isActive = value
    }

    /**
     * @param value Is package timestamped so it can ignore the certificate expiry date
     */
    @JvmName("gpkuewanfgjeswln")
    public suspend fun isPackageTimestamped(`value`: Output<Either<String, PackageTimestamped>>) {
        this.isPackageTimestamped = value
    }

    /**
     * @param value Specifies how to register Package in feed.
     */
    @JvmName("ladldsjctkymyhvj")
    public suspend fun isRegularRegistration(`value`: Output<Boolean>) {
        this.isRegularRegistration = value
    }

    /**
     * @param value Date Package was last updated, found in the appxmanifest.xml.
     */
    @JvmName("ohnanhrqqjbatjpf")
    public suspend fun lastUpdated(`value`: Output<String>) {
        this.lastUpdated = value
    }

    /**
     * @param value Alias of App Attach Package. Assigned at import time
     */
    @JvmName("lwlhddahahtjdvao")
    public suspend fun packageAlias(`value`: Output<String>) {
        this.packageAlias = value
    }

    /**
     * @param value List of package applications.
     */
    @JvmName("yvboljmtpxfalqiq")
    public suspend fun packageApplications(`value`: Output<List<MsixPackageApplicationsArgs>>) {
        this.packageApplications = value
    }

    @JvmName("yommolijyhjxduqf")
    public suspend fun packageApplications(vararg values: Output<MsixPackageApplicationsArgs>) {
        this.packageApplications = Output.all(values.asList())
    }

    /**
     * @param values List of package applications.
     */
    @JvmName("msvglljgdsjmmymw")
    public suspend fun packageApplications(values: List<Output<MsixPackageApplicationsArgs>>) {
        this.packageApplications = Output.all(values)
    }

    /**
     * @param value List of package dependencies.
     */
    @JvmName("woqfxvyyqhbuihix")
    public suspend fun packageDependencies(`value`: Output<List<MsixPackageDependenciesArgs>>) {
        this.packageDependencies = value
    }

    @JvmName("fnynqshfuvjdigse")
    public suspend fun packageDependencies(vararg values: Output<MsixPackageDependenciesArgs>) {
        this.packageDependencies = Output.all(values.asList())
    }

    /**
     * @param values List of package dependencies.
     */
    @JvmName("vojhsoadfdypljke")
    public suspend fun packageDependencies(values: List<Output<MsixPackageDependenciesArgs>>) {
        this.packageDependencies = Output.all(values)
    }

    /**
     * @param value Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
     */
    @JvmName("qbsisaicmsipjoom")
    public suspend fun packageFamilyName(`value`: Output<String>) {
        this.packageFamilyName = value
    }

    /**
     * @param value Package Full Name from appxmanifest.xml.
     */
    @JvmName("httqcuyvdbumdknw")
    public suspend fun packageFullName(`value`: Output<String>) {
        this.packageFullName = value
    }

    /**
     * @param value Package Name from appxmanifest.xml.
     */
    @JvmName("vkfoxvlhpimjmpoj")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Relative Path to the package inside the image.
     */
    @JvmName("irfoqxrmxbwmussy")
    public suspend fun packageRelativePath(`value`: Output<String>) {
        this.packageRelativePath = value
    }

    /**
     * @param value Package Version found in the appxmanifest.xml.
     */
    @JvmName("vxoggojwhjheqbxo")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Date certificate expires, found in the appxmanifest.xml.
     */
    @JvmName("mpajiitvytrisytl")
    public suspend fun certificateExpiry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateExpiry = mapped
    }

    /**
     * @param value Certificate name found in the appxmanifest.xml.
     */
    @JvmName("tnewraqqrtabktvr")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value User friendly Name to be displayed in the portal.
     */
    @JvmName("qxprujtejggytcyd")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value VHD/CIM image path on Network Share.
     */
    @JvmName("kcwhrdcfybypvtuk")
    public suspend fun imagePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePath = mapped
    }

    /**
     * @param value Make this version of the package the active one across the hostpool.
     */
    @JvmName("ihxatgjeteulwmve")
    public suspend fun isActive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isActive = mapped
    }

    /**
     * @param value Is package timestamped so it can ignore the certificate expiry date
     */
    @JvmName("lvrgwejpacrxgxsc")
    public suspend fun isPackageTimestamped(`value`: Either<String, PackageTimestamped>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPackageTimestamped = mapped
    }

    /**
     * @param value Is package timestamped so it can ignore the certificate expiry date
     */
    @JvmName("arcvetrjylcnjoif")
    public fun isPackageTimestamped(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PackageTimestamped>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isPackageTimestamped = mapped
    }

    /**
     * @param value Is package timestamped so it can ignore the certificate expiry date
     */
    @JvmName("fiindtrkqppqseex")
    public fun isPackageTimestamped(`value`: PackageTimestamped) {
        val toBeMapped = Either.ofRight<String, PackageTimestamped>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isPackageTimestamped = mapped
    }

    /**
     * @param value Specifies how to register Package in feed.
     */
    @JvmName("batiucygvixygrun")
    public suspend fun isRegularRegistration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRegularRegistration = mapped
    }

    /**
     * @param value Date Package was last updated, found in the appxmanifest.xml.
     */
    @JvmName("qalupgwhphejouol")
    public suspend fun lastUpdated(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdated = mapped
    }

    /**
     * @param value Alias of App Attach Package. Assigned at import time
     */
    @JvmName("ltnyxesuowunfbqj")
    public suspend fun packageAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageAlias = mapped
    }

    /**
     * @param value List of package applications.
     */
    @JvmName("gsynwdfotjbbenjv")
    public suspend fun packageApplications(`value`: List<MsixPackageApplicationsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageApplications = mapped
    }

    /**
     * @param argument List of package applications.
     */
    @JvmName("ymfdxvtiseoemxko")
    public suspend
    fun packageApplications(argument: List<suspend MsixPackageApplicationsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MsixPackageApplicationsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.packageApplications = mapped
    }

    /**
     * @param argument List of package applications.
     */
    @JvmName("sotmbldmcsyatyxy")
    public suspend fun packageApplications(
        vararg
        argument: suspend MsixPackageApplicationsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MsixPackageApplicationsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.packageApplications = mapped
    }

    /**
     * @param argument List of package applications.
     */
    @JvmName("lefvnqhlwkeeucxl")
    public suspend
    fun packageApplications(argument: suspend MsixPackageApplicationsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MsixPackageApplicationsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.packageApplications = mapped
    }

    /**
     * @param values List of package applications.
     */
    @JvmName("wjbswnlfgsgixsng")
    public suspend fun packageApplications(vararg values: MsixPackageApplicationsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageApplications = mapped
    }

    /**
     * @param value List of package dependencies.
     */
    @JvmName("jcriwracdkuiyjje")
    public suspend fun packageDependencies(`value`: List<MsixPackageDependenciesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageDependencies = mapped
    }

    /**
     * @param argument List of package dependencies.
     */
    @JvmName("mcruaquasbidoqmh")
    public suspend
    fun packageDependencies(argument: List<suspend MsixPackageDependenciesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MsixPackageDependenciesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.packageDependencies = mapped
    }

    /**
     * @param argument List of package dependencies.
     */
    @JvmName("hflpudlfovviuryh")
    public suspend fun packageDependencies(
        vararg
        argument: suspend MsixPackageDependenciesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MsixPackageDependenciesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.packageDependencies = mapped
    }

    /**
     * @param argument List of package dependencies.
     */
    @JvmName("tuktcixkdpkdmnop")
    public suspend
    fun packageDependencies(argument: suspend MsixPackageDependenciesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MsixPackageDependenciesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.packageDependencies = mapped
    }

    /**
     * @param values List of package dependencies.
     */
    @JvmName("coipejjcqmqsuyvu")
    public suspend fun packageDependencies(vararg values: MsixPackageDependenciesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageDependencies = mapped
    }

    /**
     * @param value Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
     */
    @JvmName("evxwujajjfrgogsh")
    public suspend fun packageFamilyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageFamilyName = mapped
    }

    /**
     * @param value Package Full Name from appxmanifest.xml.
     */
    @JvmName("xcihpjmhdixqerok")
    public suspend fun packageFullName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageFullName = mapped
    }

    /**
     * @param value Package Name from appxmanifest.xml.
     */
    @JvmName("iuxdsnwiqlbayate")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Relative Path to the package inside the image.
     */
    @JvmName("jvhkehkobntbuslg")
    public suspend fun packageRelativePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageRelativePath = mapped
    }

    /**
     * @param value Package Version found in the appxmanifest.xml.
     */
    @JvmName("awgkyetbgompkkjk")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): AppAttachPackageInfoPropertiesArgs = AppAttachPackageInfoPropertiesArgs(
        certificateExpiry = certificateExpiry,
        certificateName = certificateName,
        displayName = displayName,
        imagePath = imagePath,
        isActive = isActive,
        isPackageTimestamped = isPackageTimestamped,
        isRegularRegistration = isRegularRegistration,
        lastUpdated = lastUpdated,
        packageAlias = packageAlias,
        packageApplications = packageApplications,
        packageDependencies = packageDependencies,
        packageFamilyName = packageFamilyName,
        packageFullName = packageFullName,
        packageName = packageName,
        packageRelativePath = packageRelativePath,
        version = version,
    )
}
