@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.GetMSIXPackagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostPoolName The name of the host pool within the specified resource group
 * @property msixPackageFullName The version specific package full name of the MSIX package within specified hostpool
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMSIXPackagePlainArgs(
    public val hostPoolName: String,
    public val msixPackageFullName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.GetMSIXPackagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.GetMSIXPackagePlainArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.GetMSIXPackagePlainArgs.builder()
            .hostPoolName(hostPoolName.let({ args0 -> args0 }))
            .msixPackageFullName(msixPackageFullName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMSIXPackagePlainArgs].
 */
@PulumiTagMarker
public class GetMSIXPackagePlainArgsBuilder internal constructor() {
    private var hostPoolName: String? = null

    private var msixPackageFullName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the host pool within the specified resource group
     */
    @JvmName("tswkuhmylhgdkhra")
    public suspend fun hostPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostPoolName = mapped
    }

    /**
     * @param value The version specific package full name of the MSIX package within specified hostpool
     */
    @JvmName("yjlalhmyrsbgwgaj")
    public suspend fun msixPackageFullName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.msixPackageFullName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qwpoxchntdcfhavw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMSIXPackagePlainArgs = GetMSIXPackagePlainArgs(
        hostPoolName = hostPoolName ?: throw PulumiNullFieldException("hostPoolName"),
        msixPackageFullName = msixPackageFullName ?: throw PulumiNullFieldException("msixPackageFullName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
