@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetSkuArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SkuTier
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capacity If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here.
 * @property name The name of the SKU. Ex - P3. It is typically a letter+number code
 * @property size The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
 * @property tier This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
 */
public data class ResourceModelWithAllowedPropertySetSkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>,
    public val size: Output<String>? = null,
    public val tier: Output<SkuTier>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetSkuArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetSkuArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceModelWithAllowedPropertySetSkuArgs].
 */
@PulumiTagMarker
public class ResourceModelWithAllowedPropertySetSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var tier: Output<SkuTier>? = null

    /**
     * @param value If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
     */
    @JvmName("mgghpbwtcfmojlbh")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JvmName("dyrbarujcvbcauwr")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the SKU. Ex - P3. It is typically a letter+number code
     */
    @JvmName("pjipswpfmvvlwhny")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
     */
    @JvmName("lltuyhvcqdfyebgl")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
     */
    @JvmName("vrcmjtaqbqgdcirk")
    public suspend fun tier(`value`: Output<SkuTier>) {
        this.tier = value
    }

    /**
     * @param value If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
     */
    @JvmName("lednomsqvasrrmba")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value If the service has different generations of hardware, for the same SKU, then that can be captured here.
     */
    @JvmName("twgxcgekivfnjlge")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the SKU. Ex - P3. It is typically a letter+number code
     */
    @JvmName("fqglkfeluodjmcvw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
     */
    @JvmName("osfffjtkonnmwxpd")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
     */
    @JvmName("fxtuakaqvndwwjrn")
    public suspend fun tier(`value`: SkuTier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): ResourceModelWithAllowedPropertySetSkuArgs =
        ResourceModelWithAllowedPropertySetSkuArgs(
            capacity = capacity,
            family = family,
            name = name ?: throw PulumiNullFieldException("name"),
            size = size,
            tier = tier,
        )
}
