@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.ScalingScheduleArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SessionHostLoadBalancingAlgorithm
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.StopHostsWhen
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A ScalingPlanPooledSchedule.
 * @property daysOfWeek Set of days of the week on which this schedule is active.
 * @property name Name of the ScalingPlanPooledSchedule.
 * @property offPeakLoadBalancingAlgorithm Load balancing algorithm for off-peak period.
 * @property offPeakStartTime Starting time for off-peak period.
 * @property peakLoadBalancingAlgorithm Load balancing algorithm for peak period.
 * @property peakStartTime Starting time for peak period.
 * @property rampDownCapacityThresholdPct Capacity threshold for ramp down period.
 * @property rampDownForceLogoffUsers Should users be logged off forcefully from hosts.
 * @property rampDownLoadBalancingAlgorithm Load balancing algorithm for ramp down period.
 * @property rampDownMinimumHostsPct Minimum host percentage for ramp down period.
 * @property rampDownNotificationMessage Notification message for users during ramp down period.
 * @property rampDownStartTime Starting time for ramp down period.
 * @property rampDownStopHostsWhen Specifies when to stop hosts during ramp down period.
 * @property rampDownWaitTimeMinutes Number of minutes to wait to stop hosts during ramp down period.
 * @property rampUpCapacityThresholdPct Capacity threshold for ramp up period.
 * @property rampUpLoadBalancingAlgorithm Load balancing algorithm for ramp up period.
 * @property rampUpMinimumHostsPct Minimum host percentage for ramp up period.
 * @property rampUpStartTime Starting time for ramp up period.
 */
public data class ScalingScheduleArgs(
    public val daysOfWeek: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val offPeakLoadBalancingAlgorithm:
    Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null,
    public val offPeakStartTime: Output<TimeArgs>? = null,
    public val peakLoadBalancingAlgorithm: Output<Either<String, SessionHostLoadBalancingAlgorithm>>? =
        null,
    public val peakStartTime: Output<TimeArgs>? = null,
    public val rampDownCapacityThresholdPct: Output<Int>? = null,
    public val rampDownForceLogoffUsers: Output<Boolean>? = null,
    public val rampDownLoadBalancingAlgorithm:
    Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null,
    public val rampDownMinimumHostsPct: Output<Int>? = null,
    public val rampDownNotificationMessage: Output<String>? = null,
    public val rampDownStartTime: Output<TimeArgs>? = null,
    public val rampDownStopHostsWhen: Output<Either<String, StopHostsWhen>>? = null,
    public val rampDownWaitTimeMinutes: Output<Int>? = null,
    public val rampUpCapacityThresholdPct: Output<Int>? = null,
    public val rampUpLoadBalancingAlgorithm:
    Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null,
    public val rampUpMinimumHostsPct: Output<Int>? = null,
    public val rampUpStartTime: Output<TimeArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.ScalingScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.inputs.ScalingScheduleArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.ScalingScheduleArgs.builder()
            .daysOfWeek(daysOfWeek?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .offPeakLoadBalancingAlgorithm(
                offPeakLoadBalancingAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .offPeakStartTime(offPeakStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .peakLoadBalancingAlgorithm(
                peakLoadBalancingAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .peakStartTime(peakStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rampDownCapacityThresholdPct(rampDownCapacityThresholdPct?.applyValue({ args0 -> args0 }))
            .rampDownForceLogoffUsers(rampDownForceLogoffUsers?.applyValue({ args0 -> args0 }))
            .rampDownLoadBalancingAlgorithm(
                rampDownLoadBalancingAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampDownMinimumHostsPct(rampDownMinimumHostsPct?.applyValue({ args0 -> args0 }))
            .rampDownNotificationMessage(rampDownNotificationMessage?.applyValue({ args0 -> args0 }))
            .rampDownStartTime(rampDownStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rampDownStopHostsWhen(
                rampDownStopHostsWhen?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampDownWaitTimeMinutes(rampDownWaitTimeMinutes?.applyValue({ args0 -> args0 }))
            .rampUpCapacityThresholdPct(rampUpCapacityThresholdPct?.applyValue({ args0 -> args0 }))
            .rampUpLoadBalancingAlgorithm(
                rampUpLoadBalancingAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampUpMinimumHostsPct(rampUpMinimumHostsPct?.applyValue({ args0 -> args0 }))
            .rampUpStartTime(
                rampUpStartTime?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ScalingScheduleArgs].
 */
@PulumiTagMarker
public class ScalingScheduleArgsBuilder internal constructor() {
    private var daysOfWeek: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var offPeakLoadBalancingAlgorithm:
        Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null

    private var offPeakStartTime: Output<TimeArgs>? = null

    private var peakLoadBalancingAlgorithm: Output<Either<String, SessionHostLoadBalancingAlgorithm>>? =
        null

    private var peakStartTime: Output<TimeArgs>? = null

    private var rampDownCapacityThresholdPct: Output<Int>? = null

    private var rampDownForceLogoffUsers: Output<Boolean>? = null

    private var rampDownLoadBalancingAlgorithm:
        Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null

    private var rampDownMinimumHostsPct: Output<Int>? = null

    private var rampDownNotificationMessage: Output<String>? = null

    private var rampDownStartTime: Output<TimeArgs>? = null

    private var rampDownStopHostsWhen: Output<Either<String, StopHostsWhen>>? = null

    private var rampDownWaitTimeMinutes: Output<Int>? = null

    private var rampUpCapacityThresholdPct: Output<Int>? = null

    private var rampUpLoadBalancingAlgorithm:
        Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null

    private var rampUpMinimumHostsPct: Output<Int>? = null

    private var rampUpStartTime: Output<TimeArgs>? = null

    /**
     * @param value Set of days of the week on which this schedule is active.
     */
    @JvmName("eqdxuqgbfrowfjts")
    public suspend fun daysOfWeek(`value`: Output<List<String>>) {
        this.daysOfWeek = value
    }

    @JvmName("skkxbfldexvuvkdm")
    public suspend fun daysOfWeek(vararg values: Output<String>) {
        this.daysOfWeek = Output.all(values.asList())
    }

    /**
     * @param values Set of days of the week on which this schedule is active.
     */
    @JvmName("jkdjaqmmjxkpcxvy")
    public suspend fun daysOfWeek(values: List<Output<String>>) {
        this.daysOfWeek = Output.all(values)
    }

    /**
     * @param value Name of the ScalingPlanPooledSchedule.
     */
    @JvmName("yyqukcbpudnneyoc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Load balancing algorithm for off-peak period.
     */
    @JvmName("ooxixvrtuligdgbj")
    public suspend
    fun offPeakLoadBalancingAlgorithm(`value`: Output<Either<String, SessionHostLoadBalancingAlgorithm>>) {
        this.offPeakLoadBalancingAlgorithm = value
    }

    /**
     * @param value Starting time for off-peak period.
     */
    @JvmName("jawihbneaovrjwsv")
    public suspend fun offPeakStartTime(`value`: Output<TimeArgs>) {
        this.offPeakStartTime = value
    }

    /**
     * @param value Load balancing algorithm for peak period.
     */
    @JvmName("igqmigbfyflfhrkn")
    public suspend
    fun peakLoadBalancingAlgorithm(`value`: Output<Either<String, SessionHostLoadBalancingAlgorithm>>) {
        this.peakLoadBalancingAlgorithm = value
    }

    /**
     * @param value Starting time for peak period.
     */
    @JvmName("sdcphrmaxsuhcljj")
    public suspend fun peakStartTime(`value`: Output<TimeArgs>) {
        this.peakStartTime = value
    }

    /**
     * @param value Capacity threshold for ramp down period.
     */
    @JvmName("xnktqavcbeffgxoe")
    public suspend fun rampDownCapacityThresholdPct(`value`: Output<Int>) {
        this.rampDownCapacityThresholdPct = value
    }

    /**
     * @param value Should users be logged off forcefully from hosts.
     */
    @JvmName("ekycalyeafaxjdsi")
    public suspend fun rampDownForceLogoffUsers(`value`: Output<Boolean>) {
        this.rampDownForceLogoffUsers = value
    }

    /**
     * @param value Load balancing algorithm for ramp down period.
     */
    @JvmName("hyestpdiccpileey")
    public suspend
    fun rampDownLoadBalancingAlgorithm(`value`: Output<Either<String, SessionHostLoadBalancingAlgorithm>>) {
        this.rampDownLoadBalancingAlgorithm = value
    }

    /**
     * @param value Minimum host percentage for ramp down period.
     */
    @JvmName("txkdykjfaregijhv")
    public suspend fun rampDownMinimumHostsPct(`value`: Output<Int>) {
        this.rampDownMinimumHostsPct = value
    }

    /**
     * @param value Notification message for users during ramp down period.
     */
    @JvmName("dmidnbfqkktskgiq")
    public suspend fun rampDownNotificationMessage(`value`: Output<String>) {
        this.rampDownNotificationMessage = value
    }

    /**
     * @param value Starting time for ramp down period.
     */
    @JvmName("fgmdrqelximqbnxh")
    public suspend fun rampDownStartTime(`value`: Output<TimeArgs>) {
        this.rampDownStartTime = value
    }

    /**
     * @param value Specifies when to stop hosts during ramp down period.
     */
    @JvmName("jrlitwbtcofcwipg")
    public suspend fun rampDownStopHostsWhen(`value`: Output<Either<String, StopHostsWhen>>) {
        this.rampDownStopHostsWhen = value
    }

    /**
     * @param value Number of minutes to wait to stop hosts during ramp down period.
     */
    @JvmName("xvvkyvsjctclgsds")
    public suspend fun rampDownWaitTimeMinutes(`value`: Output<Int>) {
        this.rampDownWaitTimeMinutes = value
    }

    /**
     * @param value Capacity threshold for ramp up period.
     */
    @JvmName("ohetsxlieghxtxih")
    public suspend fun rampUpCapacityThresholdPct(`value`: Output<Int>) {
        this.rampUpCapacityThresholdPct = value
    }

    /**
     * @param value Load balancing algorithm for ramp up period.
     */
    @JvmName("gumuowspymgapiic")
    public suspend
    fun rampUpLoadBalancingAlgorithm(`value`: Output<Either<String, SessionHostLoadBalancingAlgorithm>>) {
        this.rampUpLoadBalancingAlgorithm = value
    }

    /**
     * @param value Minimum host percentage for ramp up period.
     */
    @JvmName("dekdhbwuieqvvhgl")
    public suspend fun rampUpMinimumHostsPct(`value`: Output<Int>) {
        this.rampUpMinimumHostsPct = value
    }

    /**
     * @param value Starting time for ramp up period.
     */
    @JvmName("yyinifebtvecthjr")
    public suspend fun rampUpStartTime(`value`: Output<TimeArgs>) {
        this.rampUpStartTime = value
    }

    /**
     * @param value Set of days of the week on which this schedule is active.
     */
    @JvmName("magavbpxvwjlusfx")
    public suspend fun daysOfWeek(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param values Set of days of the week on which this schedule is active.
     */
    @JvmName("xncedyxskaicwntd")
    public suspend fun daysOfWeek(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param value Name of the ScalingPlanPooledSchedule.
     */
    @JvmName("ynwvpbvplmxmcubq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Load balancing algorithm for off-peak period.
     */
    @JvmName("gntwrmiyfqevousa")
    public suspend
    fun offPeakLoadBalancingAlgorithm(`value`: Either<String, SessionHostLoadBalancingAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for off-peak period.
     */
    @JvmName("ycqnilnnrqjvspmo")
    public fun offPeakLoadBalancingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for off-peak period.
     */
    @JvmName("rvsruitssfgvmxbp")
    public fun offPeakLoadBalancingAlgorithm(`value`: SessionHostLoadBalancingAlgorithm) {
        val toBeMapped = Either.ofRight<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Starting time for off-peak period.
     */
    @JvmName("gxbbekpvidqoubup")
    public suspend fun offPeakStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakStartTime = mapped
    }

    /**
     * @param argument Starting time for off-peak period.
     */
    @JvmName("wexaommqcuqgnlbo")
    public suspend fun offPeakStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.offPeakStartTime = mapped
    }

    /**
     * @param value Load balancing algorithm for peak period.
     */
    @JvmName("lmhbbopqowgewqvi")
    public suspend
    fun peakLoadBalancingAlgorithm(`value`: Either<String, SessionHostLoadBalancingAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for peak period.
     */
    @JvmName("hewhtctoubqyrqse")
    public fun peakLoadBalancingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for peak period.
     */
    @JvmName("tfgpfjudbpchryav")
    public fun peakLoadBalancingAlgorithm(`value`: SessionHostLoadBalancingAlgorithm) {
        val toBeMapped = Either.ofRight<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Starting time for peak period.
     */
    @JvmName("ntivhfiaemublrxg")
    public suspend fun peakStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakStartTime = mapped
    }

    /**
     * @param argument Starting time for peak period.
     */
    @JvmName("dgnkwscpanbugqke")
    public suspend fun peakStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peakStartTime = mapped
    }

    /**
     * @param value Capacity threshold for ramp down period.
     */
    @JvmName("ggpltdnuotmnyqbx")
    public suspend fun rampDownCapacityThresholdPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownCapacityThresholdPct = mapped
    }

    /**
     * @param value Should users be logged off forcefully from hosts.
     */
    @JvmName("ftggdqjkyhwbpnpn")
    public suspend fun rampDownForceLogoffUsers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownForceLogoffUsers = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp down period.
     */
    @JvmName("ndyyvvcpwfevlyqd")
    public suspend
    fun rampDownLoadBalancingAlgorithm(`value`: Either<String, SessionHostLoadBalancingAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp down period.
     */
    @JvmName("ukxgjinbsojyrevj")
    public fun rampDownLoadBalancingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp down period.
     */
    @JvmName("dcbhmuhfpddecoky")
    public fun rampDownLoadBalancingAlgorithm(`value`: SessionHostLoadBalancingAlgorithm) {
        val toBeMapped = Either.ofRight<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Minimum host percentage for ramp down period.
     */
    @JvmName("askgfbbyfkxcwrje")
    public suspend fun rampDownMinimumHostsPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownMinimumHostsPct = mapped
    }

    /**
     * @param value Notification message for users during ramp down period.
     */
    @JvmName("rubtftaenwyeypwe")
    public suspend fun rampDownNotificationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownNotificationMessage = mapped
    }

    /**
     * @param value Starting time for ramp down period.
     */
    @JvmName("erchkycnudphmgdu")
    public suspend fun rampDownStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownStartTime = mapped
    }

    /**
     * @param argument Starting time for ramp down period.
     */
    @JvmName("bwduikkaofdfbqry")
    public suspend fun rampDownStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rampDownStartTime = mapped
    }

    /**
     * @param value Specifies when to stop hosts during ramp down period.
     */
    @JvmName("geuesvtpbwnoekna")
    public suspend fun rampDownStopHostsWhen(`value`: Either<String, StopHostsWhen>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownStopHostsWhen = mapped
    }

    /**
     * @param value Specifies when to stop hosts during ramp down period.
     */
    @JvmName("terxohyutbqfpxnj")
    public fun rampDownStopHostsWhen(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StopHostsWhen>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownStopHostsWhen = mapped
    }

    /**
     * @param value Specifies when to stop hosts during ramp down period.
     */
    @JvmName("gbqehxwxgkablnbf")
    public fun rampDownStopHostsWhen(`value`: StopHostsWhen) {
        val toBeMapped = Either.ofRight<String, StopHostsWhen>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownStopHostsWhen = mapped
    }

    /**
     * @param value Number of minutes to wait to stop hosts during ramp down period.
     */
    @JvmName("vfilxwjmgolxcryg")
    public suspend fun rampDownWaitTimeMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownWaitTimeMinutes = mapped
    }

    /**
     * @param value Capacity threshold for ramp up period.
     */
    @JvmName("mhrllajlysoeueev")
    public suspend fun rampUpCapacityThresholdPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpCapacityThresholdPct = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp up period.
     */
    @JvmName("bjbhjfcuitnqejxl")
    public suspend
    fun rampUpLoadBalancingAlgorithm(`value`: Either<String, SessionHostLoadBalancingAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp up period.
     */
    @JvmName("khjrhqqilwovdihl")
    public fun rampUpLoadBalancingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp up period.
     */
    @JvmName("bcpkeppkofwomexr")
    public fun rampUpLoadBalancingAlgorithm(`value`: SessionHostLoadBalancingAlgorithm) {
        val toBeMapped = Either.ofRight<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Minimum host percentage for ramp up period.
     */
    @JvmName("mhnlqtxipcldcabq")
    public suspend fun rampUpMinimumHostsPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpMinimumHostsPct = mapped
    }

    /**
     * @param value Starting time for ramp up period.
     */
    @JvmName("ncbmswnrfuhgjuny")
    public suspend fun rampUpStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpStartTime = mapped
    }

    /**
     * @param argument Starting time for ramp up period.
     */
    @JvmName("amsevcenxrxupkno")
    public suspend fun rampUpStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rampUpStartTime = mapped
    }

    internal fun build(): ScalingScheduleArgs = ScalingScheduleArgs(
        daysOfWeek = daysOfWeek,
        name = name,
        offPeakLoadBalancingAlgorithm = offPeakLoadBalancingAlgorithm,
        offPeakStartTime = offPeakStartTime,
        peakLoadBalancingAlgorithm = peakLoadBalancingAlgorithm,
        peakStartTime = peakStartTime,
        rampDownCapacityThresholdPct = rampDownCapacityThresholdPct,
        rampDownForceLogoffUsers = rampDownForceLogoffUsers,
        rampDownLoadBalancingAlgorithm = rampDownLoadBalancingAlgorithm,
        rampDownMinimumHostsPct = rampDownMinimumHostsPct,
        rampDownNotificationMessage = rampDownNotificationMessage,
        rampDownStartTime = rampDownStartTime,
        rampDownStopHostsWhen = rampDownStopHostsWhen,
        rampDownWaitTimeMinutes = rampDownWaitTimeMinutes,
        rampUpCapacityThresholdPct = rampUpCapacityThresholdPct,
        rampUpLoadBalancingAlgorithm = rampUpLoadBalancingAlgorithm,
        rampUpMinimumHostsPct = rampUpMinimumHostsPct,
        rampUpStartTime = rampUpStartTime,
    )
}
