@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Schema for Import Package Information properties.
 * @property certificateExpiry Date certificate expires, found in the appxmanifest.xml.
 * @property certificateName Certificate name found in the appxmanifest.xml.
 * @property displayName User friendly Name to be displayed in the portal.
 * @property imagePath VHD/CIM image path on Network Share.
 * @property isActive Make this version of the package the active one across the hostpool.
 * @property isPackageTimestamped Is package timestamped so it can ignore the certificate expiry date
 * @property isRegularRegistration Specifies how to register Package in feed.
 * @property lastUpdated Date Package was last updated, found in the appxmanifest.xml.
 * @property packageAlias Alias of App Attach Package. Assigned at import time
 * @property packageApplications List of package applications.
 * @property packageDependencies List of package dependencies.
 * @property packageFamilyName Package Family Name from appxmanifest.xml. Contains Package Name and Publisher name.
 * @property packageFullName Package Full Name from appxmanifest.xml.
 * @property packageName Package Name from appxmanifest.xml.
 * @property packageRelativePath Relative Path to the package inside the image.
 * @property version Package Version found in the appxmanifest.xml.
 */
public data class AppAttachPackageInfoPropertiesResponse(
    public val certificateExpiry: String? = null,
    public val certificateName: String? = null,
    public val displayName: String? = null,
    public val imagePath: String? = null,
    public val isActive: Boolean? = null,
    public val isPackageTimestamped: String? = null,
    public val isRegularRegistration: Boolean? = null,
    public val lastUpdated: String? = null,
    public val packageAlias: String? = null,
    public val packageApplications: List<MsixPackageApplicationsResponse>? = null,
    public val packageDependencies: List<MsixPackageDependenciesResponse>? = null,
    public val packageFamilyName: String? = null,
    public val packageFullName: String? = null,
    public val packageName: String? = null,
    public val packageRelativePath: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.AppAttachPackageInfoPropertiesResponse):
            AppAttachPackageInfoPropertiesResponse = AppAttachPackageInfoPropertiesResponse(
            certificateExpiry = javaType.certificateExpiry().map({ args0 -> args0 }).orElse(null),
            certificateName = javaType.certificateName().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            imagePath = javaType.imagePath().map({ args0 -> args0 }).orElse(null),
            isActive = javaType.isActive().map({ args0 -> args0 }).orElse(null),
            isPackageTimestamped = javaType.isPackageTimestamped().map({ args0 -> args0 }).orElse(null),
            isRegularRegistration = javaType.isRegularRegistration().map({ args0 -> args0 }).orElse(null),
            lastUpdated = javaType.lastUpdated().map({ args0 -> args0 }).orElse(null),
            packageAlias = javaType.packageAlias().map({ args0 -> args0 }).orElse(null),
            packageApplications = javaType.packageApplications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.MsixPackageApplicationsResponse.Companion.toKotlin(args0)
                })
            }),
            packageDependencies = javaType.packageDependencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.MsixPackageDependenciesResponse.Companion.toKotlin(args0)
                })
            }),
            packageFamilyName = javaType.packageFamilyName().map({ args0 -> args0 }).orElse(null),
            packageFullName = javaType.packageFullName().map({ args0 -> args0 }).orElse(null),
            packageName = javaType.packageName().map({ args0 -> args0 }).orElse(null),
            packageRelativePath = javaType.packageRelativePath().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
