@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.CatalogArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GitCatalogArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GitCatalogArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents a catalog.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Catalogs_CreateOrUpdateAdo
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var catalog = new AzureNative.DevCenter.Catalog("catalog", new()
 *     {
 *         AdoGit = new AzureNative.DevCenter.Inputs.GitCatalogArgs
 *         {
 *             Branch = "main",
 *             Path = "/templates",
 *             SecretIdentifier = "https://contosokv.vault.azure.net/secrets/CentralRepoPat",
 *             Uri = "https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso",
 *         },
 *         CatalogName = "CentralCatalog",
 *         DevCenterName = "Contoso",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewCatalog(ctx, "catalog", &devcenter.CatalogArgs{
 * 			AdoGit: &devcenter.GitCatalogArgs{
 * 				Branch:           pulumi.String("main"),
 * 				Path:             pulumi.String("/templates"),
 * 				SecretIdentifier: pulumi.String("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 * 				Uri:              pulumi.String("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso"),
 * 			},
 * 			CatalogName:       pulumi.String("CentralCatalog"),
 * 			DevCenterName:     pulumi.String("Contoso"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Catalog;
 * import com.pulumi.azurenative.devcenter.CatalogArgs;
 * import com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var catalog = new Catalog("catalog", CatalogArgs.builder()
 *             .adoGit(GitCatalogArgs.builder()
 *                 .branch("main")
 *                 .path("/templates")
 *                 .secretIdentifier("https://contosokv.vault.azure.net/secrets/CentralRepoPat")
 *                 .uri("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso")
 *                 .build())
 *             .catalogName("CentralCatalog")
 *             .devCenterName("Contoso")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Catalogs_CreateOrUpdateGitHub
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var catalog = new AzureNative.DevCenter.Catalog("catalog", new()
 *     {
 *         CatalogName = "CentralCatalog",
 *         DevCenterName = "Contoso",
 *         GitHub = new AzureNative.DevCenter.Inputs.GitCatalogArgs
 *         {
 *             Branch = "main",
 *             Path = "/templates",
 *             SecretIdentifier = "https://contosokv.vault.azure.net/secrets/CentralRepoPat",
 *             Uri = "https://github.com/Contoso/centralrepo-fake.git",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewCatalog(ctx, "catalog", &devcenter.CatalogArgs{
 * 			CatalogName:   pulumi.String("CentralCatalog"),
 * 			DevCenterName: pulumi.String("Contoso"),
 * 			GitHub: &devcenter.GitCatalogArgs{
 * 				Branch:           pulumi.String("main"),
 * 				Path:             pulumi.String("/templates"),
 * 				SecretIdentifier: pulumi.String("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 * 				Uri:              pulumi.String("https://github.com/Contoso/centralrepo-fake.git"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Catalog;
 * import com.pulumi.azurenative.devcenter.CatalogArgs;
 * import com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var catalog = new Catalog("catalog", CatalogArgs.builder()
 *             .catalogName("CentralCatalog")
 *             .devCenterName("Contoso")
 *             .gitHub(GitCatalogArgs.builder()
 *                 .branch("main")
 *                 .path("/templates")
 *                 .secretIdentifier("https://contosokv.vault.azure.net/secrets/CentralRepoPat")
 *                 .uri("https://github.com/Contoso/centralrepo-fake.git")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Catalog CentralCatalog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/catalogs/{catalogName}
 * ```
 * @property adoGit Properties for an Azure DevOps catalog type.
 * @property catalogName The name of the Catalog.
 * @property devCenterName The name of the devcenter.
 * @property gitHub Properties for a GitHub catalog type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class CatalogArgs(
    public val adoGit: Output<GitCatalogArgs>? = null,
    public val catalogName: Output<String>? = null,
    public val devCenterName: Output<String>? = null,
    public val gitHub: Output<GitCatalogArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.CatalogArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.CatalogArgs =
        com.pulumi.azurenative.devcenter.CatalogArgs.builder()
            .adoGit(adoGit?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .catalogName(catalogName?.applyValue({ args0 -> args0 }))
            .devCenterName(devCenterName?.applyValue({ args0 -> args0 }))
            .gitHub(gitHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CatalogArgs].
 */
@PulumiTagMarker
public class CatalogArgsBuilder internal constructor() {
    private var adoGit: Output<GitCatalogArgs>? = null

    private var catalogName: Output<String>? = null

    private var devCenterName: Output<String>? = null

    private var gitHub: Output<GitCatalogArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Properties for an Azure DevOps catalog type.
     */
    @JvmName("iqrnhrycslqepbrn")
    public suspend fun adoGit(`value`: Output<GitCatalogArgs>) {
        this.adoGit = value
    }

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("xaqpelicpixnllvh")
    public suspend fun catalogName(`value`: Output<String>) {
        this.catalogName = value
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("hghihvhkttgtobxm")
    public suspend fun devCenterName(`value`: Output<String>) {
        this.devCenterName = value
    }

    /**
     * @param value Properties for a GitHub catalog type.
     */
    @JvmName("uqlceqdmgapekoer")
    public suspend fun gitHub(`value`: Output<GitCatalogArgs>) {
        this.gitHub = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ncalkjbwcjfyctno")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Properties for an Azure DevOps catalog type.
     */
    @JvmName("mcsgsllvarttuufm")
    public suspend fun adoGit(`value`: GitCatalogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adoGit = mapped
    }

    /**
     * @param argument Properties for an Azure DevOps catalog type.
     */
    @JvmName("niiftekruyirvrke")
    public suspend fun adoGit(argument: suspend GitCatalogArgsBuilder.() -> Unit) {
        val toBeMapped = GitCatalogArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.adoGit = mapped
    }

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("pwngmqistslglmcq")
    public suspend fun catalogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogName = mapped
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("nkapwffmisetypko")
    public suspend fun devCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devCenterName = mapped
    }

    /**
     * @param value Properties for a GitHub catalog type.
     */
    @JvmName("nwxjvhltgrwmvujg")
    public suspend fun gitHub(`value`: GitCatalogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHub = mapped
    }

    /**
     * @param argument Properties for a GitHub catalog type.
     */
    @JvmName("vcpcsehupigxukpp")
    public suspend fun gitHub(argument: suspend GitCatalogArgsBuilder.() -> Unit) {
        val toBeMapped = GitCatalogArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitHub = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fisbdyhpjdjvpaem")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CatalogArgs = CatalogArgs(
        adoGit = adoGit,
        catalogName = catalogName,
        devCenterName = devCenterName,
        gitHub = gitHub,
        resourceGroupName = resourceGroupName,
    )
}
