@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.DevcenterFunctions.getAttachedNetworkByDevCenterPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getCatalogDevBoxDefinitionErrorDetailsPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getCatalogPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getCatalogSyncErrorDetailsPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getCustomizationTaskErrorDetailsPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getDevBoxDefinitionPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getDevCenterPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getEnvironmentDefinitionErrorDetailsPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getEnvironmentTypePlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getGalleryPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getNetworkConnectionPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getPoolPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getProjectCatalogEnvironmentDefinitionErrorDetailsPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getProjectCatalogPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getProjectCatalogSyncErrorDetailsPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getProjectEnvironmentTypePlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getProjectPlain
import com.pulumi.azurenative.devcenter.DevcenterFunctions.getSchedulePlain
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetAttachedNetworkByDevCenterPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetAttachedNetworkByDevCenterPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetCatalogDevBoxDefinitionErrorDetailsPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetCatalogDevBoxDefinitionErrorDetailsPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetCatalogPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetCatalogPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetCatalogSyncErrorDetailsPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetCatalogSyncErrorDetailsPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetCustomizationTaskErrorDetailsPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetCustomizationTaskErrorDetailsPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetDevBoxDefinitionPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetDevBoxDefinitionPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetDevCenterPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetDevCenterPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetEnvironmentDefinitionErrorDetailsPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetEnvironmentDefinitionErrorDetailsPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetEnvironmentTypePlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetEnvironmentTypePlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetGalleryPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetGalleryPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetNetworkConnectionPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetNetworkConnectionPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetPoolPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetPoolPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectCatalogPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectCatalogPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectCatalogSyncErrorDetailsPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectCatalogSyncErrorDetailsPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectEnvironmentTypePlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectEnvironmentTypePlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectPlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetProjectPlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetSchedulePlainArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GetSchedulePlainArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetAttachedNetworkByDevCenterResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetCatalogDevBoxDefinitionErrorDetailsResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetCatalogResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetCatalogSyncErrorDetailsResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetCustomizationTaskErrorDetailsResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetDevBoxDefinitionResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetDevCenterResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetEnvironmentDefinitionErrorDetailsResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetEnvironmentTypeResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetGalleryResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetNetworkConnectionResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetPoolResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectCatalogEnvironmentDefinitionErrorDetailsResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectCatalogResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectCatalogSyncErrorDetailsResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectEnvironmentTypeResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectResult
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetScheduleResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetAttachedNetworkByDevCenterResult.Companion.toKotlin as getAttachedNetworkByDevCenterResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetCatalogDevBoxDefinitionErrorDetailsResult.Companion.toKotlin as getCatalogDevBoxDefinitionErrorDetailsResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetCatalogResult.Companion.toKotlin as getCatalogResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetCatalogSyncErrorDetailsResult.Companion.toKotlin as getCatalogSyncErrorDetailsResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetCustomizationTaskErrorDetailsResult.Companion.toKotlin as getCustomizationTaskErrorDetailsResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetDevBoxDefinitionResult.Companion.toKotlin as getDevBoxDefinitionResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetDevCenterResult.Companion.toKotlin as getDevCenterResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetEnvironmentDefinitionErrorDetailsResult.Companion.toKotlin as getEnvironmentDefinitionErrorDetailsResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetEnvironmentTypeResult.Companion.toKotlin as getEnvironmentTypeResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetGalleryResult.Companion.toKotlin as getGalleryResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetNetworkConnectionResult.Companion.toKotlin as getNetworkConnectionResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetPoolResult.Companion.toKotlin as getPoolResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectCatalogEnvironmentDefinitionErrorDetailsResult.Companion.toKotlin as getProjectCatalogEnvironmentDefinitionErrorDetailsResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectCatalogResult.Companion.toKotlin as getProjectCatalogResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectCatalogSyncErrorDetailsResult.Companion.toKotlin as getProjectCatalogSyncErrorDetailsResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectEnvironmentTypeResult.Companion.toKotlin as getProjectEnvironmentTypeResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetProjectResult.Companion.toKotlin as getProjectResultToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.GetScheduleResult.Companion.toKotlin as getScheduleResultToKotlin

public object DevcenterFunctions {
    /**
     * Gets an attached NetworkConnection.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents an attached NetworkConnection.
     */
    public suspend
    fun getAttachedNetworkByDevCenter(argument: GetAttachedNetworkByDevCenterPlainArgs):
        GetAttachedNetworkByDevCenterResult =
        getAttachedNetworkByDevCenterResultToKotlin(getAttachedNetworkByDevCenterPlain(argument.toJava()).await())

    /**
     * @see [getAttachedNetworkByDevCenter].
     * @param attachedNetworkConnectionName The name of the attached NetworkConnection.
     * @param devCenterName The name of the devcenter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents an attached NetworkConnection.
     */
    public suspend fun getAttachedNetworkByDevCenter(
        attachedNetworkConnectionName: String,
        devCenterName: String,
        resourceGroupName: String,
    ): GetAttachedNetworkByDevCenterResult {
        val argument = GetAttachedNetworkByDevCenterPlainArgs(
            attachedNetworkConnectionName = attachedNetworkConnectionName,
            devCenterName = devCenterName,
            resourceGroupName = resourceGroupName,
        )
        return getAttachedNetworkByDevCenterResultToKotlin(getAttachedNetworkByDevCenterPlain(argument.toJava()).await())
    }

    /**
     * @see [getAttachedNetworkByDevCenter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetAttachedNetworkByDevCenterPlainArgs].
     * @return Represents an attached NetworkConnection.
     */
    public suspend
    fun getAttachedNetworkByDevCenter(argument: suspend GetAttachedNetworkByDevCenterPlainArgsBuilder.() -> Unit):
        GetAttachedNetworkByDevCenterResult {
        val builder = GetAttachedNetworkByDevCenterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAttachedNetworkByDevCenterResultToKotlin(getAttachedNetworkByDevCenterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a catalog
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents a catalog.
     */
    public suspend fun getCatalog(argument: GetCatalogPlainArgs): GetCatalogResult =
        getCatalogResultToKotlin(getCatalogPlain(argument.toJava()).await())

    /**
     * @see [getCatalog].
     * @param catalogName The name of the Catalog.
     * @param devCenterName The name of the devcenter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a catalog.
     */
    public suspend fun getCatalog(
        catalogName: String,
        devCenterName: String,
        resourceGroupName: String,
    ): GetCatalogResult {
        val argument = GetCatalogPlainArgs(
            catalogName = catalogName,
            devCenterName = devCenterName,
            resourceGroupName = resourceGroupName,
        )
        return getCatalogResultToKotlin(getCatalogPlain(argument.toJava()).await())
    }

    /**
     * @see [getCatalog].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetCatalogPlainArgs].
     * @return Represents a catalog.
     */
    public suspend fun getCatalog(argument: suspend GetCatalogPlainArgsBuilder.() -> Unit):
        GetCatalogResult {
        val builder = GetCatalogPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCatalogResultToKotlin(getCatalogPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets Catalog Devbox Definition error details
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend
    fun getCatalogDevBoxDefinitionErrorDetails(argument: GetCatalogDevBoxDefinitionErrorDetailsPlainArgs):
        GetCatalogDevBoxDefinitionErrorDetailsResult =
        getCatalogDevBoxDefinitionErrorDetailsResultToKotlin(getCatalogDevBoxDefinitionErrorDetailsPlain(argument.toJava()).await())

    /**
     * @see [getCatalogDevBoxDefinitionErrorDetails].
     * @param catalogName The name of the Catalog.
     * @param devBoxDefinitionName The name of the Dev Box definition.
     * @param devCenterName The name of the devcenter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend fun getCatalogDevBoxDefinitionErrorDetails(
        catalogName: String,
        devBoxDefinitionName: String,
        devCenterName: String,
        resourceGroupName: String,
    ): GetCatalogDevBoxDefinitionErrorDetailsResult {
        val argument = GetCatalogDevBoxDefinitionErrorDetailsPlainArgs(
            catalogName = catalogName,
            devBoxDefinitionName = devBoxDefinitionName,
            devCenterName = devCenterName,
            resourceGroupName = resourceGroupName,
        )
        return getCatalogDevBoxDefinitionErrorDetailsResultToKotlin(getCatalogDevBoxDefinitionErrorDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCatalogDevBoxDefinitionErrorDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetCatalogDevBoxDefinitionErrorDetailsPlainArgs].
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend
    fun getCatalogDevBoxDefinitionErrorDetails(argument: suspend GetCatalogDevBoxDefinitionErrorDetailsPlainArgsBuilder.() -> Unit):
        GetCatalogDevBoxDefinitionErrorDetailsResult {
        val builder = GetCatalogDevBoxDefinitionErrorDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCatalogDevBoxDefinitionErrorDetailsResultToKotlin(getCatalogDevBoxDefinitionErrorDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets catalog synchronization error details
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Synchronization error details.
     */
    public suspend fun getCatalogSyncErrorDetails(argument: GetCatalogSyncErrorDetailsPlainArgs):
        GetCatalogSyncErrorDetailsResult =
        getCatalogSyncErrorDetailsResultToKotlin(getCatalogSyncErrorDetailsPlain(argument.toJava()).await())

    /**
     * @see [getCatalogSyncErrorDetails].
     * @param catalogName The name of the Catalog.
     * @param devCenterName The name of the devcenter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Synchronization error details.
     */
    public suspend fun getCatalogSyncErrorDetails(
        catalogName: String,
        devCenterName: String,
        resourceGroupName: String,
    ): GetCatalogSyncErrorDetailsResult {
        val argument = GetCatalogSyncErrorDetailsPlainArgs(
            catalogName = catalogName,
            devCenterName = devCenterName,
            resourceGroupName = resourceGroupName,
        )
        return getCatalogSyncErrorDetailsResultToKotlin(getCatalogSyncErrorDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCatalogSyncErrorDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetCatalogSyncErrorDetailsPlainArgs].
     * @return Synchronization error details.
     */
    public suspend
    fun getCatalogSyncErrorDetails(argument: suspend GetCatalogSyncErrorDetailsPlainArgsBuilder.() -> Unit):
        GetCatalogSyncErrorDetailsResult {
        val builder = GetCatalogSyncErrorDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCatalogSyncErrorDetailsResultToKotlin(getCatalogSyncErrorDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets Customization Task error details
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-10-01-preview.
     * @param argument null
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend
    fun getCustomizationTaskErrorDetails(argument: GetCustomizationTaskErrorDetailsPlainArgs):
        GetCustomizationTaskErrorDetailsResult =
        getCustomizationTaskErrorDetailsResultToKotlin(getCustomizationTaskErrorDetailsPlain(argument.toJava()).await())

    /**
     * @see [getCustomizationTaskErrorDetails].
     * @param catalogName The name of the Catalog.
     * @param devCenterName The name of the devcenter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param taskName The name of the Task.
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend fun getCustomizationTaskErrorDetails(
        catalogName: String,
        devCenterName: String,
        resourceGroupName: String,
        taskName: String,
    ): GetCustomizationTaskErrorDetailsResult {
        val argument = GetCustomizationTaskErrorDetailsPlainArgs(
            catalogName = catalogName,
            devCenterName = devCenterName,
            resourceGroupName = resourceGroupName,
            taskName = taskName,
        )
        return getCustomizationTaskErrorDetailsResultToKotlin(getCustomizationTaskErrorDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomizationTaskErrorDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetCustomizationTaskErrorDetailsPlainArgs].
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend
    fun getCustomizationTaskErrorDetails(argument: suspend GetCustomizationTaskErrorDetailsPlainArgsBuilder.() -> Unit):
        GetCustomizationTaskErrorDetailsResult {
        val builder = GetCustomizationTaskErrorDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomizationTaskErrorDetailsResultToKotlin(getCustomizationTaskErrorDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Dev Box definition
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-11-11-preview, 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents a definition for a Developer Machine.
     */
    public suspend fun getDevBoxDefinition(argument: GetDevBoxDefinitionPlainArgs):
        GetDevBoxDefinitionResult =
        getDevBoxDefinitionResultToKotlin(getDevBoxDefinitionPlain(argument.toJava()).await())

    /**
     * @see [getDevBoxDefinition].
     * @param devBoxDefinitionName The name of the Dev Box definition.
     * @param devCenterName The name of the devcenter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a definition for a Developer Machine.
     */
    public suspend fun getDevBoxDefinition(
        devBoxDefinitionName: String,
        devCenterName: String,
        resourceGroupName: String,
    ): GetDevBoxDefinitionResult {
        val argument = GetDevBoxDefinitionPlainArgs(
            devBoxDefinitionName = devBoxDefinitionName,
            devCenterName = devCenterName,
            resourceGroupName = resourceGroupName,
        )
        return getDevBoxDefinitionResultToKotlin(getDevBoxDefinitionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDevBoxDefinition].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetDevBoxDefinitionPlainArgs].
     * @return Represents a definition for a Developer Machine.
     */
    public suspend
    fun getDevBoxDefinition(argument: suspend GetDevBoxDefinitionPlainArgsBuilder.() -> Unit):
        GetDevBoxDefinitionResult {
        val builder = GetDevBoxDefinitionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDevBoxDefinitionResultToKotlin(getDevBoxDefinitionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a devcenter.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents a devcenter resource.
     */
    public suspend fun getDevCenter(argument: GetDevCenterPlainArgs): GetDevCenterResult =
        getDevCenterResultToKotlin(getDevCenterPlain(argument.toJava()).await())

    /**
     * @see [getDevCenter].
     * @param devCenterName The name of the devcenter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a devcenter resource.
     */
    public suspend fun getDevCenter(devCenterName: String, resourceGroupName: String):
        GetDevCenterResult {
        val argument = GetDevCenterPlainArgs(
            devCenterName = devCenterName,
            resourceGroupName = resourceGroupName,
        )
        return getDevCenterResultToKotlin(getDevCenterPlain(argument.toJava()).await())
    }

    /**
     * @see [getDevCenter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetDevCenterPlainArgs].
     * @return Represents a devcenter resource.
     */
    public suspend fun getDevCenter(argument: suspend GetDevCenterPlainArgsBuilder.() -> Unit):
        GetDevCenterResult {
        val builder = GetDevCenterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDevCenterResultToKotlin(getDevCenterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets Environment Definition error details
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend
    fun getEnvironmentDefinitionErrorDetails(argument: GetEnvironmentDefinitionErrorDetailsPlainArgs):
        GetEnvironmentDefinitionErrorDetailsResult =
        getEnvironmentDefinitionErrorDetailsResultToKotlin(getEnvironmentDefinitionErrorDetailsPlain(argument.toJava()).await())

    /**
     * @see [getEnvironmentDefinitionErrorDetails].
     * @param catalogName The name of the Catalog.
     * @param devCenterName The name of the devcenter.
     * @param environmentDefinitionName The name of the Environment Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend fun getEnvironmentDefinitionErrorDetails(
        catalogName: String,
        devCenterName: String,
        environmentDefinitionName: String,
        resourceGroupName: String,
    ): GetEnvironmentDefinitionErrorDetailsResult {
        val argument = GetEnvironmentDefinitionErrorDetailsPlainArgs(
            catalogName = catalogName,
            devCenterName = devCenterName,
            environmentDefinitionName = environmentDefinitionName,
            resourceGroupName = resourceGroupName,
        )
        return getEnvironmentDefinitionErrorDetailsResultToKotlin(getEnvironmentDefinitionErrorDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironmentDefinitionErrorDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetEnvironmentDefinitionErrorDetailsPlainArgs].
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend
    fun getEnvironmentDefinitionErrorDetails(argument: suspend GetEnvironmentDefinitionErrorDetailsPlainArgsBuilder.() -> Unit):
        GetEnvironmentDefinitionErrorDetailsResult {
        val builder = GetEnvironmentDefinitionErrorDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentDefinitionErrorDetailsResultToKotlin(getEnvironmentDefinitionErrorDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an environment type.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents an environment type.
     */
    public suspend fun getEnvironmentType(argument: GetEnvironmentTypePlainArgs):
        GetEnvironmentTypeResult =
        getEnvironmentTypeResultToKotlin(getEnvironmentTypePlain(argument.toJava()).await())

    /**
     * @see [getEnvironmentType].
     * @param devCenterName The name of the devcenter.
     * @param environmentTypeName The name of the environment type.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents an environment type.
     */
    public suspend fun getEnvironmentType(
        devCenterName: String,
        environmentTypeName: String,
        resourceGroupName: String,
    ): GetEnvironmentTypeResult {
        val argument = GetEnvironmentTypePlainArgs(
            devCenterName = devCenterName,
            environmentTypeName = environmentTypeName,
            resourceGroupName = resourceGroupName,
        )
        return getEnvironmentTypeResultToKotlin(getEnvironmentTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironmentType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetEnvironmentTypePlainArgs].
     * @return Represents an environment type.
     */
    public suspend
    fun getEnvironmentType(argument: suspend GetEnvironmentTypePlainArgsBuilder.() -> Unit):
        GetEnvironmentTypeResult {
        val builder = GetEnvironmentTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentTypeResultToKotlin(getEnvironmentTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a gallery
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents a gallery.
     */
    public suspend fun getGallery(argument: GetGalleryPlainArgs): GetGalleryResult =
        getGalleryResultToKotlin(getGalleryPlain(argument.toJava()).await())

    /**
     * @see [getGallery].
     * @param devCenterName The name of the devcenter.
     * @param galleryName The name of the gallery.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a gallery.
     */
    public suspend fun getGallery(
        devCenterName: String,
        galleryName: String,
        resourceGroupName: String,
    ): GetGalleryResult {
        val argument = GetGalleryPlainArgs(
            devCenterName = devCenterName,
            galleryName = galleryName,
            resourceGroupName = resourceGroupName,
        )
        return getGalleryResultToKotlin(getGalleryPlain(argument.toJava()).await())
    }

    /**
     * @see [getGallery].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetGalleryPlainArgs].
     * @return Represents a gallery.
     */
    public suspend fun getGallery(argument: suspend GetGalleryPlainArgsBuilder.() -> Unit):
        GetGalleryResult {
        val builder = GetGalleryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGalleryResultToKotlin(getGalleryPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a network connection resource
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Network related settings
     */
    public suspend fun getNetworkConnection(argument: GetNetworkConnectionPlainArgs):
        GetNetworkConnectionResult =
        getNetworkConnectionResultToKotlin(getNetworkConnectionPlain(argument.toJava()).await())

    /**
     * @see [getNetworkConnection].
     * @param networkConnectionName Name of the Network Connection that can be applied to a Pool.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Network related settings
     */
    public suspend fun getNetworkConnection(networkConnectionName: String, resourceGroupName: String):
        GetNetworkConnectionResult {
        val argument = GetNetworkConnectionPlainArgs(
            networkConnectionName = networkConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getNetworkConnectionResultToKotlin(getNetworkConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetNetworkConnectionPlainArgs].
     * @return Network related settings
     */
    public suspend
    fun getNetworkConnection(argument: suspend GetNetworkConnectionPlainArgsBuilder.() -> Unit):
        GetNetworkConnectionResult {
        val builder = GetNetworkConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkConnectionResultToKotlin(getNetworkConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a machine pool
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return A pool of Virtual Machines.
     */
    public suspend fun getPool(argument: GetPoolPlainArgs): GetPoolResult =
        getPoolResultToKotlin(getPoolPlain(argument.toJava()).await())

    /**
     * @see [getPool].
     * @param poolName Name of the pool.
     * @param projectName The name of the project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A pool of Virtual Machines.
     */
    public suspend fun getPool(
        poolName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetPoolResult {
        val argument = GetPoolPlainArgs(
            poolName = poolName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getPoolResultToKotlin(getPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetPoolPlainArgs].
     * @return A pool of Virtual Machines.
     */
    public suspend fun getPool(argument: suspend GetPoolPlainArgsBuilder.() -> Unit): GetPoolResult {
        val builder = GetPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPoolResultToKotlin(getPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific project.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents a project resource.
     */
    public suspend fun getProject(argument: GetProjectPlainArgs): GetProjectResult =
        getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())

    /**
     * @see [getProject].
     * @param projectName The name of the project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a project resource.
     */
    public suspend fun getProject(projectName: String, resourceGroupName: String): GetProjectResult {
        val argument = GetProjectPlainArgs(
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getProject].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetProjectPlainArgs].
     * @return Represents a project resource.
     */
    public suspend fun getProject(argument: suspend GetProjectPlainArgsBuilder.() -> Unit):
        GetProjectResult {
        val builder = GetProjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectResultToKotlin(getProjectPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an associated project catalog.
     * Azure REST API version: 2024-02-01.
     * @param argument null
     * @return Represents a catalog.
     */
    public suspend fun getProjectCatalog(argument: GetProjectCatalogPlainArgs):
        GetProjectCatalogResult =
        getProjectCatalogResultToKotlin(getProjectCatalogPlain(argument.toJava()).await())

    /**
     * @see [getProjectCatalog].
     * @param catalogName The name of the Catalog.
     * @param projectName The name of the project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a catalog.
     */
    public suspend fun getProjectCatalog(
        catalogName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetProjectCatalogResult {
        val argument = GetProjectCatalogPlainArgs(
            catalogName = catalogName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getProjectCatalogResultToKotlin(getProjectCatalogPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectCatalog].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetProjectCatalogPlainArgs].
     * @return Represents a catalog.
     */
    public suspend
    fun getProjectCatalog(argument: suspend GetProjectCatalogPlainArgsBuilder.() -> Unit):
        GetProjectCatalogResult {
        val builder = GetProjectCatalogPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectCatalogResultToKotlin(getProjectCatalogPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets Environment Definition error details
     * Azure REST API version: 2024-02-01.
     * @param argument null
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend
    fun getProjectCatalogEnvironmentDefinitionErrorDetails(argument: GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs):
        GetProjectCatalogEnvironmentDefinitionErrorDetailsResult =
        getProjectCatalogEnvironmentDefinitionErrorDetailsResultToKotlin(getProjectCatalogEnvironmentDefinitionErrorDetailsPlain(argument.toJava()).await())

    /**
     * @see [getProjectCatalogEnvironmentDefinitionErrorDetails].
     * @param catalogName The name of the Catalog.
     * @param environmentDefinitionName The name of the Environment Definition.
     * @param projectName The name of the project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend fun getProjectCatalogEnvironmentDefinitionErrorDetails(
        catalogName: String,
        environmentDefinitionName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetProjectCatalogEnvironmentDefinitionErrorDetailsResult {
        val argument = GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs(
            catalogName = catalogName,
            environmentDefinitionName = environmentDefinitionName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getProjectCatalogEnvironmentDefinitionErrorDetailsResultToKotlin(getProjectCatalogEnvironmentDefinitionErrorDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectCatalogEnvironmentDefinitionErrorDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs].
     * @return List of validator error details. Populated when changes are made to the resource or its dependent resources that impact the validity of the Catalog resource.
     */
    public suspend
    fun getProjectCatalogEnvironmentDefinitionErrorDetails(argument: suspend GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgsBuilder.() -> Unit):
        GetProjectCatalogEnvironmentDefinitionErrorDetailsResult {
        val builder = GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectCatalogEnvironmentDefinitionErrorDetailsResultToKotlin(getProjectCatalogEnvironmentDefinitionErrorDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets project catalog synchronization error details
     * Azure REST API version: 2024-02-01.
     * @param argument null
     * @return Synchronization error details.
     */
    public suspend
    fun getProjectCatalogSyncErrorDetails(argument: GetProjectCatalogSyncErrorDetailsPlainArgs):
        GetProjectCatalogSyncErrorDetailsResult =
        getProjectCatalogSyncErrorDetailsResultToKotlin(getProjectCatalogSyncErrorDetailsPlain(argument.toJava()).await())

    /**
     * @see [getProjectCatalogSyncErrorDetails].
     * @param catalogName The name of the Catalog.
     * @param projectName The name of the project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Synchronization error details.
     */
    public suspend fun getProjectCatalogSyncErrorDetails(
        catalogName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetProjectCatalogSyncErrorDetailsResult {
        val argument = GetProjectCatalogSyncErrorDetailsPlainArgs(
            catalogName = catalogName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getProjectCatalogSyncErrorDetailsResultToKotlin(getProjectCatalogSyncErrorDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectCatalogSyncErrorDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetProjectCatalogSyncErrorDetailsPlainArgs].
     * @return Synchronization error details.
     */
    public suspend
    fun getProjectCatalogSyncErrorDetails(argument: suspend GetProjectCatalogSyncErrorDetailsPlainArgsBuilder.() -> Unit):
        GetProjectCatalogSyncErrorDetailsResult {
        val builder = GetProjectCatalogSyncErrorDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectCatalogSyncErrorDetailsResultToKotlin(getProjectCatalogSyncErrorDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a project environment type.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents an environment type.
     */
    public suspend fun getProjectEnvironmentType(argument: GetProjectEnvironmentTypePlainArgs):
        GetProjectEnvironmentTypeResult =
        getProjectEnvironmentTypeResultToKotlin(getProjectEnvironmentTypePlain(argument.toJava()).await())

    /**
     * @see [getProjectEnvironmentType].
     * @param environmentTypeName The name of the environment type.
     * @param projectName The name of the project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents an environment type.
     */
    public suspend fun getProjectEnvironmentType(
        environmentTypeName: String,
        projectName: String,
        resourceGroupName: String,
    ): GetProjectEnvironmentTypeResult {
        val argument = GetProjectEnvironmentTypePlainArgs(
            environmentTypeName = environmentTypeName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
        return getProjectEnvironmentTypeResultToKotlin(getProjectEnvironmentTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectEnvironmentType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetProjectEnvironmentTypePlainArgs].
     * @return Represents an environment type.
     */
    public suspend
    fun getProjectEnvironmentType(argument: suspend GetProjectEnvironmentTypePlainArgsBuilder.() -> Unit):
        GetProjectEnvironmentTypeResult {
        val builder = GetProjectEnvironmentTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectEnvironmentTypeResultToKotlin(getProjectEnvironmentTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a schedule resource.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
     * @param argument null
     * @return Represents a Schedule to execute a task.
     */
    public suspend fun getSchedule(argument: GetSchedulePlainArgs): GetScheduleResult =
        getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())

    /**
     * @see [getSchedule].
     * @param poolName Name of the pool.
     * @param projectName The name of the project.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scheduleName The name of the schedule that uniquely identifies it.
     * @param top The maximum number of resources to return from the operation. Example: '$top=10'.
     * @return Represents a Schedule to execute a task.
     */
    public suspend fun getSchedule(
        poolName: String,
        projectName: String,
        resourceGroupName: String,
        scheduleName: String,
        top: Int? = null,
    ): GetScheduleResult {
        val argument = GetSchedulePlainArgs(
            poolName = poolName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
            scheduleName = scheduleName,
            top = top,
        )
        return getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devcenter&#46;kotlin&#46;inputs&#46;GetSchedulePlainArgs].
     * @return Represents a Schedule to execute a task.
     */
    public suspend fun getSchedule(argument: suspend GetSchedulePlainArgsBuilder.() -> Unit):
        GetScheduleResult {
        val builder = GetSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduleResultToKotlin(getSchedulePlain(builtArgument.toJava()).await())
    }
}
