@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NetworkConnection].
 */
@PulumiTagMarker
public class NetworkConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkConnectionArgs = NetworkConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkConnectionArgsBuilder.() -> Unit) {
        val builder = NetworkConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkConnection {
        val builtJavaResource =
            com.pulumi.azurenative.devcenter.NetworkConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkConnection(builtJavaResource)
    }
}

/**
 * Network related settings
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
 * ## Example Usage
 * ### NetworkConnections_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkConnection = new AzureNative.DevCenter.NetworkConnection("networkConnection", new()
 *     {
 *         DomainJoinType = AzureNative.DevCenter.DomainJoinType.HybridAzureADJoin,
 *         DomainName = "mydomaincontroller.local",
 *         DomainPassword = "Password value for user",
 *         DomainUsername = "testuser@mydomaincontroller.local",
 *         Location = "centralus",
 *         NetworkConnectionName = "uswest3network",
 *         NetworkingResourceGroupName = "NetworkInterfaces",
 *         ResourceGroupName = "rg1",
 *         SubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/ExampleRG/providers/Microsoft.Network/virtualNetworks/ExampleVNet/subnets/default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewNetworkConnection(ctx, "networkConnection", &devcenter.NetworkConnectionArgs{
 * 			DomainJoinType:              pulumi.String(devcenter.DomainJoinTypeHybridAzureADJoin),
 * 			DomainName:                  pulumi.String("mydomaincontroller.local"),
 * 			DomainPassword:              pulumi.String("Password value for user"),
 * 			DomainUsername:              pulumi.String("testuser@mydomaincontroller.local"),
 * 			Location:                    pulumi.String("centralus"),
 * 			NetworkConnectionName:       pulumi.String("uswest3network"),
 * 			NetworkingResourceGroupName: pulumi.String("NetworkInterfaces"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 			SubnetId:                    pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/ExampleRG/providers/Microsoft.Network/virtualNetworks/ExampleVNet/subnets/default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.NetworkConnection;
 * import com.pulumi.azurenative.devcenter.NetworkConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkConnection = new NetworkConnection("networkConnection", NetworkConnectionArgs.builder()
 *             .domainJoinType("HybridAzureADJoin")
 *             .domainName("mydomaincontroller.local")
 *             .domainPassword("Password value for user")
 *             .domainUsername("testuser@mydomaincontroller.local")
 *             .location("centralus")
 *             .networkConnectionName("uswest3network")
 *             .networkingResourceGroupName("NetworkInterfaces")
 *             .resourceGroupName("rg1")
 *             .subnetId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/ExampleRG/providers/Microsoft.Network/virtualNetworks/ExampleVNet/subnets/default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:NetworkConnection uswest3network /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/networkConnections/{networkConnectionName}
 * ```
 */
public class NetworkConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.NetworkConnection,
) : KotlinCustomResource(javaResource, NetworkConnectionMapper) {
    /**
     * AAD Join type.
     */
    public val domainJoinType: Output<String>
        get() = javaResource.domainJoinType().applyValue({ args0 -> args0 })

    /**
     * Active Directory domain name
     */
    public val domainName: Output<String>?
        get() = javaResource.domainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password for the account used to join domain
     */
    public val domainPassword: Output<String>?
        get() = javaResource.domainPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The username of an Active Directory account (user or service account) that has permissions to create computer objects in Active Directory. Required format: admin@contoso.com.
     */
    public val domainUsername: Output<String>?
        get() = javaResource.domainUsername().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Overall health status of the network connection. Health checks are run on creation, update, and periodically to validate the network connection.
     */
    public val healthCheckStatus: Output<String>
        get() = javaResource.healthCheckStatus().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name for resource group where NICs will be placed.
     */
    public val networkingResourceGroupName: Output<String>?
        get() = javaResource.networkingResourceGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Active Directory domain Organization Unit (OU)
     */
    public val organizationUnit: Output<String>?
        get() = javaResource.organizationUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The subnet to attach Virtual Machines to
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkConnectionMapper : ResourceMapper<NetworkConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.NetworkConnection::class == javaResource::class

    override fun map(javaResource: Resource): NetworkConnection = NetworkConnection(
        javaResource as
            com.pulumi.azurenative.devcenter.NetworkConnection,
    )
}

/**
 * @see [NetworkConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkConnection].
 */
public suspend fun networkConnection(
    name: String,
    block: suspend NetworkConnectionResourceBuilder.() -> Unit,
): NetworkConnection {
    val builder = NetworkConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkConnection(name: String): NetworkConnection {
    val builder = NetworkConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
