@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.NetworkConnectionArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.DomainJoinType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Network related settings
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
 * ## Example Usage
 * ### NetworkConnections_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkConnection = new AzureNative.DevCenter.NetworkConnection("networkConnection", new()
 *     {
 *         DomainJoinType = AzureNative.DevCenter.DomainJoinType.HybridAzureADJoin,
 *         DomainName = "mydomaincontroller.local",
 *         DomainPassword = "Password value for user",
 *         DomainUsername = "testuser@mydomaincontroller.local",
 *         Location = "centralus",
 *         NetworkConnectionName = "uswest3network",
 *         NetworkingResourceGroupName = "NetworkInterfaces",
 *         ResourceGroupName = "rg1",
 *         SubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/ExampleRG/providers/Microsoft.Network/virtualNetworks/ExampleVNet/subnets/default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewNetworkConnection(ctx, "networkConnection", &devcenter.NetworkConnectionArgs{
 * 			DomainJoinType:              pulumi.String(devcenter.DomainJoinTypeHybridAzureADJoin),
 * 			DomainName:                  pulumi.String("mydomaincontroller.local"),
 * 			DomainPassword:              pulumi.String("Password value for user"),
 * 			DomainUsername:              pulumi.String("testuser@mydomaincontroller.local"),
 * 			Location:                    pulumi.String("centralus"),
 * 			NetworkConnectionName:       pulumi.String("uswest3network"),
 * 			NetworkingResourceGroupName: pulumi.String("NetworkInterfaces"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 			SubnetId:                    pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/ExampleRG/providers/Microsoft.Network/virtualNetworks/ExampleVNet/subnets/default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.NetworkConnection;
 * import com.pulumi.azurenative.devcenter.NetworkConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkConnection = new NetworkConnection("networkConnection", NetworkConnectionArgs.builder()
 *             .domainJoinType("HybridAzureADJoin")
 *             .domainName("mydomaincontroller.local")
 *             .domainPassword("Password value for user")
 *             .domainUsername("testuser@mydomaincontroller.local")
 *             .location("centralus")
 *             .networkConnectionName("uswest3network")
 *             .networkingResourceGroupName("NetworkInterfaces")
 *             .resourceGroupName("rg1")
 *             .subnetId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/ExampleRG/providers/Microsoft.Network/virtualNetworks/ExampleVNet/subnets/default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:NetworkConnection uswest3network /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/networkConnections/{networkConnectionName}
 * ```
 * @property domainJoinType AAD Join type.
 * @property domainName Active Directory domain name
 * @property domainPassword The password for the account used to join domain
 * @property domainUsername The username of an Active Directory account (user or service account) that has permissions to create computer objects in Active Directory. Required format: admin@contoso.com.
 * @property location The geo-location where the resource lives
 * @property networkConnectionName Name of the Network Connection that can be applied to a Pool.
 * @property networkingResourceGroupName The name for resource group where NICs will be placed.
 * @property organizationUnit Active Directory domain Organization Unit (OU)
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subnetId The subnet to attach Virtual Machines to
 * @property tags Resource tags.
 */
public data class NetworkConnectionArgs(
    public val domainJoinType: Output<Either<String, DomainJoinType>>? = null,
    public val domainName: Output<String>? = null,
    public val domainPassword: Output<String>? = null,
    public val domainUsername: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkConnectionName: Output<String>? = null,
    public val networkingResourceGroupName: Output<String>? = null,
    public val organizationUnit: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.NetworkConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.NetworkConnectionArgs =
        com.pulumi.azurenative.devcenter.NetworkConnectionArgs.builder()
            .domainJoinType(
                domainJoinType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .domainPassword(domainPassword?.applyValue({ args0 -> args0 }))
            .domainUsername(domainUsername?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkConnectionName(networkConnectionName?.applyValue({ args0 -> args0 }))
            .networkingResourceGroupName(networkingResourceGroupName?.applyValue({ args0 -> args0 }))
            .organizationUnit(organizationUnit?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkConnectionArgs].
 */
@PulumiTagMarker
public class NetworkConnectionArgsBuilder internal constructor() {
    private var domainJoinType: Output<Either<String, DomainJoinType>>? = null

    private var domainName: Output<String>? = null

    private var domainPassword: Output<String>? = null

    private var domainUsername: Output<String>? = null

    private var location: Output<String>? = null

    private var networkConnectionName: Output<String>? = null

    private var networkingResourceGroupName: Output<String>? = null

    private var organizationUnit: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value AAD Join type.
     */
    @JvmName("xxawmdiwbgoajqvt")
    public suspend fun domainJoinType(`value`: Output<Either<String, DomainJoinType>>) {
        this.domainJoinType = value
    }

    /**
     * @param value Active Directory domain name
     */
    @JvmName("qecwggymlotjnstk")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The password for the account used to join domain
     */
    @JvmName("ndnpoldirneohixw")
    public suspend fun domainPassword(`value`: Output<String>) {
        this.domainPassword = value
    }

    /**
     * @param value The username of an Active Directory account (user or service account) that has permissions to create computer objects in Active Directory. Required format: admin@contoso.com.
     */
    @JvmName("ktcnrifagqxqsvqe")
    public suspend fun domainUsername(`value`: Output<String>) {
        this.domainUsername = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("exeekhcpdiipoqbx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Network Connection that can be applied to a Pool.
     */
    @JvmName("xdgphayenigedjhw")
    public suspend fun networkConnectionName(`value`: Output<String>) {
        this.networkConnectionName = value
    }

    /**
     * @param value The name for resource group where NICs will be placed.
     */
    @JvmName("cctbtlpwjkqggrlc")
    public suspend fun networkingResourceGroupName(`value`: Output<String>) {
        this.networkingResourceGroupName = value
    }

    /**
     * @param value Active Directory domain Organization Unit (OU)
     */
    @JvmName("tnbqhgsglxpwvxfb")
    public suspend fun organizationUnit(`value`: Output<String>) {
        this.organizationUnit = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xqtdvibumktkiqcm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The subnet to attach Virtual Machines to
     */
    @JvmName("rmpuxwueucvibyim")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gbupaxqyolpjptga")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value AAD Join type.
     */
    @JvmName("fkctejcodmdtsnus")
    public suspend fun domainJoinType(`value`: Either<String, DomainJoinType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainJoinType = mapped
    }

    /**
     * @param value AAD Join type.
     */
    @JvmName("xfxprgvqhtnnarhx")
    public fun domainJoinType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DomainJoinType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainJoinType = mapped
    }

    /**
     * @param value AAD Join type.
     */
    @JvmName("vofyaowflmldtdpf")
    public fun domainJoinType(`value`: DomainJoinType) {
        val toBeMapped = Either.ofRight<String, DomainJoinType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainJoinType = mapped
    }

    /**
     * @param value Active Directory domain name
     */
    @JvmName("ybtccqdlvisuvshr")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The password for the account used to join domain
     */
    @JvmName("swuwbckgvnagcock")
    public suspend fun domainPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainPassword = mapped
    }

    /**
     * @param value The username of an Active Directory account (user or service account) that has permissions to create computer objects in Active Directory. Required format: admin@contoso.com.
     */
    @JvmName("wtyxvyegwkgfotlb")
    public suspend fun domainUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainUsername = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mfaqenllnfiyaxhr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Network Connection that can be applied to a Pool.
     */
    @JvmName("wywyyrpytavvhfpc")
    public suspend fun networkConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConnectionName = mapped
    }

    /**
     * @param value The name for resource group where NICs will be placed.
     */
    @JvmName("usjtypluyhvaukti")
    public suspend fun networkingResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkingResourceGroupName = mapped
    }

    /**
     * @param value Active Directory domain Organization Unit (OU)
     */
    @JvmName("kerjbukybuwtcvui")
    public suspend fun organizationUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationUnit = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dtnkuyvvhividysn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The subnet to attach Virtual Machines to
     */
    @JvmName("adlxedhxarubbjav")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("haqwgqwrtsmexgfp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nvdllwcbdtiyloyp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkConnectionArgs = NetworkConnectionArgs(
        domainJoinType = domainJoinType,
        domainName = domainName,
        domainPassword = domainPassword,
        domainUsername = domainUsername,
        location = location,
        networkConnectionName = networkConnectionName,
        networkingResourceGroupName = networkingResourceGroupName,
        organizationUnit = organizationUnit,
        resourceGroupName = resourceGroupName,
        subnetId = subnetId,
        tags = tags,
    )
}
