@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.HealthStatusDetailResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.StopOnDisconnectConfigurationResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.devcenter.kotlin.outputs.HealthStatusDetailResponse.Companion.toKotlin as healthStatusDetailResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.StopOnDisconnectConfigurationResponse.Companion.toKotlin as stopOnDisconnectConfigurationResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Pool].
 */
@PulumiTagMarker
public class PoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PoolArgs = PoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PoolArgsBuilder.() -> Unit) {
        val builder = PoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Pool {
        val builtJavaResource = com.pulumi.azurenative.devcenter.Pool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pool(builtJavaResource)
    }
}

/**
 * A pool of Virtual Machines.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Pools_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.DevCenter.Pool("pool", new()
 *     {
 *         DevBoxDefinitionName = "WebDevBox",
 *         LicenseType = AzureNative.DevCenter.LicenseType.Windows_Client,
 *         LocalAdministrator = AzureNative.DevCenter.LocalAdminStatus.Enabled,
 *         Location = "centralus",
 *         NetworkConnectionName = "Network1-westus2",
 *         PoolName = "DevPool",
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *         StopOnDisconnect = new AzureNative.DevCenter.Inputs.StopOnDisconnectConfigurationArgs
 *         {
 *             GracePeriodMinutes = 60,
 *             Status = AzureNative.DevCenter.StopOnDisconnectEnableStatus.Enabled,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewPool(ctx, "pool", &devcenter.PoolArgs{
 * 			DevBoxDefinitionName:  pulumi.String("WebDevBox"),
 * 			LicenseType:           pulumi.String(devcenter.LicenseType_Windows_Client),
 * 			LocalAdministrator:    pulumi.String(devcenter.LocalAdminStatusEnabled),
 * 			Location:              pulumi.String("centralus"),
 * 			NetworkConnectionName: pulumi.String("Network1-westus2"),
 * 			PoolName:              pulumi.String("DevPool"),
 * 			ProjectName:           pulumi.String("DevProject"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			StopOnDisconnect: &devcenter.StopOnDisconnectConfigurationArgs{
 * 				GracePeriodMinutes: pulumi.Int(60),
 * 				Status:             pulumi.String(devcenter.StopOnDisconnectEnableStatusEnabled),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Pool;
 * import com.pulumi.azurenative.devcenter.PoolArgs;
 * import com.pulumi.azurenative.devcenter.inputs.StopOnDisconnectConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .devBoxDefinitionName("WebDevBox")
 *             .licenseType("Windows_Client")
 *             .localAdministrator("Enabled")
 *             .location("centralus")
 *             .networkConnectionName("Network1-westus2")
 *             .poolName("DevPool")
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .stopOnDisconnect(StopOnDisconnectConfigurationArgs.builder()
 *                 .gracePeriodMinutes(60)
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Pool DevPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/pools/{poolName}
 * ```
 */
public class Pool internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.Pool,
) : KotlinCustomResource(javaResource, PoolMapper) {
    /**
     * Name of a Dev Box definition in parent Project of this Pool
     */
    public val devBoxDefinitionName: Output<String>
        get() = javaResource.devBoxDefinitionName().applyValue({ args0 -> args0 })

    /**
     * Overall health status of the Pool. Indicates whether or not the Pool is available to create Dev Boxes.
     */
    public val healthStatus: Output<String>
        get() = javaResource.healthStatus().applyValue({ args0 -> args0 })

    /**
     * Details on the Pool health status to help diagnose issues. This is only populated when the pool status indicates the pool is in a non-healthy state
     */
    public val healthStatusDetails: Output<List<HealthStatusDetailResponse>>
        get() = javaResource.healthStatusDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> healthStatusDetailResponseToKotlin(args0) })
            })
        })

    /**
     * Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
     */
    public val licenseType: Output<String>
        get() = javaResource.licenseType().applyValue({ args0 -> args0 })

    /**
     * Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
     */
    public val localAdministrator: Output<String>
        get() = javaResource.localAdministrator().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name of a Network Connection in parent Project of this Pool
     */
    public val networkConnectionName: Output<String>
        get() = javaResource.networkConnectionName().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Stop on disconnect configuration settings for Dev Boxes created in this pool.
     */
    public val stopOnDisconnect: Output<StopOnDisconnectConfigurationResponse>?
        get() = javaResource.stopOnDisconnect().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stopOnDisconnectConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PoolMapper : ResourceMapper<Pool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.Pool::class == javaResource::class

    override fun map(javaResource: Resource): Pool = Pool(
        javaResource as
            com.pulumi.azurenative.devcenter.Pool,
    )
}

/**
 * @see [Pool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pool].
 */
public suspend fun pool(name: String, block: suspend PoolResourceBuilder.() -> Unit): Pool {
    val builder = PoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pool(name: String): Pool {
    val builder = PoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
