@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.PoolArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.LicenseType
import com.pulumi.azurenative.devcenter.kotlin.enums.LocalAdminStatus
import com.pulumi.azurenative.devcenter.kotlin.inputs.StopOnDisconnectConfigurationArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.StopOnDisconnectConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A pool of Virtual Machines.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Pools_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.DevCenter.Pool("pool", new()
 *     {
 *         DevBoxDefinitionName = "WebDevBox",
 *         LicenseType = AzureNative.DevCenter.LicenseType.Windows_Client,
 *         LocalAdministrator = AzureNative.DevCenter.LocalAdminStatus.Enabled,
 *         Location = "centralus",
 *         NetworkConnectionName = "Network1-westus2",
 *         PoolName = "DevPool",
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *         StopOnDisconnect = new AzureNative.DevCenter.Inputs.StopOnDisconnectConfigurationArgs
 *         {
 *             GracePeriodMinutes = 60,
 *             Status = AzureNative.DevCenter.StopOnDisconnectEnableStatus.Enabled,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewPool(ctx, "pool", &devcenter.PoolArgs{
 * 			DevBoxDefinitionName:  pulumi.String("WebDevBox"),
 * 			LicenseType:           pulumi.String(devcenter.LicenseType_Windows_Client),
 * 			LocalAdministrator:    pulumi.String(devcenter.LocalAdminStatusEnabled),
 * 			Location:              pulumi.String("centralus"),
 * 			NetworkConnectionName: pulumi.String("Network1-westus2"),
 * 			PoolName:              pulumi.String("DevPool"),
 * 			ProjectName:           pulumi.String("DevProject"),
 * 			ResourceGroupName:     pulumi.String("rg1"),
 * 			StopOnDisconnect: &devcenter.StopOnDisconnectConfigurationArgs{
 * 				GracePeriodMinutes: pulumi.Int(60),
 * 				Status:             pulumi.String(devcenter.StopOnDisconnectEnableStatusEnabled),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Pool;
 * import com.pulumi.azurenative.devcenter.PoolArgs;
 * import com.pulumi.azurenative.devcenter.inputs.StopOnDisconnectConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .devBoxDefinitionName("WebDevBox")
 *             .licenseType("Windows_Client")
 *             .localAdministrator("Enabled")
 *             .location("centralus")
 *             .networkConnectionName("Network1-westus2")
 *             .poolName("DevPool")
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .stopOnDisconnect(StopOnDisconnectConfigurationArgs.builder()
 *                 .gracePeriodMinutes(60)
 *                 .status("Enabled")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Pool DevPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/pools/{poolName}
 * ```
 * @property devBoxDefinitionName Name of a Dev Box definition in parent Project of this Pool
 * @property licenseType Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
 * @property localAdministrator Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
 * @property location The geo-location where the resource lives
 * @property networkConnectionName Name of a Network Connection in parent Project of this Pool
 * @property poolName Name of the pool.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property stopOnDisconnect Stop on disconnect configuration settings for Dev Boxes created in this pool.
 * @property tags Resource tags.
 */
public data class PoolArgs(
    public val devBoxDefinitionName: Output<String>? = null,
    public val licenseType: Output<Either<String, LicenseType>>? = null,
    public val localAdministrator: Output<Either<String, LocalAdminStatus>>? = null,
    public val location: Output<String>? = null,
    public val networkConnectionName: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val stopOnDisconnect: Output<StopOnDisconnectConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.PoolArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.PoolArgs =
        com.pulumi.azurenative.devcenter.PoolArgs.builder()
            .devBoxDefinitionName(devBoxDefinitionName?.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .localAdministrator(
                localAdministrator?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .networkConnectionName(networkConnectionName?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .stopOnDisconnect(stopOnDisconnect?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PoolArgs].
 */
@PulumiTagMarker
public class PoolArgsBuilder internal constructor() {
    private var devBoxDefinitionName: Output<String>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    private var localAdministrator: Output<Either<String, LocalAdminStatus>>? = null

    private var location: Output<String>? = null

    private var networkConnectionName: Output<String>? = null

    private var poolName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var stopOnDisconnect: Output<StopOnDisconnectConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of a Dev Box definition in parent Project of this Pool
     */
    @JvmName("jqiksgijrdaflych")
    public suspend fun devBoxDefinitionName(`value`: Output<String>) {
        this.devBoxDefinitionName = value
    }

    /**
     * @param value Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
     */
    @JvmName("etknshcufmtvsvwg")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
     */
    @JvmName("ocbsidkywohnkrdg")
    public suspend fun localAdministrator(`value`: Output<Either<String, LocalAdminStatus>>) {
        this.localAdministrator = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wbjwnyiexoormyhu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of a Network Connection in parent Project of this Pool
     */
    @JvmName("yfyjclhhxgmmclmg")
    public suspend fun networkConnectionName(`value`: Output<String>) {
        this.networkConnectionName = value
    }

    /**
     * @param value Name of the pool.
     */
    @JvmName("fcshnukksucetday")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("xgphpqqkmpmufexh")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pptytduuudemrtud")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Stop on disconnect configuration settings for Dev Boxes created in this pool.
     */
    @JvmName("idraevgseajqarxj")
    public suspend fun stopOnDisconnect(`value`: Output<StopOnDisconnectConfigurationArgs>) {
        this.stopOnDisconnect = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hhpwvddmonrmskok")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of a Dev Box definition in parent Project of this Pool
     */
    @JvmName("fnsfonxthoekytkk")
    public suspend fun devBoxDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devBoxDefinitionName = mapped
    }

    /**
     * @param value Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
     */
    @JvmName("hvkqiqifycacoero")
    public suspend fun licenseType(`value`: Either<String, LicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
     */
    @JvmName("mcahchoaxtjdwrbk")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
     */
    @JvmName("cicqdjfwqdctolem")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
     */
    @JvmName("wfjahtkdjlyavbiy")
    public suspend fun localAdministrator(`value`: Either<String, LocalAdminStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localAdministrator = mapped
    }

    /**
     * @param value Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
     */
    @JvmName("rwmhdplkuioasstq")
    public fun localAdministrator(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LocalAdminStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localAdministrator = mapped
    }

    /**
     * @param value Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
     */
    @JvmName("gdybrhhisebnabfy")
    public fun localAdministrator(`value`: LocalAdminStatus) {
        val toBeMapped = Either.ofRight<String, LocalAdminStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localAdministrator = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lvlipuwdhicegrim")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of a Network Connection in parent Project of this Pool
     */
    @JvmName("kbcaisgfeuiukyhc")
    public suspend fun networkConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConnectionName = mapped
    }

    /**
     * @param value Name of the pool.
     */
    @JvmName("qwpobrjkwtqipyad")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("rgxmxlabqguukjcs")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("anlughybcifgefjg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Stop on disconnect configuration settings for Dev Boxes created in this pool.
     */
    @JvmName("fpxaiyahicymwnpn")
    public suspend fun stopOnDisconnect(`value`: StopOnDisconnectConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopOnDisconnect = mapped
    }

    /**
     * @param argument Stop on disconnect configuration settings for Dev Boxes created in this pool.
     */
    @JvmName("kspsnsyvwauxwsip")
    public suspend
    fun stopOnDisconnect(argument: suspend StopOnDisconnectConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StopOnDisconnectConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stopOnDisconnect = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hjingavmpnoiarwq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gssqgcabsriesmpl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PoolArgs = PoolArgs(
        devBoxDefinitionName = devBoxDefinitionName,
        licenseType = licenseType,
        localAdministrator = localAdministrator,
        location = location,
        networkConnectionName = networkConnectionName,
        poolName = poolName,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        stopOnDisconnect = stopOnDisconnect,
        tags = tags,
    )
}
