@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.GitCatalogResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SyncStatsResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devcenter.kotlin.outputs.GitCatalogResponse.Companion.toKotlin as gitCatalogResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SyncStatsResponse.Companion.toKotlin as syncStatsResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ProjectCatalog].
 */
@PulumiTagMarker
public class ProjectCatalogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectCatalogArgs = ProjectCatalogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectCatalogArgsBuilder.() -> Unit) {
        val builder = ProjectCatalogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProjectCatalog {
        val builtJavaResource = com.pulumi.azurenative.devcenter.ProjectCatalog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProjectCatalog(builtJavaResource)
    }
}

/**
 * Represents a catalog.
 * Azure REST API version: 2024-02-01.
 * ## Example Usage
 * ### ProjectCatalogs_CreateOrUpdateAdo
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var projectCatalog = new AzureNative.DevCenter.ProjectCatalog("projectCatalog", new()
 *     {
 *         AdoGit = new AzureNative.DevCenter.Inputs.GitCatalogArgs
 *         {
 *             Branch = "main",
 *             Path = "/templates",
 *             SecretIdentifier = "https://contosokv.vault.azure.net/secrets/CentralRepoPat",
 *             Uri = "https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso",
 *         },
 *         CatalogName = "CentralCatalog",
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewProjectCatalog(ctx, "projectCatalog", &devcenter.ProjectCatalogArgs{
 * 			AdoGit: &devcenter.GitCatalogArgs{
 * 				Branch:           pulumi.String("main"),
 * 				Path:             pulumi.String("/templates"),
 * 				SecretIdentifier: pulumi.String("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 * 				Uri:              pulumi.String("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso"),
 * 			},
 * 			CatalogName:       pulumi.String("CentralCatalog"),
 * 			ProjectName:       pulumi.String("DevProject"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.ProjectCatalog;
 * import com.pulumi.azurenative.devcenter.ProjectCatalogArgs;
 * import com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var projectCatalog = new ProjectCatalog("projectCatalog", ProjectCatalogArgs.builder()
 *             .adoGit(GitCatalogArgs.builder()
 *                 .branch("main")
 *                 .path("/templates")
 *                 .secretIdentifier("https://contosokv.vault.azure.net/secrets/CentralRepoPat")
 *                 .uri("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso")
 *                 .build())
 *             .catalogName("CentralCatalog")
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### ProjectCatalogs_CreateOrUpdateGitHub
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var projectCatalog = new AzureNative.DevCenter.ProjectCatalog("projectCatalog", new()
 *     {
 *         CatalogName = "CentralCatalog",
 *         GitHub = new AzureNative.DevCenter.Inputs.GitCatalogArgs
 *         {
 *             Branch = "main",
 *             Path = "/templates",
 *             SecretIdentifier = "https://contosokv.vault.azure.net/secrets/CentralRepoPat",
 *             Uri = "https://github.com/Contoso/centralrepo-fake.git",
 *         },
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewProjectCatalog(ctx, "projectCatalog", &devcenter.ProjectCatalogArgs{
 * 			CatalogName: pulumi.String("CentralCatalog"),
 * 			GitHub: &devcenter.GitCatalogArgs{
 * 				Branch:           pulumi.String("main"),
 * 				Path:             pulumi.String("/templates"),
 * 				SecretIdentifier: pulumi.String("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 * 				Uri:              pulumi.String("https://github.com/Contoso/centralrepo-fake.git"),
 * 			},
 * 			ProjectName:       pulumi.String("DevProject"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.ProjectCatalog;
 * import com.pulumi.azurenative.devcenter.ProjectCatalogArgs;
 * import com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var projectCatalog = new ProjectCatalog("projectCatalog", ProjectCatalogArgs.builder()
 *             .catalogName("CentralCatalog")
 *             .gitHub(GitCatalogArgs.builder()
 *                 .branch("main")
 *                 .path("/templates")
 *                 .secretIdentifier("https://contosokv.vault.azure.net/secrets/CentralRepoPat")
 *                 .uri("https://github.com/Contoso/centralrepo-fake.git")
 *                 .build())
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:ProjectCatalog CentralCatalog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/catalogs/{catalogName}
 * ```
 */
public class ProjectCatalog internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.ProjectCatalog,
) : KotlinCustomResource(javaResource, ProjectCatalogMapper) {
    /**
     * Properties for an Azure DevOps catalog type.
     */
    public val adoGit: Output<GitCatalogResponse>?
        get() = javaResource.adoGit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gitCatalogResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The connection state of the catalog.
     */
    public val connectionState: Output<String>
        get() = javaResource.connectionState().applyValue({ args0 -> args0 })

    /**
     * Properties for a GitHub catalog type.
     */
    public val gitHub: Output<GitCatalogResponse>?
        get() = javaResource.gitHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gitCatalogResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * When the catalog was last connected.
     */
    public val lastConnectionTime: Output<String>
        get() = javaResource.lastConnectionTime().applyValue({ args0 -> args0 })

    /**
     * Stats of the latest synchronization.
     */
    public val lastSyncStats: Output<SyncStatsResponse>
        get() = javaResource.lastSyncStats().applyValue({ args0 ->
            args0.let({ args0 ->
                syncStatsResponseToKotlin(args0)
            })
        })

    /**
     * When the catalog was last synced.
     */
    public val lastSyncTime: Output<String>
        get() = javaResource.lastSyncTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The synchronization state of the catalog.
     */
    public val syncState: Output<String>
        get() = javaResource.syncState().applyValue({ args0 -> args0 })

    /**
     * Indicates the type of sync that is configured for the catalog.
     */
    public val syncType: Output<String>?
        get() = javaResource.syncType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProjectCatalogMapper : ResourceMapper<ProjectCatalog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.ProjectCatalog::class == javaResource::class

    override fun map(javaResource: Resource): ProjectCatalog = ProjectCatalog(
        javaResource as
            com.pulumi.azurenative.devcenter.ProjectCatalog,
    )
}

/**
 * @see [ProjectCatalog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProjectCatalog].
 */
public suspend fun projectCatalog(
    name: String,
    block: suspend ProjectCatalogResourceBuilder.() -> Unit,
): ProjectCatalog {
    val builder = ProjectCatalogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProjectCatalog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun projectCatalog(name: String): ProjectCatalog {
    val builder = ProjectCatalogResourceBuilder()
    builder.name(name)
    return builder.build()
}
