@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.ProjectCatalogArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.CatalogSyncType
import com.pulumi.azurenative.devcenter.kotlin.inputs.GitCatalogArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.GitCatalogArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a catalog.
 * Azure REST API version: 2024-02-01.
 * ## Example Usage
 * ### ProjectCatalogs_CreateOrUpdateAdo
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var projectCatalog = new AzureNative.DevCenter.ProjectCatalog("projectCatalog", new()
 *     {
 *         AdoGit = new AzureNative.DevCenter.Inputs.GitCatalogArgs
 *         {
 *             Branch = "main",
 *             Path = "/templates",
 *             SecretIdentifier = "https://contosokv.vault.azure.net/secrets/CentralRepoPat",
 *             Uri = "https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso",
 *         },
 *         CatalogName = "CentralCatalog",
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewProjectCatalog(ctx, "projectCatalog", &devcenter.ProjectCatalogArgs{
 * 			AdoGit: &devcenter.GitCatalogArgs{
 * 				Branch:           pulumi.String("main"),
 * 				Path:             pulumi.String("/templates"),
 * 				SecretIdentifier: pulumi.String("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 * 				Uri:              pulumi.String("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso"),
 * 			},
 * 			CatalogName:       pulumi.String("CentralCatalog"),
 * 			ProjectName:       pulumi.String("DevProject"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.ProjectCatalog;
 * import com.pulumi.azurenative.devcenter.ProjectCatalogArgs;
 * import com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var projectCatalog = new ProjectCatalog("projectCatalog", ProjectCatalogArgs.builder()
 *             .adoGit(GitCatalogArgs.builder()
 *                 .branch("main")
 *                 .path("/templates")
 *                 .secretIdentifier("https://contosokv.vault.azure.net/secrets/CentralRepoPat")
 *                 .uri("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso")
 *                 .build())
 *             .catalogName("CentralCatalog")
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### ProjectCatalogs_CreateOrUpdateGitHub
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var projectCatalog = new AzureNative.DevCenter.ProjectCatalog("projectCatalog", new()
 *     {
 *         CatalogName = "CentralCatalog",
 *         GitHub = new AzureNative.DevCenter.Inputs.GitCatalogArgs
 *         {
 *             Branch = "main",
 *             Path = "/templates",
 *             SecretIdentifier = "https://contosokv.vault.azure.net/secrets/CentralRepoPat",
 *             Uri = "https://github.com/Contoso/centralrepo-fake.git",
 *         },
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewProjectCatalog(ctx, "projectCatalog", &devcenter.ProjectCatalogArgs{
 * 			CatalogName: pulumi.String("CentralCatalog"),
 * 			GitHub: &devcenter.GitCatalogArgs{
 * 				Branch:           pulumi.String("main"),
 * 				Path:             pulumi.String("/templates"),
 * 				SecretIdentifier: pulumi.String("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 * 				Uri:              pulumi.String("https://github.com/Contoso/centralrepo-fake.git"),
 * 			},
 * 			ProjectName:       pulumi.String("DevProject"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.ProjectCatalog;
 * import com.pulumi.azurenative.devcenter.ProjectCatalogArgs;
 * import com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var projectCatalog = new ProjectCatalog("projectCatalog", ProjectCatalogArgs.builder()
 *             .catalogName("CentralCatalog")
 *             .gitHub(GitCatalogArgs.builder()
 *                 .branch("main")
 *                 .path("/templates")
 *                 .secretIdentifier("https://contosokv.vault.azure.net/secrets/CentralRepoPat")
 *                 .uri("https://github.com/Contoso/centralrepo-fake.git")
 *                 .build())
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:ProjectCatalog CentralCatalog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/catalogs/{catalogName}
 * ```
 * @property adoGit Properties for an Azure DevOps catalog type.
 * @property catalogName The name of the Catalog.
 * @property gitHub Properties for a GitHub catalog type.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property syncType Indicates the type of sync that is configured for the catalog.
 * @property tags Resource tags.
 */
public data class ProjectCatalogArgs(
    public val adoGit: Output<GitCatalogArgs>? = null,
    public val catalogName: Output<String>? = null,
    public val gitHub: Output<GitCatalogArgs>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val syncType: Output<Either<String, CatalogSyncType>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.ProjectCatalogArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.ProjectCatalogArgs =
        com.pulumi.azurenative.devcenter.ProjectCatalogArgs.builder()
            .adoGit(adoGit?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .catalogName(catalogName?.applyValue({ args0 -> args0 }))
            .gitHub(gitHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .syncType(
                syncType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProjectCatalogArgs].
 */
@PulumiTagMarker
public class ProjectCatalogArgsBuilder internal constructor() {
    private var adoGit: Output<GitCatalogArgs>? = null

    private var catalogName: Output<String>? = null

    private var gitHub: Output<GitCatalogArgs>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var syncType: Output<Either<String, CatalogSyncType>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Properties for an Azure DevOps catalog type.
     */
    @JvmName("kltujfejkcfmwhbw")
    public suspend fun adoGit(`value`: Output<GitCatalogArgs>) {
        this.adoGit = value
    }

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("lgrbbunpqdmmkgmv")
    public suspend fun catalogName(`value`: Output<String>) {
        this.catalogName = value
    }

    /**
     * @param value Properties for a GitHub catalog type.
     */
    @JvmName("rkntukhvmudeyjat")
    public suspend fun gitHub(`value`: Output<GitCatalogArgs>) {
        this.gitHub = value
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("horakerdighfvgsw")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("joqwaykxjhiflkpl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Indicates the type of sync that is configured for the catalog.
     */
    @JvmName("ewmkvbdoddtpxiwo")
    public suspend fun syncType(`value`: Output<Either<String, CatalogSyncType>>) {
        this.syncType = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("abpvujeniovmakch")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Properties for an Azure DevOps catalog type.
     */
    @JvmName("lovrbemsjphettdj")
    public suspend fun adoGit(`value`: GitCatalogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adoGit = mapped
    }

    /**
     * @param argument Properties for an Azure DevOps catalog type.
     */
    @JvmName("nhpnuquaelyiajoy")
    public suspend fun adoGit(argument: suspend GitCatalogArgsBuilder.() -> Unit) {
        val toBeMapped = GitCatalogArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.adoGit = mapped
    }

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("rcfvtosnxfrgwimv")
    public suspend fun catalogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogName = mapped
    }

    /**
     * @param value Properties for a GitHub catalog type.
     */
    @JvmName("tafttbckkbhlpbhg")
    public suspend fun gitHub(`value`: GitCatalogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitHub = mapped
    }

    /**
     * @param argument Properties for a GitHub catalog type.
     */
    @JvmName("xamjbjskkvrmygyb")
    public suspend fun gitHub(argument: suspend GitCatalogArgsBuilder.() -> Unit) {
        val toBeMapped = GitCatalogArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gitHub = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("vxswhjsgkvmffmqs")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yojsxlfyrtsicbjr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Indicates the type of sync that is configured for the catalog.
     */
    @JvmName("saxfudokcwuyoiua")
    public suspend fun syncType(`value`: Either<String, CatalogSyncType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncType = mapped
    }

    /**
     * @param value Indicates the type of sync that is configured for the catalog.
     */
    @JvmName("nxitrcihsurpygvr")
    public fun syncType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CatalogSyncType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncType = mapped
    }

    /**
     * @param value Indicates the type of sync that is configured for the catalog.
     */
    @JvmName("fieimppysfeyigwu")
    public fun syncType(`value`: CatalogSyncType) {
        val toBeMapped = Either.ofRight<String, CatalogSyncType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncType = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wkdkraqqubgunqyk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xxdhtwkqngdbnlbc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProjectCatalogArgs = ProjectCatalogArgs(
        adoGit = adoGit,
        catalogName = catalogName,
        gitHub = gitHub,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        syncType = syncType,
        tags = tags,
    )
}
