@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource = com.pulumi.azurenative.devcenter.Schedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schedule(builtJavaResource)
    }
}

/**
 * Represents a Schedule to execute a task.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Schedules_CreateDailyShutdownPoolSchedule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.DevCenter.Schedule("schedule", new()
 *     {
 *         Frequency = AzureNative.DevCenter.ScheduledFrequency.Daily,
 *         PoolName = "DevPool",
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *         ScheduleName = "autoShutdown",
 *         State = AzureNative.DevCenter.ScheduleEnableStatus.Enabled,
 *         Time = "17:30",
 *         TimeZone = "America/Los_Angeles",
 *         Type = AzureNative.DevCenter.ScheduledType.StopDevBox,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewSchedule(ctx, "schedule", &devcenter.ScheduleArgs{
 * 			Frequency:         pulumi.String(devcenter.ScheduledFrequencyDaily),
 * 			PoolName:          pulumi.String("DevPool"),
 * 			ProjectName:       pulumi.String("DevProject"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ScheduleName:      pulumi.String("autoShutdown"),
 * 			State:             pulumi.String(devcenter.ScheduleEnableStatusEnabled),
 * 			Time:              pulumi.String("17:30"),
 * 			TimeZone:          pulumi.String("America/Los_Angeles"),
 * 			Type:              pulumi.String(devcenter.ScheduledTypeStopDevBox),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Schedule;
 * import com.pulumi.azurenative.devcenter.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .frequency("Daily")
 *             .poolName("DevPool")
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .scheduleName("autoShutdown")
 *             .state("Enabled")
 *             .time("17:30")
 *             .timeZone("America/Los_Angeles")
 *             .type("StopDevBox")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Schedule autoShutdown /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/pools/{poolName}/schedules/{scheduleName}
 * ```
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    /**
     * The frequency of this scheduled task.
     */
    public val frequency: Output<String>
        get() = javaResource.frequency().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Indicates whether or not this scheduled task is enabled.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The target time to trigger the action. The format is HH:MM.
     */
    public val time: Output<String>
        get() = javaResource.time().applyValue({ args0 -> args0 })

    /**
     * The IANA timezone id at which the schedule should execute.
     */
    public val timeZone: Output<String>
        get() = javaResource.timeZone().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.azurenative.devcenter.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit):
    Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
