@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.ScheduleArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.ScheduleEnableStatus
import com.pulumi.azurenative.devcenter.kotlin.enums.ScheduledFrequency
import com.pulumi.azurenative.devcenter.kotlin.enums.ScheduledType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a Schedule to execute a task.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview, 2024-02-01.
 * ## Example Usage
 * ### Schedules_CreateDailyShutdownPoolSchedule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var schedule = new AzureNative.DevCenter.Schedule("schedule", new()
 *     {
 *         Frequency = AzureNative.DevCenter.ScheduledFrequency.Daily,
 *         PoolName = "DevPool",
 *         ProjectName = "DevProject",
 *         ResourceGroupName = "rg1",
 *         ScheduleName = "autoShutdown",
 *         State = AzureNative.DevCenter.ScheduleEnableStatus.Enabled,
 *         Time = "17:30",
 *         TimeZone = "America/Los_Angeles",
 *         Type = AzureNative.DevCenter.ScheduledType.StopDevBox,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewSchedule(ctx, "schedule", &devcenter.ScheduleArgs{
 * 			Frequency:         pulumi.String(devcenter.ScheduledFrequencyDaily),
 * 			PoolName:          pulumi.String("DevPool"),
 * 			ProjectName:       pulumi.String("DevProject"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ScheduleName:      pulumi.String("autoShutdown"),
 * 			State:             pulumi.String(devcenter.ScheduleEnableStatusEnabled),
 * 			Time:              pulumi.String("17:30"),
 * 			TimeZone:          pulumi.String("America/Los_Angeles"),
 * 			Type:              pulumi.String(devcenter.ScheduledTypeStopDevBox),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Schedule;
 * import com.pulumi.azurenative.devcenter.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var schedule = new Schedule("schedule", ScheduleArgs.builder()
 *             .frequency("Daily")
 *             .poolName("DevPool")
 *             .projectName("DevProject")
 *             .resourceGroupName("rg1")
 *             .scheduleName("autoShutdown")
 *             .state("Enabled")
 *             .time("17:30")
 *             .timeZone("America/Los_Angeles")
 *             .type("StopDevBox")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Schedule autoShutdown /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}/pools/{poolName}/schedules/{scheduleName}
 * ```
 * @property frequency The frequency of this scheduled task.
 * @property poolName Name of the pool.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scheduleName The name of the schedule that uniquely identifies it.
 * @property state Indicates whether or not this scheduled task is enabled.
 * @property time The target time to trigger the action. The format is HH:MM.
 * @property timeZone The IANA timezone id at which the schedule should execute.
 * @property top The maximum number of resources to return from the operation. Example: '$top=10'.
 * @property type Supported type this scheduled task represents.
 */
public data class ScheduleArgs(
    public val frequency: Output<Either<String, ScheduledFrequency>>? = null,
    public val poolName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduleName: Output<String>? = null,
    public val state: Output<Either<String, ScheduleEnableStatus>>? = null,
    public val time: Output<String>? = null,
    public val timeZone: Output<String>? = null,
    public val top: Output<Int>? = null,
    public val type: Output<Either<String, ScheduledType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.ScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.ScheduleArgs =
        com.pulumi.azurenative.devcenter.ScheduleArgs.builder()
            .frequency(
                frequency?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduleName(scheduleName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .time(time?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 }))
            .top(top?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var frequency: Output<Either<String, ScheduledFrequency>>? = null

    private var poolName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduleName: Output<String>? = null

    private var state: Output<Either<String, ScheduleEnableStatus>>? = null

    private var time: Output<String>? = null

    private var timeZone: Output<String>? = null

    private var top: Output<Int>? = null

    private var type: Output<Either<String, ScheduledType>>? = null

    /**
     * @param value The frequency of this scheduled task.
     */
    @JvmName("wfvgwixqepdwevrv")
    public suspend fun frequency(`value`: Output<Either<String, ScheduledFrequency>>) {
        this.frequency = value
    }

    /**
     * @param value Name of the pool.
     */
    @JvmName("rtyicehoiimsyxdy")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("phwiakdoomonmovw")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xoghsecxntrrbpdi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the schedule that uniquely identifies it.
     */
    @JvmName("uehysswiqypjvgtk")
    public suspend fun scheduleName(`value`: Output<String>) {
        this.scheduleName = value
    }

    /**
     * @param value Indicates whether or not this scheduled task is enabled.
     */
    @JvmName("bmkjglivclsfdyns")
    public suspend fun state(`value`: Output<Either<String, ScheduleEnableStatus>>) {
        this.state = value
    }

    /**
     * @param value The target time to trigger the action. The format is HH:MM.
     */
    @JvmName("eiefartudorrcckb")
    public suspend fun time(`value`: Output<String>) {
        this.time = value
    }

    /**
     * @param value The IANA timezone id at which the schedule should execute.
     */
    @JvmName("gaamomyvfxrffdwy")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value The maximum number of resources to return from the operation. Example: '$top=10'.
     */
    @JvmName("gmdsojpuuptxgrjq")
    public suspend fun top(`value`: Output<Int>) {
        this.top = value
    }

    /**
     * @param value Supported type this scheduled task represents.
     */
    @JvmName("tkttkoplsisrdnjt")
    public suspend fun type(`value`: Output<Either<String, ScheduledType>>) {
        this.type = value
    }

    /**
     * @param value The frequency of this scheduled task.
     */
    @JvmName("yciefniusvllbbbs")
    public suspend fun frequency(`value`: Either<String, ScheduledFrequency>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The frequency of this scheduled task.
     */
    @JvmName("ibopsuosullgqivp")
    public fun frequency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduledFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value The frequency of this scheduled task.
     */
    @JvmName("tvekiemtuqnlnhgh")
    public fun frequency(`value`: ScheduledFrequency) {
        val toBeMapped = Either.ofRight<String, ScheduledFrequency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Name of the pool.
     */
    @JvmName("auvbhruasqsyxsbw")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("ghnlrksuagkoxpke")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nqpwcfkurwmxyxwm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the schedule that uniquely identifies it.
     */
    @JvmName("amuwvcymaqbsivrk")
    public suspend fun scheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleName = mapped
    }

    /**
     * @param value Indicates whether or not this scheduled task is enabled.
     */
    @JvmName("vitswopwdyfoeujs")
    public suspend fun state(`value`: Either<String, ScheduleEnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Indicates whether or not this scheduled task is enabled.
     */
    @JvmName("jjcbsarollexawvb")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduleEnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Indicates whether or not this scheduled task is enabled.
     */
    @JvmName("caqptulobeiqrxtm")
    public fun state(`value`: ScheduleEnableStatus) {
        val toBeMapped = Either.ofRight<String, ScheduleEnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The target time to trigger the action. The format is HH:MM.
     */
    @JvmName("ojpvxxlprbtcgxby")
    public suspend fun time(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.time = mapped
    }

    /**
     * @param value The IANA timezone id at which the schedule should execute.
     */
    @JvmName("jfclijnfoepkxgmw")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    /**
     * @param value The maximum number of resources to return from the operation. Example: '$top=10'.
     */
    @JvmName("fludvabkxlmogdrj")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.top = mapped
    }

    /**
     * @param value Supported type this scheduled task represents.
     */
    @JvmName("jrvjuakcviktnowq")
    public suspend fun type(`value`: Either<String, ScheduledType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Supported type this scheduled task represents.
     */
    @JvmName("ayclhapqvddnyjhq")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ScheduledType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Supported type this scheduled task represents.
     */
    @JvmName("vwmiuyetoncbkrkn")
    public fun type(`value`: ScheduledType) {
        val toBeMapped = Either.ofRight<String, ScheduledType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        frequency = frequency,
        poolName = poolName,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        scheduleName = scheduleName,
        state = state,
        time = time,
        timeZone = timeZone,
        top = top,
        type = type,
    )
}
