@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate
 */
public enum class HibernateSupport(
    public val javaValue: com.pulumi.azurenative.devcenter.enums.HibernateSupport,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.enums.HibernateSupport> {
    Disabled(com.pulumi.azurenative.devcenter.enums.HibernateSupport.Disabled),
    Enabled(com.pulumi.azurenative.devcenter.enums.HibernateSupport.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.devcenter.enums.HibernateSupport = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.enums.HibernateSupport):
            HibernateSupport = HibernateSupport.values().first { it.javaValue == javaType }
    }
}
