@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetDevBoxDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property devBoxDefinitionName The name of the Dev Box definition.
 * @property devCenterName The name of the devcenter.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDevBoxDefinitionPlainArgs(
    public val devBoxDefinitionName: String,
    public val devCenterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetDevBoxDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetDevBoxDefinitionPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetDevBoxDefinitionPlainArgs.builder()
            .devBoxDefinitionName(devBoxDefinitionName.let({ args0 -> args0 }))
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDevBoxDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetDevBoxDefinitionPlainArgsBuilder internal constructor() {
    private var devBoxDefinitionName: String? = null

    private var devCenterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Dev Box definition.
     */
    @JvmName("fufwurjqwjdjdwgm")
    public suspend fun devBoxDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devBoxDefinitionName = mapped
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("dhcoenskkjqdshrv")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wbtkupthdmhqqbox")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDevBoxDefinitionPlainArgs = GetDevBoxDefinitionPlainArgs(
        devBoxDefinitionName = devBoxDefinitionName ?: throw
            PulumiNullFieldException("devBoxDefinitionName"),
        devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
