@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetEnvironmentTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property devCenterName The name of the devcenter.
 * @property environmentTypeName The name of the environment type.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEnvironmentTypePlainArgs(
    public val devCenterName: String,
    public val environmentTypeName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetEnvironmentTypePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetEnvironmentTypePlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetEnvironmentTypePlainArgs.builder()
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .environmentTypeName(environmentTypeName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnvironmentTypePlainArgs].
 */
@PulumiTagMarker
public class GetEnvironmentTypePlainArgsBuilder internal constructor() {
    private var devCenterName: String? = null

    private var environmentTypeName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("sqjrobycfnicvxqy")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the environment type.
     */
    @JvmName("rsnslomglmkhhvuq")
    public suspend fun environmentTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentTypeName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gdtfedlwrismrhyr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEnvironmentTypePlainArgs = GetEnvironmentTypePlainArgs(
        devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
        environmentTypeName = environmentTypeName ?: throw PulumiNullFieldException("environmentTypeName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
