@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetGalleryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property devCenterName The name of the devcenter.
 * @property galleryName The name of the gallery.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGalleryPlainArgs(
    public val devCenterName: String,
    public val galleryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetGalleryPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetGalleryPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetGalleryPlainArgs.builder()
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .galleryName(galleryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGalleryPlainArgs].
 */
@PulumiTagMarker
public class GetGalleryPlainArgsBuilder internal constructor() {
    private var devCenterName: String? = null

    private var galleryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("anwtxnwgqihtwdhs")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the gallery.
     */
    @JvmName("yaseuvuwcrnecyec")
    public suspend fun galleryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dkuupwshofxualpo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGalleryPlainArgs = GetGalleryPlainArgs(
        devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
        galleryName = galleryName ?: throw PulumiNullFieldException("galleryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
