@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName The name of the Catalog.
 * @property environmentDefinitionName The name of the Environment Definition.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs(
    public val catalogName: String,
    public val environmentDefinitionName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.devcenter.inputs.GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .environmentDefinitionName(environmentDefinitionName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgsBuilder internal
constructor() {
    private var catalogName: String? = null

    private var environmentDefinitionName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("uiturmlqberyaffq")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value The name of the Environment Definition.
     */
    @JvmName("lpxngoavpltyijnu")
    public suspend fun environmentDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentDefinitionName = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("bnapratnqxjhwoff")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kigyrsmwaeofjxtf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs =
        GetProjectCatalogEnvironmentDefinitionErrorDetailsPlainArgs(
            catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
            environmentDefinitionName = environmentDefinitionName ?: throw
                PulumiNullFieldException("environmentDefinitionName"),
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
