@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetProjectCatalogPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName The name of the Catalog.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetProjectCatalogPlainArgs(
    public val catalogName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetProjectCatalogPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetProjectCatalogPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetProjectCatalogPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectCatalogPlainArgs].
 */
@PulumiTagMarker
public class GetProjectCatalogPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("iqmxavudoncjysoh")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("heilpqlpguksfnei")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gxnkcyxtvtqtturi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProjectCatalogPlainArgs = GetProjectCatalogPlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
