@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.StopOnDisconnectConfigurationArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.StopOnDisconnectEnableStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Stop on disconnect configuration settings for Dev Boxes created in this pool.
 * @property gracePeriodMinutes The specified time in minutes to wait before stopping a Dev Box once disconnect is detected.
 * @property status Whether the feature to stop the Dev Box on disconnect once the grace period has lapsed is enabled.
 */
public data class StopOnDisconnectConfigurationArgs(
    public val gracePeriodMinutes: Output<Int>? = null,
    public val status: Output<Either<String, StopOnDisconnectEnableStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.StopOnDisconnectConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.StopOnDisconnectConfigurationArgs =
        com.pulumi.azurenative.devcenter.inputs.StopOnDisconnectConfigurationArgs.builder()
            .gracePeriodMinutes(gracePeriodMinutes?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [StopOnDisconnectConfigurationArgs].
 */
@PulumiTagMarker
public class StopOnDisconnectConfigurationArgsBuilder internal constructor() {
    private var gracePeriodMinutes: Output<Int>? = null

    private var status: Output<Either<String, StopOnDisconnectEnableStatus>>? = null

    /**
     * @param value The specified time in minutes to wait before stopping a Dev Box once disconnect is detected.
     */
    @JvmName("dkhgioonrulytjwx")
    public suspend fun gracePeriodMinutes(`value`: Output<Int>) {
        this.gracePeriodMinutes = value
    }

    /**
     * @param value Whether the feature to stop the Dev Box on disconnect once the grace period has lapsed is enabled.
     */
    @JvmName("gurxtisfegskvssw")
    public suspend fun status(`value`: Output<Either<String, StopOnDisconnectEnableStatus>>) {
        this.status = value
    }

    /**
     * @param value The specified time in minutes to wait before stopping a Dev Box once disconnect is detected.
     */
    @JvmName("xetanbxcqyjkfcnk")
    public suspend fun gracePeriodMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gracePeriodMinutes = mapped
    }

    /**
     * @param value Whether the feature to stop the Dev Box on disconnect once the grace period has lapsed is enabled.
     */
    @JvmName("mpxgaswygkyoqcnt")
    public suspend fun status(`value`: Either<String, StopOnDisconnectEnableStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Whether the feature to stop the Dev Box on disconnect once the grace period has lapsed is enabled.
     */
    @JvmName("vasdjacpofhxypqt")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StopOnDisconnectEnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Whether the feature to stop the Dev Box on disconnect once the grace period has lapsed is enabled.
     */
    @JvmName("ixtoqnwkyubhrgvi")
    public fun status(`value`: StopOnDisconnectEnableStatus) {
        val toBeMapped = Either.ofRight<String, StopOnDisconnectEnableStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): StopOnDisconnectConfigurationArgs = StopOnDisconnectConfigurationArgs(
        gracePeriodMinutes = gracePeriodMinutes,
        status = status,
    )
}
