@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Catalog error details
 * @property code An identifier for the error.
 * @property message A message describing the error.
 */
public data class CatalogErrorDetailsResponse(
    public val code: String? = null,
    public val message: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.CatalogErrorDetailsResponse):
            CatalogErrorDetailsResponse = CatalogErrorDetailsResponse(
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
        )
    }
}
