@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents a catalog.
 * @property adoGit Properties for an Azure DevOps catalog type.
 * @property connectionState The connection state of the catalog.
 * @property gitHub Properties for a GitHub catalog type.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property lastConnectionTime When the catalog was last connected.
 * @property lastSyncStats Stats of the latest synchronization.
 * @property lastSyncTime When the catalog was last synced.
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the resource.
 * @property syncState The synchronization state of the catalog.
 * @property syncType Indicates the type of sync that is configured for the catalog.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetProjectCatalogResult(
    public val adoGit: GitCatalogResponse? = null,
    public val connectionState: String,
    public val gitHub: GitCatalogResponse? = null,
    public val id: String,
    public val lastConnectionTime: String,
    public val lastSyncStats: SyncStatsResponse,
    public val lastSyncTime: String,
    public val name: String,
    public val provisioningState: String,
    public val syncState: String,
    public val syncType: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetProjectCatalogResult):
            GetProjectCatalogResult = GetProjectCatalogResult(
            adoGit = javaType.adoGit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.GitCatalogResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionState = javaType.connectionState(),
            gitHub = javaType.gitHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.GitCatalogResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            lastConnectionTime = javaType.lastConnectionTime(),
            lastSyncStats = javaType.lastSyncStats().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SyncStatsResponse.Companion.toKotlin(args0)
            }),
            lastSyncTime = javaType.lastSyncTime(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            syncState = javaType.syncState(),
            syncType = javaType.syncType().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
