@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Synchronization error details.
 * @property conflicts Catalog items that have conflicting names.
 * @property errors Errors that occured during synchronization.
 * @property operationError Error information for the overall synchronization operation.
 */
public data class GetProjectCatalogSyncErrorDetailsResult(
    public val conflicts: List<CatalogConflictErrorResponse>,
    public val errors: List<CatalogSyncErrorResponse>,
    public val operationError: CatalogErrorDetailsResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetProjectCatalogSyncErrorDetailsResult):
            GetProjectCatalogSyncErrorDetailsResult = GetProjectCatalogSyncErrorDetailsResult(
            conflicts = javaType.conflicts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.CatalogConflictErrorResponse.Companion.toKotlin(args0)
                })
            }),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.CatalogSyncErrorResponse.Companion.toKotlin(args0)
                })
            }),
            operationError = javaType.operationError().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.CatalogErrorDetailsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
