@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Stats of the synchronization.
 * @property added Count of catalog items added during synchronization.
 * @property removed Count of catalog items removed during synchronization.
 * @property syncedCatalogItemTypes Indicates catalog item types that were synced.
 * @property synchronizationErrors Count of synchronization errors that occured during synchronization.
 * @property unchanged Count of catalog items that were unchanged during synchronization.
 * @property updated Count of catalog items updated during synchronization.
 * @property validationErrors Count of catalog items that had validation errors during synchronization.
 */
public data class SyncStatsResponse(
    public val added: Int,
    public val removed: Int,
    public val syncedCatalogItemTypes: List<String>? = null,
    public val synchronizationErrors: Int,
    public val unchanged: Int,
    public val updated: Int,
    public val validationErrors: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.SyncStatsResponse):
            SyncStatsResponse = SyncStatsResponse(
            added = javaType.added(),
            removed = javaType.removed(),
            syncedCatalogItemTypes = javaType.syncedCatalogItemTypes().map({ args0 -> args0 }),
            synchronizationErrors = javaType.synchronizationErrors(),
            unchanged = javaType.unchanged(),
            updated = javaType.updated(),
            validationErrors = javaType.validationErrors(),
        )
    }
}
