@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.GetWorkflowPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workflowName The name of the workflow resource.
 */
public data class GetWorkflowPlainArgs(
    public val resourceGroupName: String,
    public val workflowName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.GetWorkflowPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.GetWorkflowPlainArgs =
        com.pulumi.azurenative.devhub.inputs.GetWorkflowPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workflowName(workflowName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkflowPlainArgs].
 */
@PulumiTagMarker
public class GetWorkflowPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workflowName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gjkisgadhjjkfvvi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the workflow resource.
     */
    @JvmName("vvosvbtdacciqvvh")
    public suspend fun workflowName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workflowName = mapped
    }

    internal fun build(): GetWorkflowPlainArgs = GetWorkflowPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workflowName = workflowName ?: throw PulumiNullFieldException("workflowName"),
    )
}
