@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The fields needed for OIDC with GitHub.
 * @property azureClientId Azure Application Client ID
 * @property azureTenantId Azure Directory (tenant) ID
 */
public data class GitHubWorkflowProfileResponseOidcCredentials(
    public val azureClientId: String? = null,
    public val azureTenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.GitHubWorkflowProfileResponseOidcCredentials):
            GitHubWorkflowProfileResponseOidcCredentials = GitHubWorkflowProfileResponseOidcCredentials(
            azureClientId = javaType.azureClientId().map({ args0 -> args0 }).orElse(null),
            azureTenantId = javaType.azureTenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
