@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property lastRunAt The timestamp of the last workflow run.
 * @property succeeded Describes if the workflow run succeeded.
 * @property workflowRunStatus Describes the status of the workflow run
 * @property workflowRunURL URL to the run of the workflow.
 */
public data class WorkflowRunResponse(
    public val lastRunAt: String,
    public val succeeded: Boolean,
    public val workflowRunStatus: String? = null,
    public val workflowRunURL: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.WorkflowRunResponse):
            WorkflowRunResponse = WorkflowRunResponse(
            lastRunAt = javaType.lastRunAt(),
            succeeded = javaType.succeeded(),
            workflowRunStatus = javaType.workflowRunStatus().map({ args0 -> args0 }).orElse(null),
            workflowRunURL = javaType.workflowRunURL(),
        )
    }
}
