@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin

import com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetStatusResponse
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.DataPointResponse
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.EventResponse
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetStatusResponse.Companion.toKotlin as assetStatusResponseToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.DataPointResponse.Companion.toKotlin as dataPointResponseToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.EventResponse.Companion.toKotlin as eventResponseToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Asset].
 */
@PulumiTagMarker
public class AssetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssetArgs = AssetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssetArgsBuilder.() -> Unit) {
        val builder = AssetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Asset {
        val builtJavaResource = com.pulumi.azurenative.deviceregistry.Asset(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Asset(builtJavaResource)
    }
}

/**
 * Asset definition.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### Create an Asset With External Asset Id.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetEndpointProfileUri = "https://www.example.com/myAssetEndpointProfile",
 *         AssetName = "my-asset",
 *         AssetType = "MyAssetType",
 *         DataPoints = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.Counter,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.None,
 *             },
 *         },
 *         DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         Description = "This is a sample Asset",
 *         DisplayName = "AssetDisplayName",
 *         DocumentationUri = "https://www.example.com/manual",
 *         Enabled = true,
 *         Events = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.None,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.Log,
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         ExternalAssetId = "8ZBA6LRHU0A458969",
 *         HardwareRevision = "1.0",
 *         Location = "West Europe",
 *         Manufacturer = "Contoso",
 *         ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *         Model = "ContosoModel",
 *         ProductCode = "SA34VDG",
 *         ResourceGroupName = "myResourceGroup",
 *         SerialNumber = "64-103816-519918-8",
 *         SoftwareRevision = "2.0",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetEndpointProfileUri: pulumi.String("https://www.example.com/myAssetEndpointProfile"),
 * 			AssetName:               pulumi.String("my-asset"),
 * 			AssetType:               pulumi.String("MyAssetType"),
 * 			DataPoints: deviceregistry.DataPointArray{
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeCounter),
 * 				},
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeNone),
 * 				},
 * 			},
 * 			DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			Description:                    pulumi.String("This is a sample Asset"),
 * 			DisplayName:                    pulumi.String("AssetDisplayName"),
 * 			DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 			Enabled:                        pulumi.Bool(true),
 * 			Events: deviceregistry.EventArray{
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeNone),
 * 				},
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeLog),
 * 				},
 * 			},
 * 			ExtendedLocation: &deviceregistry.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			ExternalAssetId:   pulumi.String("8ZBA6LRHU0A458969"),
 * 			HardwareRevision:  pulumi.String("1.0"),
 * 			Location:          pulumi.String("West Europe"),
 * 			Manufacturer:      pulumi.String("Contoso"),
 * 			ManufacturerUri:   pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 			Model:             pulumi.String("ContosoModel"),
 * 			ProductCode:       pulumi.String("SA34VDG"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SerialNumber:      pulumi.String("64-103816-519918-8"),
 * 			SoftwareRevision:  pulumi.String("2.0"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.EventArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetEndpointProfileUri("https://www.example.com/myAssetEndpointProfile")
 *             .assetName("my-asset")
 *             .assetType("MyAssetType")
 *             .dataPoints(
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1")
 *                     .observabilityMode("counter")
 *                     .build(),
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2")
 *                     .observabilityMode("none")
 *                     .build())
 *             .defaultDataPointsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .defaultEventsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .description("This is a sample Asset")
 *             .displayName("AssetDisplayName")
 *             .documentationUri("https://www.example.com/manual")
 *             .enabled(true)
 *             .events(
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3")
 *                     .observabilityMode("none")
 *                     .build(),
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4")
 *                     .observabilityMode("log")
 *                     .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1")
 *                 .type("CustomLocation")
 *                 .build())
 *             .externalAssetId("8ZBA6LRHU0A458969")
 *             .hardwareRevision("1.0")
 *             .location("West Europe")
 *             .manufacturer("Contoso")
 *             .manufacturerUri("https://www.contoso.com/manufacturerUri")
 *             .model("ContosoModel")
 *             .productCode("SA34VDG")
 *             .resourceGroupName("myResourceGroup")
 *             .serialNumber("64-103816-519918-8")
 *             .softwareRevision("2.0")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset Without Display Name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetEndpointProfileUri = "https://www.example.com/myAssetEndpointProfile",
 *         AssetName = "my-asset",
 *         AssetType = "MyAssetType",
 *         DataPoints = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.Counter,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.None,
 *             },
 *         },
 *         DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         Description = "This is a sample Asset",
 *         DocumentationUri = "https://www.example.com/manual",
 *         Enabled = true,
 *         Events = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.None,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.Log,
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         ExternalAssetId = "8ZBA6LRHU0A458969",
 *         HardwareRevision = "1.0",
 *         Location = "West Europe",
 *         Manufacturer = "Contoso",
 *         ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *         Model = "ContosoModel",
 *         ProductCode = "SA34VDG",
 *         ResourceGroupName = "myResourceGroup",
 *         SerialNumber = "64-103816-519918-8",
 *         SoftwareRevision = "2.0",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetEndpointProfileUri: pulumi.String("https://www.example.com/myAssetEndpointProfile"),
 * 			AssetName:               pulumi.String("my-asset"),
 * 			AssetType:               pulumi.String("MyAssetType"),
 * 			DataPoints: deviceregistry.DataPointArray{
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeCounter),
 * 				},
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeNone),
 * 				},
 * 			},
 * 			DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			Description:                    pulumi.String("This is a sample Asset"),
 * 			DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 			Enabled:                        pulumi.Bool(true),
 * 			Events: deviceregistry.EventArray{
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeNone),
 * 				},
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeLog),
 * 				},
 * 			},
 * 			ExtendedLocation: &deviceregistry.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			ExternalAssetId:   pulumi.String("8ZBA6LRHU0A458969"),
 * 			HardwareRevision:  pulumi.String("1.0"),
 * 			Location:          pulumi.String("West Europe"),
 * 			Manufacturer:      pulumi.String("Contoso"),
 * 			ManufacturerUri:   pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 			Model:             pulumi.String("ContosoModel"),
 * 			ProductCode:       pulumi.String("SA34VDG"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SerialNumber:      pulumi.String("64-103816-519918-8"),
 * 			SoftwareRevision:  pulumi.String("2.0"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.EventArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetEndpointProfileUri("https://www.example.com/myAssetEndpointProfile")
 *             .assetName("my-asset")
 *             .assetType("MyAssetType")
 *             .dataPoints(
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1")
 *                     .observabilityMode("counter")
 *                     .build(),
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2")
 *                     .observabilityMode("none")
 *                     .build())
 *             .defaultDataPointsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .defaultEventsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .description("This is a sample Asset")
 *             .documentationUri("https://www.example.com/manual")
 *             .enabled(true)
 *             .events(
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3")
 *                     .observabilityMode("none")
 *                     .build(),
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4")
 *                     .observabilityMode("log")
 *                     .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1")
 *                 .type("CustomLocation")
 *                 .build())
 *             .externalAssetId("8ZBA6LRHU0A458969")
 *             .hardwareRevision("1.0")
 *             .location("West Europe")
 *             .manufacturer("Contoso")
 *             .manufacturerUri("https://www.contoso.com/manufacturerUri")
 *             .model("ContosoModel")
 *             .productCode("SA34VDG")
 *             .resourceGroupName("myResourceGroup")
 *             .serialNumber("64-103816-519918-8")
 *             .softwareRevision("2.0")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset Without External Asset Id.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetEndpointProfileUri = "https://www.example.com/myAssetEndpointProfile",
 *         AssetName = "my-asset",
 *         AssetType = "MyAssetType",
 *         DataPoints = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.Counter,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.None,
 *             },
 *         },
 *         DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         Description = "This is a sample Asset",
 *         DisplayName = "AssetDisplayName",
 *         DocumentationUri = "https://www.example.com/manual",
 *         Enabled = true,
 *         Events = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.None,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.Log,
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         HardwareRevision = "1.0",
 *         Location = "West Europe",
 *         Manufacturer = "Contoso",
 *         ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *         Model = "ContosoModel",
 *         ProductCode = "SA34VDG",
 *         ResourceGroupName = "myResourceGroup",
 *         SerialNumber = "64-103816-519918-8",
 *         SoftwareRevision = "2.0",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetEndpointProfileUri: pulumi.String("https://www.example.com/myAssetEndpointProfile"),
 * 			AssetName:               pulumi.String("my-asset"),
 * 			AssetType:               pulumi.String("MyAssetType"),
 * 			DataPoints: deviceregistry.DataPointArray{
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeCounter),
 * 				},
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeNone),
 * 				},
 * 			},
 * 			DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			Description:                    pulumi.String("This is a sample Asset"),
 * 			DisplayName:                    pulumi.String("AssetDisplayName"),
 * 			DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 			Enabled:                        pulumi.Bool(true),
 * 			Events: deviceregistry.EventArray{
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeNone),
 * 				},
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeLog),
 * 				},
 * 			},
 * 			ExtendedLocation: &deviceregistry.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareRevision:  pulumi.String("1.0"),
 * 			Location:          pulumi.String("West Europe"),
 * 			Manufacturer:      pulumi.String("Contoso"),
 * 			ManufacturerUri:   pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 			Model:             pulumi.String("ContosoModel"),
 * 			ProductCode:       pulumi.String("SA34VDG"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SerialNumber:      pulumi.String("64-103816-519918-8"),
 * 			SoftwareRevision:  pulumi.String("2.0"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.EventArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetEndpointProfileUri("https://www.example.com/myAssetEndpointProfile")
 *             .assetName("my-asset")
 *             .assetType("MyAssetType")
 *             .dataPoints(
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1")
 *                     .observabilityMode("counter")
 *                     .build(),
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2")
 *                     .observabilityMode("none")
 *                     .build())
 *             .defaultDataPointsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .defaultEventsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .description("This is a sample Asset")
 *             .displayName("AssetDisplayName")
 *             .documentationUri("https://www.example.com/manual")
 *             .enabled(true)
 *             .events(
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3")
 *                     .observabilityMode("none")
 *                     .build(),
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4")
 *                     .observabilityMode("log")
 *                     .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareRevision("1.0")
 *             .location("West Europe")
 *             .manufacturer("Contoso")
 *             .manufacturerUri("https://www.contoso.com/manufacturerUri")
 *             .model("ContosoModel")
 *             .productCode("SA34VDG")
 *             .resourceGroupName("myResourceGroup")
 *             .serialNumber("64-103816-519918-8")
 *             .softwareRevision("2.0")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceregistry:Asset my-asset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assets/{assetName}
 * ```
 */
public class Asset internal constructor(
    override val javaResource: com.pulumi.azurenative.deviceregistry.Asset,
) : KotlinCustomResource(javaResource, AssetMapper) {
    /**
     * A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
     */
    public val assetEndpointProfileUri: Output<String>
        get() = javaResource.assetEndpointProfileUri().applyValue({ args0 -> args0 })

    /**
     * Resource path to asset type (model) definition.
     */
    public val assetType: Output<String>?
        get() = javaResource.assetType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A set of key-value pairs that contain custom attributes set by the customer.
     */
    public val attributes: Output<Any>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    public val dataPoints: Output<List<DataPointResponse>>?
        get() = javaResource.dataPoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> dataPointResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    public val defaultDataPointsConfiguration: Output<String>?
        get() = javaResource.defaultDataPointsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    public val defaultEventsConfiguration: Output<String>?
        get() = javaResource.defaultEventsConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Human-readable description of the asset.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Human-readable display name.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Reference to the documentation.
     */
    public val documentationUri: Output<String>?
        get() = javaResource.documentationUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enabled/Disabled status of the asset.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    public val events: Output<List<EventResponse>>?
        get() = javaResource.events().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> eventResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The extended location.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Asset id provided by the customer.
     */
    public val externalAssetId: Output<String>?
        get() = javaResource.externalAssetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Revision number of the hardware.
     */
    public val hardwareRevision: Output<String>?
        get() = javaResource.hardwareRevision().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Asset manufacturer name.
     */
    public val manufacturer: Output<String>?
        get() = javaResource.manufacturer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Asset manufacturer URI.
     */
    public val manufacturerUri: Output<String>?
        get() = javaResource.manufacturerUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Asset model name.
     */
    public val model: Output<String>?
        get() = javaResource.model().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Asset product code.
     */
    public val productCode: Output<String>?
        get() = javaResource.productCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Asset serial number.
     */
    public val serialNumber: Output<String>?
        get() = javaResource.serialNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Revision number of the software.
     */
    public val softwareRevision: Output<String>?
        get() = javaResource.softwareRevision().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Read only object to reflect changes that have occurred on the Edge. Similar to Kubernetes status property for custom resources.
     */
    public val status: Output<AssetStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                assetStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Globally unique, immutable, non-reusable id.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })

    /**
     * An integer that is incremented each time the resource is modified.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object AssetMapper : ResourceMapper<Asset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deviceregistry.Asset::class == javaResource::class

    override fun map(javaResource: Resource): Asset = Asset(
        javaResource as
            com.pulumi.azurenative.deviceregistry.Asset,
    )
}

/**
 * @see [Asset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Asset].
 */
public suspend fun asset(name: String, block: suspend AssetResourceBuilder.() -> Unit): Asset {
    val builder = AssetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Asset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun asset(name: String): Asset {
    val builder = AssetResourceBuilder()
    builder.name(name)
    return builder.build()
}
