@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin

import com.pulumi.azurenative.deviceregistry.AssetArgs.builder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.DataPointArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.DataPointArgsBuilder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.EventArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.EventArgsBuilder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Asset definition.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### Create an Asset With External Asset Id.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetEndpointProfileUri = "https://www.example.com/myAssetEndpointProfile",
 *         AssetName = "my-asset",
 *         AssetType = "MyAssetType",
 *         DataPoints = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.Counter,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.None,
 *             },
 *         },
 *         DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         Description = "This is a sample Asset",
 *         DisplayName = "AssetDisplayName",
 *         DocumentationUri = "https://www.example.com/manual",
 *         Enabled = true,
 *         Events = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.None,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.Log,
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         ExternalAssetId = "8ZBA6LRHU0A458969",
 *         HardwareRevision = "1.0",
 *         Location = "West Europe",
 *         Manufacturer = "Contoso",
 *         ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *         Model = "ContosoModel",
 *         ProductCode = "SA34VDG",
 *         ResourceGroupName = "myResourceGroup",
 *         SerialNumber = "64-103816-519918-8",
 *         SoftwareRevision = "2.0",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetEndpointProfileUri: pulumi.String("https://www.example.com/myAssetEndpointProfile"),
 * 			AssetName:               pulumi.String("my-asset"),
 * 			AssetType:               pulumi.String("MyAssetType"),
 * 			DataPoints: deviceregistry.DataPointArray{
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeCounter),
 * 				},
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeNone),
 * 				},
 * 			},
 * 			DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			Description:                    pulumi.String("This is a sample Asset"),
 * 			DisplayName:                    pulumi.String("AssetDisplayName"),
 * 			DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 			Enabled:                        pulumi.Bool(true),
 * 			Events: deviceregistry.EventArray{
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeNone),
 * 				},
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeLog),
 * 				},
 * 			},
 * 			ExtendedLocation: &deviceregistry.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			ExternalAssetId:   pulumi.String("8ZBA6LRHU0A458969"),
 * 			HardwareRevision:  pulumi.String("1.0"),
 * 			Location:          pulumi.String("West Europe"),
 * 			Manufacturer:      pulumi.String("Contoso"),
 * 			ManufacturerUri:   pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 			Model:             pulumi.String("ContosoModel"),
 * 			ProductCode:       pulumi.String("SA34VDG"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SerialNumber:      pulumi.String("64-103816-519918-8"),
 * 			SoftwareRevision:  pulumi.String("2.0"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.EventArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetEndpointProfileUri("https://www.example.com/myAssetEndpointProfile")
 *             .assetName("my-asset")
 *             .assetType("MyAssetType")
 *             .dataPoints(
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1")
 *                     .observabilityMode("counter")
 *                     .build(),
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2")
 *                     .observabilityMode("none")
 *                     .build())
 *             .defaultDataPointsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .defaultEventsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .description("This is a sample Asset")
 *             .displayName("AssetDisplayName")
 *             .documentationUri("https://www.example.com/manual")
 *             .enabled(true)
 *             .events(
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3")
 *                     .observabilityMode("none")
 *                     .build(),
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4")
 *                     .observabilityMode("log")
 *                     .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1")
 *                 .type("CustomLocation")
 *                 .build())
 *             .externalAssetId("8ZBA6LRHU0A458969")
 *             .hardwareRevision("1.0")
 *             .location("West Europe")
 *             .manufacturer("Contoso")
 *             .manufacturerUri("https://www.contoso.com/manufacturerUri")
 *             .model("ContosoModel")
 *             .productCode("SA34VDG")
 *             .resourceGroupName("myResourceGroup")
 *             .serialNumber("64-103816-519918-8")
 *             .softwareRevision("2.0")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset Without Display Name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetEndpointProfileUri = "https://www.example.com/myAssetEndpointProfile",
 *         AssetName = "my-asset",
 *         AssetType = "MyAssetType",
 *         DataPoints = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.Counter,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.None,
 *             },
 *         },
 *         DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         Description = "This is a sample Asset",
 *         DocumentationUri = "https://www.example.com/manual",
 *         Enabled = true,
 *         Events = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.None,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.Log,
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         ExternalAssetId = "8ZBA6LRHU0A458969",
 *         HardwareRevision = "1.0",
 *         Location = "West Europe",
 *         Manufacturer = "Contoso",
 *         ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *         Model = "ContosoModel",
 *         ProductCode = "SA34VDG",
 *         ResourceGroupName = "myResourceGroup",
 *         SerialNumber = "64-103816-519918-8",
 *         SoftwareRevision = "2.0",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetEndpointProfileUri: pulumi.String("https://www.example.com/myAssetEndpointProfile"),
 * 			AssetName:               pulumi.String("my-asset"),
 * 			AssetType:               pulumi.String("MyAssetType"),
 * 			DataPoints: deviceregistry.DataPointArray{
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeCounter),
 * 				},
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeNone),
 * 				},
 * 			},
 * 			DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			Description:                    pulumi.String("This is a sample Asset"),
 * 			DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 			Enabled:                        pulumi.Bool(true),
 * 			Events: deviceregistry.EventArray{
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeNone),
 * 				},
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeLog),
 * 				},
 * 			},
 * 			ExtendedLocation: &deviceregistry.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			ExternalAssetId:   pulumi.String("8ZBA6LRHU0A458969"),
 * 			HardwareRevision:  pulumi.String("1.0"),
 * 			Location:          pulumi.String("West Europe"),
 * 			Manufacturer:      pulumi.String("Contoso"),
 * 			ManufacturerUri:   pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 			Model:             pulumi.String("ContosoModel"),
 * 			ProductCode:       pulumi.String("SA34VDG"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SerialNumber:      pulumi.String("64-103816-519918-8"),
 * 			SoftwareRevision:  pulumi.String("2.0"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.EventArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetEndpointProfileUri("https://www.example.com/myAssetEndpointProfile")
 *             .assetName("my-asset")
 *             .assetType("MyAssetType")
 *             .dataPoints(
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1")
 *                     .observabilityMode("counter")
 *                     .build(),
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2")
 *                     .observabilityMode("none")
 *                     .build())
 *             .defaultDataPointsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .defaultEventsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .description("This is a sample Asset")
 *             .documentationUri("https://www.example.com/manual")
 *             .enabled(true)
 *             .events(
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3")
 *                     .observabilityMode("none")
 *                     .build(),
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4")
 *                     .observabilityMode("log")
 *                     .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1")
 *                 .type("CustomLocation")
 *                 .build())
 *             .externalAssetId("8ZBA6LRHU0A458969")
 *             .hardwareRevision("1.0")
 *             .location("West Europe")
 *             .manufacturer("Contoso")
 *             .manufacturerUri("https://www.contoso.com/manufacturerUri")
 *             .model("ContosoModel")
 *             .productCode("SA34VDG")
 *             .resourceGroupName("myResourceGroup")
 *             .serialNumber("64-103816-519918-8")
 *             .softwareRevision("2.0")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset Without External Asset Id.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetEndpointProfileUri = "https://www.example.com/myAssetEndpointProfile",
 *         AssetName = "my-asset",
 *         AssetType = "MyAssetType",
 *         DataPoints = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.Counter,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.DataPointArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                 DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.DataPointsObservabilityMode.None,
 *             },
 *         },
 *         DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *         Description = "This is a sample Asset",
 *         DisplayName = "AssetDisplayName",
 *         DocumentationUri = "https://www.example.com/manual",
 *         Enabled = true,
 *         Events = new[]
 *         {
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.None,
 *             },
 *             new AzureNative.DeviceRegistry.Inputs.EventArgs
 *             {
 *                 CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                 EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                 EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                 ObservabilityMode = AzureNative.DeviceRegistry.EventsObservabilityMode.Log,
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         HardwareRevision = "1.0",
 *         Location = "West Europe",
 *         Manufacturer = "Contoso",
 *         ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *         Model = "ContosoModel",
 *         ProductCode = "SA34VDG",
 *         ResourceGroupName = "myResourceGroup",
 *         SerialNumber = "64-103816-519918-8",
 *         SoftwareRevision = "2.0",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetEndpointProfileUri: pulumi.String("https://www.example.com/myAssetEndpointProfile"),
 * 			AssetName:               pulumi.String("my-asset"),
 * 			AssetType:               pulumi.String("MyAssetType"),
 * 			DataPoints: deviceregistry.DataPointArray{
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeCounter),
 * 				},
 * 				&deviceregistry.DataPointArgs{
 * 					CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 					DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 					ObservabilityMode:      pulumi.String(deviceregistry.DataPointsObservabilityModeNone),
 * 				},
 * 			},
 * 			DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 			Description:                    pulumi.String("This is a sample Asset"),
 * 			DisplayName:                    pulumi.String("AssetDisplayName"),
 * 			DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 			Enabled:                        pulumi.Bool(true),
 * 			Events: deviceregistry.EventArray{
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeNone),
 * 				},
 * 				&deviceregistry.EventArgs{
 * 					CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 					EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 					EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 					ObservabilityMode:  pulumi.String(deviceregistry.EventsObservabilityModeLog),
 * 				},
 * 			},
 * 			ExtendedLocation: &deviceregistry.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HardwareRevision:  pulumi.String("1.0"),
 * 			Location:          pulumi.String("West Europe"),
 * 			Manufacturer:      pulumi.String("Contoso"),
 * 			ManufacturerUri:   pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 			Model:             pulumi.String("ContosoModel"),
 * 			ProductCode:       pulumi.String("SA34VDG"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SerialNumber:      pulumi.String("64-103816-519918-8"),
 * 			SoftwareRevision:  pulumi.String("2.0"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.DataPointArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.EventArgs;
 * import com.pulumi.azurenative.deviceregistry.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetEndpointProfileUri("https://www.example.com/myAssetEndpointProfile")
 *             .assetName("my-asset")
 *             .assetType("MyAssetType")
 *             .dataPoints(
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1")
 *                     .observabilityMode("counter")
 *                     .build(),
 *                 DataPointArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .dataPointConfiguration("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}")
 *                     .dataSource("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2")
 *                     .observabilityMode("none")
 *                     .build())
 *             .defaultDataPointsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .defaultEventsConfiguration("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}")
 *             .description("This is a sample Asset")
 *             .displayName("AssetDisplayName")
 *             .documentationUri("https://www.example.com/manual")
 *             .enabled(true)
 *             .events(
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__temperature;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3")
 *                     .observabilityMode("none")
 *                     .build(),
 *                 EventArgs.builder()
 *                     .capabilityId("dtmi:com:example:Thermostat:__pressure;1")
 *                     .eventConfiguration("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}")
 *                     .eventNotifier("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4")
 *                     .observabilityMode("log")
 *                     .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1")
 *                 .type("CustomLocation")
 *                 .build())
 *             .hardwareRevision("1.0")
 *             .location("West Europe")
 *             .manufacturer("Contoso")
 *             .manufacturerUri("https://www.contoso.com/manufacturerUri")
 *             .model("ContosoModel")
 *             .productCode("SA34VDG")
 *             .resourceGroupName("myResourceGroup")
 *             .serialNumber("64-103816-519918-8")
 *             .softwareRevision("2.0")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceregistry:Asset my-asset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assets/{assetName}
 * ```
 * @property assetEndpointProfileUri A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
 * @property assetName Asset name parameter.
 * @property assetType Resource path to asset type (model) definition.
 * @property attributes A set of key-value pairs that contain custom attributes set by the customer.
 * @property dataPoints Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
 * @property defaultDataPointsConfiguration Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
 * @property defaultEventsConfiguration Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
 * @property description Human-readable description of the asset.
 * @property displayName Human-readable display name.
 * @property documentationUri Reference to the documentation.
 * @property enabled Enabled/Disabled status of the asset.
 * @property events Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
 * @property extendedLocation The extended location.
 * @property externalAssetId Asset id provided by the customer.
 * @property hardwareRevision Revision number of the hardware.
 * @property location The geo-location where the resource lives
 * @property manufacturer Asset manufacturer name.
 * @property manufacturerUri Asset manufacturer URI.
 * @property model Asset model name.
 * @property productCode Asset product code.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serialNumber Asset serial number.
 * @property softwareRevision Revision number of the software.
 * @property tags Resource tags.
 */
public data class AssetArgs(
    public val assetEndpointProfileUri: Output<String>? = null,
    public val assetName: Output<String>? = null,
    public val assetType: Output<String>? = null,
    public val attributes: Output<Any>? = null,
    public val dataPoints: Output<List<DataPointArgs>>? = null,
    public val defaultDataPointsConfiguration: Output<String>? = null,
    public val defaultEventsConfiguration: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val documentationUri: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val events: Output<List<EventArgs>>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val externalAssetId: Output<String>? = null,
    public val hardwareRevision: Output<String>? = null,
    public val location: Output<String>? = null,
    public val manufacturer: Output<String>? = null,
    public val manufacturerUri: Output<String>? = null,
    public val model: Output<String>? = null,
    public val productCode: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serialNumber: Output<String>? = null,
    public val softwareRevision: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.AssetArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.AssetArgs =
        com.pulumi.azurenative.deviceregistry.AssetArgs.builder()
            .assetEndpointProfileUri(assetEndpointProfileUri?.applyValue({ args0 -> args0 }))
            .assetName(assetName?.applyValue({ args0 -> args0 }))
            .assetType(assetType?.applyValue({ args0 -> args0 }))
            .attributes(attributes?.applyValue({ args0 -> args0 }))
            .dataPoints(
                dataPoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultDataPointsConfiguration(defaultDataPointsConfiguration?.applyValue({ args0 -> args0 }))
            .defaultEventsConfiguration(defaultEventsConfiguration?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .documentationUri(documentationUri?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .events(events?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .externalAssetId(externalAssetId?.applyValue({ args0 -> args0 }))
            .hardwareRevision(hardwareRevision?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .manufacturer(manufacturer?.applyValue({ args0 -> args0 }))
            .manufacturerUri(manufacturerUri?.applyValue({ args0 -> args0 }))
            .model(model?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 }))
            .softwareRevision(softwareRevision?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AssetArgs].
 */
@PulumiTagMarker
public class AssetArgsBuilder internal constructor() {
    private var assetEndpointProfileUri: Output<String>? = null

    private var assetName: Output<String>? = null

    private var assetType: Output<String>? = null

    private var attributes: Output<Any>? = null

    private var dataPoints: Output<List<DataPointArgs>>? = null

    private var defaultDataPointsConfiguration: Output<String>? = null

    private var defaultEventsConfiguration: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var documentationUri: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var events: Output<List<EventArgs>>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var externalAssetId: Output<String>? = null

    private var hardwareRevision: Output<String>? = null

    private var location: Output<String>? = null

    private var manufacturer: Output<String>? = null

    private var manufacturerUri: Output<String>? = null

    private var model: Output<String>? = null

    private var productCode: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serialNumber: Output<String>? = null

    private var softwareRevision: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
     */
    @JvmName("tucylaxgbwotexbc")
    public suspend fun assetEndpointProfileUri(`value`: Output<String>) {
        this.assetEndpointProfileUri = value
    }

    /**
     * @param value Asset name parameter.
     */
    @JvmName("vneyjjvfmeffvbae")
    public suspend fun assetName(`value`: Output<String>) {
        this.assetName = value
    }

    /**
     * @param value Resource path to asset type (model) definition.
     */
    @JvmName("llseblwolbjkdmtw")
    public suspend fun assetType(`value`: Output<String>) {
        this.assetType = value
    }

    /**
     * @param value A set of key-value pairs that contain custom attributes set by the customer.
     */
    @JvmName("cvfgmjpoyipuyixs")
    public suspend fun attributes(`value`: Output<Any>) {
        this.attributes = value
    }

    /**
     * @param value Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("jjajhmsuhjonmklm")
    public suspend fun dataPoints(`value`: Output<List<DataPointArgs>>) {
        this.dataPoints = value
    }

    @JvmName("iejhofxffjkrapnq")
    public suspend fun dataPoints(vararg values: Output<DataPointArgs>) {
        this.dataPoints = Output.all(values.asList())
    }

    /**
     * @param values Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("rnxkntfonnbpmyph")
    public suspend fun dataPoints(values: List<Output<DataPointArgs>>) {
        this.dataPoints = Output.all(values)
    }

    /**
     * @param value Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("ppwnhofxamfkfakm")
    public suspend fun defaultDataPointsConfiguration(`value`: Output<String>) {
        this.defaultDataPointsConfiguration = value
    }

    /**
     * @param value Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("obffnsohlgwtmblq")
    public suspend fun defaultEventsConfiguration(`value`: Output<String>) {
        this.defaultEventsConfiguration = value
    }

    /**
     * @param value Human-readable description of the asset.
     */
    @JvmName("daexliqhcskugsni")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Human-readable display name.
     */
    @JvmName("qynmrchqrtgqrkxg")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Reference to the documentation.
     */
    @JvmName("dunbnkdifvpfganj")
    public suspend fun documentationUri(`value`: Output<String>) {
        this.documentationUri = value
    }

    /**
     * @param value Enabled/Disabled status of the asset.
     */
    @JvmName("wlelueyduqvombfq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("vguqolkbhqeycxgm")
    public suspend fun events(`value`: Output<List<EventArgs>>) {
        this.events = value
    }

    @JvmName("iyxsxejfkuvycnxv")
    public suspend fun events(vararg values: Output<EventArgs>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("wuivwwceimfsvtkd")
    public suspend fun events(values: List<Output<EventArgs>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value The extended location.
     */
    @JvmName("ekkybpljaiebfvve")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Asset id provided by the customer.
     */
    @JvmName("litcdvfvrhulujdr")
    public suspend fun externalAssetId(`value`: Output<String>) {
        this.externalAssetId = value
    }

    /**
     * @param value Revision number of the hardware.
     */
    @JvmName("xxtnenhmanrlctvl")
    public suspend fun hardwareRevision(`value`: Output<String>) {
        this.hardwareRevision = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lskjyohvptkrsiwe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Asset manufacturer name.
     */
    @JvmName("nlidvdxyrwtqsmfu")
    public suspend fun manufacturer(`value`: Output<String>) {
        this.manufacturer = value
    }

    /**
     * @param value Asset manufacturer URI.
     */
    @JvmName("aaxnelbjsgrnduyu")
    public suspend fun manufacturerUri(`value`: Output<String>) {
        this.manufacturerUri = value
    }

    /**
     * @param value Asset model name.
     */
    @JvmName("pqswxutgcymifpjk")
    public suspend fun model(`value`: Output<String>) {
        this.model = value
    }

    /**
     * @param value Asset product code.
     */
    @JvmName("qjrnnvdjfcmfuquc")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mratpvsybsmtxmwt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Asset serial number.
     */
    @JvmName("aufsyildofbwvdob")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value Revision number of the software.
     */
    @JvmName("vhtjppschioxgopg")
    public suspend fun softwareRevision(`value`: Output<String>) {
        this.softwareRevision = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hddhhdjlypceksyb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
     */
    @JvmName("pmurgjkodstmscmw")
    public suspend fun assetEndpointProfileUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetEndpointProfileUri = mapped
    }

    /**
     * @param value Asset name parameter.
     */
    @JvmName("mmfnrrduekkxqqka")
    public suspend fun assetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetName = mapped
    }

    /**
     * @param value Resource path to asset type (model) definition.
     */
    @JvmName("dkkcliipmmgjfqpf")
    public suspend fun assetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetType = mapped
    }

    /**
     * @param value A set of key-value pairs that contain custom attributes set by the customer.
     */
    @JvmName("afhyesyqrasirniq")
    public suspend fun attributes(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("orpevtrvrumkquio")
    public suspend fun dataPoints(`value`: List<DataPointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("poirnnvjulagqhrf")
    public suspend fun dataPoints(argument: List<suspend DataPointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { DataPointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("oxfamdtdmtitmmdc")
    public suspend fun dataPoints(vararg argument: suspend DataPointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { DataPointArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("oduodocqyouegqay")
    public suspend fun dataPoints(argument: suspend DataPointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataPointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param values Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("fptqnnrdhppixrsl")
    public suspend fun dataPoints(vararg values: DataPointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPoints = mapped
    }

    /**
     * @param value Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("qctfnltqmhhoxbqi")
    public suspend fun defaultDataPointsConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDataPointsConfiguration = mapped
    }

    /**
     * @param value Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("loiufeuluegqmxgg")
    public suspend fun defaultEventsConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultEventsConfiguration = mapped
    }

    /**
     * @param value Human-readable description of the asset.
     */
    @JvmName("wvshxkpjdvmeyuwd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Human-readable display name.
     */
    @JvmName("shvevddxapblbxkp")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Reference to the documentation.
     */
    @JvmName("uorvjfcuqvqodtqk")
    public suspend fun documentationUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentationUri = mapped
    }

    /**
     * @param value Enabled/Disabled status of the asset.
     */
    @JvmName("opiogojvnigxnaug")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("wnlwlxlkymcutsrr")
    public suspend fun events(`value`: List<EventArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("ynitxqlvwqwhjoer")
    public suspend fun events(argument: List<suspend EventArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { EventArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("hwcslcqmdjgctefg")
    public suspend fun events(vararg argument: suspend EventArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { EventArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("xeglvmkhlcymylfl")
    public suspend fun events(argument: suspend EventArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EventArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param values Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("dwyvbrcjdsaqsvul")
    public suspend fun events(vararg values: EventArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value The extended location.
     */
    @JvmName("ogmehojvirikgygf")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location.
     */
    @JvmName("sconswpaeoobolew")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Asset id provided by the customer.
     */
    @JvmName("lfbfubhlksebuhxw")
    public suspend fun externalAssetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAssetId = mapped
    }

    /**
     * @param value Revision number of the hardware.
     */
    @JvmName("dopaaxxfomydopsn")
    public suspend fun hardwareRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareRevision = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("liekdcjlmdvavyer")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Asset manufacturer name.
     */
    @JvmName("lnmfeijouactdcxj")
    public suspend fun manufacturer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manufacturer = mapped
    }

    /**
     * @param value Asset manufacturer URI.
     */
    @JvmName("oaeojmllavkpfsyj")
    public suspend fun manufacturerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manufacturerUri = mapped
    }

    /**
     * @param value Asset model name.
     */
    @JvmName("nuvxupwklldyxcpd")
    public suspend fun model(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param value Asset product code.
     */
    @JvmName("tbggrgtshvwpjchf")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cnvcjyjfjbjxhwiy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Asset serial number.
     */
    @JvmName("xkgpqpuqjathvret")
    public suspend fun serialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value Revision number of the software.
     */
    @JvmName("auvrfnhwfjmxlkkc")
    public suspend fun softwareRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareRevision = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kndtknaqaafesnky")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rrbrjlmqyifejocw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AssetArgs = AssetArgs(
        assetEndpointProfileUri = assetEndpointProfileUri,
        assetName = assetName,
        assetType = assetType,
        attributes = attributes,
        dataPoints = dataPoints,
        defaultDataPointsConfiguration = defaultDataPointsConfiguration,
        defaultEventsConfiguration = defaultEventsConfiguration,
        description = description,
        displayName = displayName,
        documentationUri = documentationUri,
        enabled = enabled,
        events = events,
        extendedLocation = extendedLocation,
        externalAssetId = externalAssetId,
        hardwareRevision = hardwareRevision,
        location = location,
        manufacturer = manufacturer,
        manufacturerUri = manufacturerUri,
        model = model,
        productCode = productCode,
        resourceGroupName = resourceGroupName,
        serialNumber = serialNumber,
        softwareRevision = softwareRevision,
        tags = tags,
    )
}
