@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * An indication of how the data point should be mapped to OpenTelemetry.
 */
public enum class DataPointsObservabilityMode(
    public val javaValue: com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode> {
    /**
     * No mapping to OpenTelemetry.
     */
    None(com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode.None),

    /**
     * Map as counter to OpenTelemetry.
     */
    Counter(com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode.Counter),

    /**
     * Map as gauge to OpenTelemetry.
     */
    Gauge(com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode.Gauge),

    /**
     * Map as histogram to OpenTelemetry.
     */
    Histogram(com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode.Histogram),

    /**
     * Map as log to OpenTelemetry.
     */
    Log(com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode.Log),
    ;

    override fun toJava(): com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.enums.DataPointsObservabilityMode):
            DataPointsObservabilityMode =
            DataPointsObservabilityMode.values().first { it.javaValue == javaType }
    }
}
