@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * An indication of how the event should be mapped to OpenTelemetry.
 */
public enum class EventsObservabilityMode(
    public val javaValue: com.pulumi.azurenative.deviceregistry.enums.EventsObservabilityMode,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.enums.EventsObservabilityMode> {
    /**
     * No mapping to OpenTelemetry.
     */
    None(com.pulumi.azurenative.deviceregistry.enums.EventsObservabilityMode.None),

    /**
     * Map as log to OpenTelemetry.
     */
    Log(com.pulumi.azurenative.deviceregistry.enums.EventsObservabilityMode.Log),
    ;

    override fun toJava(): com.pulumi.azurenative.deviceregistry.enums.EventsObservabilityMode =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.enums.EventsObservabilityMode):
            EventsObservabilityMode =
            EventsObservabilityMode.values().first { it.javaValue == javaType }
    }
}
