@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.UserAuthenticationArgs.builder
import com.pulumi.azurenative.deviceregistry.kotlin.enums.UserAuthenticationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the client authentication mechanism to the server.
 * @property mode Defines the mode to authenticate the user of the client at the server.
 * @property usernamePasswordCredentials Defines the username and password references when UsernamePassword user authentication mode is selected.
 * @property x509Credentials Defines the certificate reference when Certificate user authentication mode is selected.
 */
public data class UserAuthenticationArgs(
    public val mode: Output<Either<String, UserAuthenticationMode>>,
    public val usernamePasswordCredentials: Output<UsernamePasswordCredentialsArgs>? = null,
    public val x509Credentials: Output<X509CredentialsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.UserAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.UserAuthenticationArgs =
        com.pulumi.azurenative.deviceregistry.inputs.UserAuthenticationArgs.builder()
            .mode(
                mode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .usernamePasswordCredentials(
                usernamePasswordCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .x509Credentials(
                x509Credentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserAuthenticationArgs].
 */
@PulumiTagMarker
public class UserAuthenticationArgsBuilder internal constructor() {
    private var mode: Output<Either<String, UserAuthenticationMode>>? = null

    private var usernamePasswordCredentials: Output<UsernamePasswordCredentialsArgs>? = null

    private var x509Credentials: Output<X509CredentialsArgs>? = null

    /**
     * @param value Defines the mode to authenticate the user of the client at the server.
     */
    @JvmName("binipqsiqsdcyyjw")
    public suspend fun mode(`value`: Output<Either<String, UserAuthenticationMode>>) {
        this.mode = value
    }

    /**
     * @param value Defines the username and password references when UsernamePassword user authentication mode is selected.
     */
    @JvmName("fcloaioupmdgpmja")
    public suspend fun usernamePasswordCredentials(`value`: Output<UsernamePasswordCredentialsArgs>) {
        this.usernamePasswordCredentials = value
    }

    /**
     * @param value Defines the certificate reference when Certificate user authentication mode is selected.
     */
    @JvmName("hdilusyajiyejgln")
    public suspend fun x509Credentials(`value`: Output<X509CredentialsArgs>) {
        this.x509Credentials = value
    }

    /**
     * @param value Defines the mode to authenticate the user of the client at the server.
     */
    @JvmName("rvuqppbfxsvpxtyl")
    public suspend fun mode(`value`: Either<String, UserAuthenticationMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Defines the mode to authenticate the user of the client at the server.
     */
    @JvmName("ahtlriwrapbyseaw")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UserAuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Defines the mode to authenticate the user of the client at the server.
     */
    @JvmName("qmipxywmtmcgcjic")
    public fun mode(`value`: UserAuthenticationMode) {
        val toBeMapped = Either.ofRight<String, UserAuthenticationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Defines the username and password references when UsernamePassword user authentication mode is selected.
     */
    @JvmName("akwsngrbcnpxmnnh")
    public suspend fun usernamePasswordCredentials(`value`: UsernamePasswordCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernamePasswordCredentials = mapped
    }

    /**
     * @param argument Defines the username and password references when UsernamePassword user authentication mode is selected.
     */
    @JvmName("maljniedipraxusc")
    public suspend
    fun usernamePasswordCredentials(argument: suspend UsernamePasswordCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = UsernamePasswordCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.usernamePasswordCredentials = mapped
    }

    /**
     * @param value Defines the certificate reference when Certificate user authentication mode is selected.
     */
    @JvmName("xpeflhsfljbyloqc")
    public suspend fun x509Credentials(`value`: X509CredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x509Credentials = mapped
    }

    /**
     * @param argument Defines the certificate reference when Certificate user authentication mode is selected.
     */
    @JvmName("qtoubosxbysmxrci")
    public suspend fun x509Credentials(argument: suspend X509CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = X509CredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.x509Credentials = mapped
    }

    internal fun build(): UserAuthenticationArgs = UserAuthenticationArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
        usernamePasswordCredentials = usernamePasswordCredentials,
        x509Credentials = x509Credentials,
    )
}
