@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.IotDpsResourceArgs.builder
import com.pulumi.azurenative.devices.kotlin.inputs.IotDpsPropertiesDescriptionArgs
import com.pulumi.azurenative.devices.kotlin.inputs.IotDpsPropertiesDescriptionArgsBuilder
import com.pulumi.azurenative.devices.kotlin.inputs.IotDpsSkuInfoArgs
import com.pulumi.azurenative.devices.kotlin.inputs.IotDpsSkuInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The description of the provisioning service.
 * Azure REST API version: 2022-12-12. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2020-09-01-preview, 2023-03-01-preview.
 * ## Example Usage
 * ### DPSCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotDpsResource = new AzureNative.Devices.IotDpsResource("iotDpsResource", new()
 *     {
 *         Location = "East US",
 *         Properties = new AzureNative.Devices.Inputs.IotDpsPropertiesDescriptionArgs
 *         {
 *             EnableDataResidency = false,
 *         },
 *         ProvisioningServiceName = "myFirstProvisioningService",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.Devices.Inputs.IotDpsSkuInfoArgs
 *         {
 *             Capacity = 1,
 *             Name = AzureNative.Devices.IotDpsSku.S1,
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewIotDpsResource(ctx, "iotDpsResource", &devices.IotDpsResourceArgs{
 * 			Location: pulumi.String("East US"),
 * 			Properties: &devices.IotDpsPropertiesDescriptionArgs{
 * 				EnableDataResidency: pulumi.Bool(false),
 * 			},
 * 			ProvisioningServiceName: pulumi.String("myFirstProvisioningService"),
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 			Sku: &devices.IotDpsSkuInfoArgs{
 * 				Capacity: pulumi.Float64(1),
 * 				Name:     pulumi.String(devices.IotDpsSkuS1),
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.IotDpsResource;
 * import com.pulumi.azurenative.devices.IotDpsResourceArgs;
 * import com.pulumi.azurenative.devices.inputs.IotDpsPropertiesDescriptionArgs;
 * import com.pulumi.azurenative.devices.inputs.IotDpsSkuInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotDpsResource = new IotDpsResource("iotDpsResource", IotDpsResourceArgs.builder()
 *             .location("East US")
 *             .properties(IotDpsPropertiesDescriptionArgs.builder()
 *                 .enableDataResidency(false)
 *                 .build())
 *             .provisioningServiceName("myFirstProvisioningService")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(IotDpsSkuInfoArgs.builder()
 *                 .capacity(1)
 *                 .name("S1")
 *                 .build())
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:IotDpsResource myFirstProvisioningService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}
 * ```
 * @property location The resource location.
 * @property properties Service specific properties for a provisioning service
 * @property provisioningServiceName Name of provisioning service to create or update.
 * @property resourceGroupName Resource group identifier.
 * @property resourcegroup The resource group of the resource.
 * @property sku Sku info for a provisioning Service.
 * @property subscriptionid The subscription id of the resource.
 * @property tags The resource tags.
 */
public data class IotDpsResourceArgs(
    public val location: Output<String>? = null,
    public val properties: Output<IotDpsPropertiesDescriptionArgs>? = null,
    public val provisioningServiceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourcegroup: Output<String>? = null,
    public val sku: Output<IotDpsSkuInfoArgs>? = null,
    public val subscriptionid: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.IotDpsResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.IotDpsResourceArgs =
        com.pulumi.azurenative.devices.IotDpsResourceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningServiceName(provisioningServiceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourcegroup(resourcegroup?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subscriptionid(subscriptionid?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IotDpsResourceArgs].
 */
@PulumiTagMarker
public class IotDpsResourceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<IotDpsPropertiesDescriptionArgs>? = null

    private var provisioningServiceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourcegroup: Output<String>? = null

    private var sku: Output<IotDpsSkuInfoArgs>? = null

    private var subscriptionid: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The resource location.
     */
    @JvmName("vhoxdenbwbdvlbyi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Service specific properties for a provisioning service
     */
    @JvmName("xokukrtdnhhbgolp")
    public suspend fun properties(`value`: Output<IotDpsPropertiesDescriptionArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of provisioning service to create or update.
     */
    @JvmName("qleflorbjgtohlua")
    public suspend fun provisioningServiceName(`value`: Output<String>) {
        this.provisioningServiceName = value
    }

    /**
     * @param value Resource group identifier.
     */
    @JvmName("pjevunhdfjnvxivn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource group of the resource.
     */
    @JvmName("mvdjfunqqwfemdfj")
    public suspend fun resourcegroup(`value`: Output<String>) {
        this.resourcegroup = value
    }

    /**
     * @param value Sku info for a provisioning Service.
     */
    @JvmName("mfoccimesjwmtwxh")
    public suspend fun sku(`value`: Output<IotDpsSkuInfoArgs>) {
        this.sku = value
    }

    /**
     * @param value The subscription id of the resource.
     */
    @JvmName("mevgghxjfwkwqusj")
    public suspend fun subscriptionid(`value`: Output<String>) {
        this.subscriptionid = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("stekrcqkaybkdssi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("weivumywxdvmvylw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Service specific properties for a provisioning service
     */
    @JvmName("oiakdbxxcufmekyh")
    public suspend fun properties(`value`: IotDpsPropertiesDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Service specific properties for a provisioning service
     */
    @JvmName("goguscguegajssma")
    public suspend
    fun properties(argument: suspend IotDpsPropertiesDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = IotDpsPropertiesDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of provisioning service to create or update.
     */
    @JvmName("vggaywmprcnxstui")
    public suspend fun provisioningServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningServiceName = mapped
    }

    /**
     * @param value Resource group identifier.
     */
    @JvmName("udmorxwjqufkfbep")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource group of the resource.
     */
    @JvmName("brfkqcuxiwbtonam")
    public suspend fun resourcegroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcegroup = mapped
    }

    /**
     * @param value Sku info for a provisioning Service.
     */
    @JvmName("lbyvbcfgimyjklun")
    public suspend fun sku(`value`: IotDpsSkuInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku info for a provisioning Service.
     */
    @JvmName("jtdxvqcsrrordevy")
    public suspend fun sku(argument: suspend IotDpsSkuInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IotDpsSkuInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The subscription id of the resource.
     */
    @JvmName("bnrfcyddiugvdodx")
    public suspend fun subscriptionid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionid = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("adubeoqrmvhjrjsx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("jqjvvbmmmpmnwokd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IotDpsResourceArgs = IotDpsResourceArgs(
        location = location,
        properties = properties,
        provisioningServiceName = provisioningServiceName,
        resourceGroupName = resourceGroupName,
        resourcegroup = resourcegroup,
        sku = sku,
        subscriptionid = subscriptionid,
        tags = tags,
    )
}
