@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse
import com.pulumi.azurenative.devices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.devices.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse.Companion.toKotlin as privateEndpointConnectionPropertiesResponseToKotlin
import com.pulumi.azurenative.devices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [IotDpsResourcePrivateEndpointConnection].
 */
@PulumiTagMarker
public class IotDpsResourcePrivateEndpointConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IotDpsResourcePrivateEndpointConnectionArgs =
        IotDpsResourcePrivateEndpointConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend IotDpsResourcePrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val builder = IotDpsResourcePrivateEndpointConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IotDpsResourcePrivateEndpointConnection {
        val builtJavaResource =
            com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IotDpsResourcePrivateEndpointConnection(builtJavaResource)
    }
}

/**
 * The private endpoint connection of a provisioning service
 * Azure REST API version: 2022-12-12. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2023-03-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnection_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotDpsResourcePrivateEndpointConnection = new AzureNative.Devices.IotDpsResourcePrivateEndpointConnection("iotDpsResourcePrivateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "myPrivateEndpointConnection",
 *         Properties = new AzureNative.Devices.Inputs.PrivateEndpointConnectionPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.Devices.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 Description = "Approved by johndoe@contoso.com",
 *                 Status = AzureNative.Devices.PrivateLinkServiceConnectionStatus.Approved,
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myFirstProvisioningService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewIotDpsResourcePrivateEndpointConnection(ctx, "iotDpsResourcePrivateEndpointConnection", &devices.IotDpsResourcePrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("myPrivateEndpointConnection"),
 * 			Properties: &devices.PrivateEndpointConnectionPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &devices.PrivateLinkServiceConnectionStateArgs{
 * 					Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 					Status:      pulumi.String(devices.PrivateLinkServiceConnectionStatusApproved),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("myFirstProvisioningService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnection;
 * import com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionPropertiesArgs;
 * import com.pulumi.azurenative.devices.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotDpsResourcePrivateEndpointConnection = new IotDpsResourcePrivateEndpointConnection("iotDpsResourcePrivateEndpointConnection", IotDpsResourcePrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("myPrivateEndpointConnection")
 *             .properties(PrivateEndpointConnectionPropertiesArgs.builder()
 *                 .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                     .description("Approved by johndoe@contoso.com")
 *                     .status("Approved")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myFirstProvisioningService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:IotDpsResourcePrivateEndpointConnection myPrivateEndpointConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class IotDpsResourcePrivateEndpointConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnection,
) : KotlinCustomResource(javaResource, IotDpsResourcePrivateEndpointConnectionMapper) {
    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of a private endpoint connection
     */
    public val properties: Output<PrivateEndpointConnectionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                privateEndpointConnectionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IotDpsResourcePrivateEndpointConnectionMapper :
    ResourceMapper<IotDpsResourcePrivateEndpointConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnection::class == javaResource::class

    override fun map(javaResource: Resource): IotDpsResourcePrivateEndpointConnection =
        IotDpsResourcePrivateEndpointConnection(
            javaResource as
                com.pulumi.azurenative.devices.IotDpsResourcePrivateEndpointConnection,
        )
}

/**
 * @see [IotDpsResourcePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IotDpsResourcePrivateEndpointConnection].
 */
public suspend fun iotDpsResourcePrivateEndpointConnection(
    name: String,
    block: suspend IotDpsResourcePrivateEndpointConnectionResourceBuilder.() -> Unit,
):
    IotDpsResourcePrivateEndpointConnection {
    val builder = IotDpsResourcePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IotDpsResourcePrivateEndpointConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iotDpsResourcePrivateEndpointConnection(name: String):
    IotDpsResourcePrivateEndpointConnection {
    val builder = IotDpsResourcePrivateEndpointConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
